/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.ability.api.FscBillEcomCheckApplyAbilityService;
import com.tydic.fsc.ability.api.bo.FscBillEcomCheckApplyAbilityReqBO;
import com.tydic.fsc.ability.api.bo.FscBillEcomCheckApplyAbilityRspBO;
import com.tydic.fsc.busi.api.FscBillEcomCheckApplyBusiService;
import com.tydic.fsc.busi.api.bo.FscBillEcomCheckApplyBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscBillEcomCheckApplyBusiRspBO;
import com.tydic.fsc.common.bo.RelOrderBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.external.utils.BigDecimalConvert;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscBillEcomCheckApplyAbilityService.class)
public class FscBillEcomCheckApplyAbilityServiceImpl
implements FscBillEcomCheckApplyAbilityService {
    @Autowired
    private FscBillEcomCheckApplyBusiService fscBillEcomCheckApplyBusiService;
    @Resource(name="fscInvoiceEcomCheck")
    private ProxyMessageProducer fscInvoiceEcomCheckProvider;
    @Value(value="${FSC_BILL_ECOM_CHECK_TOPIC:FSC_BILL_ECOM_CHECK_TOPIC}")
    private String FSC_BILL_ECOM_CHECK_TOPIC;
    @Value(value="${FSC_BILL_ECOM_CHECK_TAG:*}")
    private String FSC_BILL_ECOM_CHECK_TAG;

    @BigDecimalConvert
    @FscDuplicateCommitLimit
    public FscBillEcomCheckApplyAbilityRspBO dealEcomCheckApply(FscBillEcomCheckApplyAbilityReqBO reqBO) {
        this.val(reqBO);
        String jsonString = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        FscBillEcomCheckApplyBusiReqBO busiReqBO = (FscBillEcomCheckApplyBusiReqBO)JSON.parseObject((String)jsonString, FscBillEcomCheckApplyBusiReqBO.class);
        FscBillEcomCheckApplyBusiRspBO busiRspBO = this.fscBillEcomCheckApplyBusiService.dealEcomCheckApply(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("188684", busiRspBO.getRespDesc());
        }
        this.fscInvoiceEcomCheckProvider.send(new ProxyMessage(this.FSC_BILL_ECOM_CHECK_TOPIC, this.FSC_BILL_ECOM_CHECK_TAG, JSON.toJSONString((Object)reqBO)));
        return new FscBillEcomCheckApplyAbilityRspBO();
    }

    private void val(FscBillEcomCheckApplyAbilityReqBO reqBO) {
        if (null == reqBO.getSupplierId()) {
            throw new FscBusinessException("184000", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getRelOrderList() || reqBO.getRelOrderList().size() == 0) {
            throw new FscBusinessException("184000", "\u5165\u53c2[relOrderList]\u4e3a\u7a7a");
        }
        if (reqBO.getRelOrderList().size() != 0) {
            List relOrderList = reqBO.getRelOrderList();
            for (RelOrderBO relOrderBO : relOrderList) {
                if (null == relOrderBO.getAcceptOrderId()) {
                    throw new FscBusinessException("184000", "\u5165\u53c2[acceptOrderId]\u4e3a\u7a7a");
                }
                if (null == relOrderBO.getOrderId()) {
                    throw new FscBusinessException("184000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
                }
                if (!StringUtils.hasText((String)relOrderBO.getOtherNo())) {
                    throw new FscBusinessException("184000", "\u5165\u53c2[otherNo]\u4e3a\u7a7a");
                }
                if (null != relOrderBO.getMyAmount()) continue;
                throw new FscBusinessException("184000", "\u5165\u53c2[myAmount]\u4e3a\u7a7a");
            }
        }
    }
}

