/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.ability.api.FscBillSupplierCheckAbilityService;
import com.tydic.fsc.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.ability.api.bo.FscBillSupplierCheckAbilityReqBO;
import com.tydic.fsc.ability.api.bo.FscBillSupplierCheckAbilityRspBO;
import com.tydic.fsc.ability.api.bo.FscBillSupplierCheckOrderItemBO;
import com.tydic.fsc.ability.api.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.busi.api.FscBillSupplierCheckBusiService;
import com.tydic.fsc.busi.api.bo.FscBillSupplierCheckBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscBillSupplierCheckBusiRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.external.utils.BigDecimalConvert;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscBillSupplierCheckAbilityService.class)
public class FscBillSupplierCheckAbilityServiceImpl
implements FscBillSupplierCheckAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSupplierCheckAbilityServiceImpl.class);
    @Autowired
    private FscBillSupplierCheckBusiService fscBillSupplierCheckBusiService;
    private static final Integer SUBMIT_FAIL = 1;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @BigDecimalConvert
    public FscBillSupplierCheckAbilityRspBO dealSupplierCheck(FscBillSupplierCheckAbilityReqBO reqBO) {
        this.verification(reqBO);
        String jsonString = JSON.toJSONString((Object)reqBO);
        FscBillSupplierCheckBusiReqBO busiReqBO = (FscBillSupplierCheckBusiReqBO)JSON.parseObject((String)jsonString, FscBillSupplierCheckBusiReqBO.class);
        FscBillSupplierCheckBusiRspBO busiRspBO = this.fscBillSupplierCheckBusiService.dealSupplierCheck(busiReqBO, "2");
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("188666", busiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        return new FscBillSupplierCheckAbilityRspBO();
    }

    private void sendMq(FscBillSupplierCheckAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void verification(FscBillSupplierCheckAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("184000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("184000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new FscBusinessException("184000", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getRelOrderList() || reqBO.getRelOrderList().size() == 0) {
            throw new FscBusinessException("184000", "\u5165\u53c2[relOrderList]\u4e3a\u7a7a");
        }
        List relOrderList = reqBO.getRelOrderList();
        for (FscBillSupplierCheckOrderItemBO relOrderBO : relOrderList) {
            if (null == relOrderBO.getOrderId()) {
                throw new FscBusinessException("184000", "\u5165\u53c2[relOrderList]\u4e2d[orderId]\u4e3a\u7a7a");
            }
            if (null == relOrderBO.getAcceptOrderId()) {
                throw new FscBusinessException("184000", "\u5165\u53c2[relOrderList]\u4e2d[acceptOrderId]\u4e3a\u7a7a");
            }
            if (null == relOrderBO.getAmount()) {
                throw new FscBusinessException("184000", "\u5165\u53c2[relOrderList]\u4e2d[amount]\u4e3a\u7a7a");
            }
            if (null == relOrderBO.getRelAmount()) {
                throw new FscBusinessException("184000", "\u4f9b\u5e94\u5546\u53ef\u7ed3\u7b97\u91d1\u989d\u4e3a\u7a7a");
            }
            if (null == relOrderBO.getRelOrderitemList() || relOrderBO.getRelOrderitemList().size() == 0) {
                throw new FscBusinessException("184000", "\u5165\u53c2[relOrderList]\u4e2d[relOrderitemList]\u4e3a\u7a7a");
            }
            List relOrderitemList = relOrderBO.getRelOrderitemList();
            relOrderitemList.forEach(relOrderItemBO -> {
                if (null == relOrderItemBO.getOtherNum()) {
                    throw new FscBusinessException("184000", "\u4f9b\u5e94\u5546\u53ef\u7ed3\u7b97\u6570\u91cf\u5fc5\u586b");
                }
                if (relOrderItemBO.getNum().compareTo(relOrderItemBO.getOtherNum()) != 0 && StringUtils.isBlank((CharSequence)relOrderItemBO.getRemark())) {
                    throw new FscBusinessException("184000", "\u6570\u91cf\u4e0d\u4e00\u81f4\u65f6\uff0c\u5dee\u5f02\u539f\u56e0\u4e3a\u5fc5\u586b\u9879");
                }
            });
        }
    }
}

