/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.ability.api.FscBillTaxListQueryAbilityService;
import com.tydic.fsc.ability.api.FscComOrderListPageQueryAbilityService;
import com.tydic.fsc.ability.api.FscOrderItemDetailQueryAbilityService;
import com.tydic.fsc.ability.api.bo.FscBillTaxListDetailEntityQueryBO;
import com.tydic.fsc.ability.api.bo.FscBillTaxListQueryAbilityReqBO;
import com.tydic.fsc.ability.api.bo.FscBillTaxListQueryAbilityRspBO;
import com.tydic.fsc.ability.api.bo.FscBillTaxListResultQueryBO;
import com.tydic.fsc.ability.api.bo.FscComOrderListBO;
import com.tydic.fsc.ability.api.bo.FscComOrderListQueryAbilityReqBO;
import com.tydic.fsc.ability.api.bo.FscComOrderListQueryAbilityRspBO;
import com.tydic.fsc.ability.api.bo.FscOrderItemDetailBO;
import com.tydic.fsc.ability.api.bo.FscOrderItemDetailQueryAbilityReqBO;
import com.tydic.fsc.ability.api.bo.FscOrderItemDetailQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.po.FscOrderInvoicePO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.external.utils.BigDecimalConvert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscBillTaxListQueryAbilityService.class)
public class FscBillTaxListQueryAbilityServiceImpl
implements FscBillTaxListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillTaxListQueryAbilityServiceImpl.class);
    @Autowired
    private FscOrderItemDetailQueryAbilityService fscOrderItemDetailQueryAbilityService;
    @Autowired
    private FscComOrderListPageQueryAbilityService fscComOrderListPageQueryAbilityService;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Value(value="${FSC_TAX_COMPANY_NO:FSC_TAX_COMPANY_NO}")
    private String FSC_TAX_COMPANY_NO;

    @BigDecimalConvert
    public FscBillTaxListQueryAbilityRspBO qryBillTaxList(FscBillTaxListQueryAbilityReqBO reqBO) {
        FscComOrderListQueryAbilityReqBO fscComOrderListQueryAbilityReqBO = new FscComOrderListQueryAbilityReqBO();
        fscComOrderListQueryAbilityReqBO.setMakeType(FscConstants.FscOrderMakeType.OPERTION);
        fscComOrderListQueryAbilityReqBO.setReceiveType(FscConstants.FscOrderReceiveType.PURCHASE);
        ArrayList<Integer> integers = new ArrayList<Integer>();
        integers.add(FscConstants.OrderFlow.INVOICE);
        fscComOrderListQueryAbilityReqBO.setOrderFlows(integers);
        ArrayList<Integer> integers1 = new ArrayList<Integer>();
        integers1.add(FscConstants.FscInvoiceOrderState.SUBMITTING);
        fscComOrderListQueryAbilityReqBO.setOrderStates(integers1);
        FscComOrderListQueryAbilityRspBO comOrderListPageQuery = this.fscComOrderListPageQueryAbilityService.getComOrderListPageQuery(fscComOrderListQueryAbilityReqBO);
        if (!"0000".equals(comOrderListPageQuery.getRespCode())) {
            throw new FscBusinessException("188686", comOrderListPageQuery.getRespDesc());
        }
        if (null != comOrderListPageQuery && comOrderListPageQuery.getRows() != null && comOrderListPageQuery.getRows().size() > 0) {
            List fscOrderIds = comOrderListPageQuery.getRows().stream().map(fscComOrderListBO -> fscComOrderListBO.getFscOrderId()).collect(Collectors.toList());
            log.info("==============================fscOrderIds" + fscOrderIds);
            FscBillTaxListQueryAbilityRspBO fscBillTaxListQueryAbilityRspBO = (FscBillTaxListQueryAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)comOrderListPageQuery), FscBillTaxListQueryAbilityRspBO.class);
            FscOrderInvoicePO fscOrderInvoicePO2 = new FscOrderInvoicePO();
            fscOrderInvoicePO2.setFscOrderIdList(fscOrderIds);
            List fscOrderInvoicePOList = this.fscOrderInvoiceMapper.getList(fscOrderInvoicePO2);
            Map<Long, FscOrderInvoicePO> collect = fscOrderInvoicePOList.stream().collect(Collectors.toMap(FscOrderInvoicePO::getFscOrderId, fscOrderInvoicePO -> fscOrderInvoicePO));
            FscOrderItemDetailQueryAbilityReqBO fscOrderItemDetailQueryAbilityReqBO = new FscOrderItemDetailQueryAbilityReqBO();
            fscOrderItemDetailQueryAbilityReqBO.setFscOrderIdList(fscOrderIds);
            FscOrderItemDetailQueryAbilityRspBO fscOrderItemDetailQueryAbilityRspBO = this.fscOrderItemDetailQueryAbilityService.queryOrderItemDetail(fscOrderItemDetailQueryAbilityReqBO);
            if (!fscOrderItemDetailQueryAbilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException("188686", fscOrderItemDetailQueryAbilityRspBO.getRespDesc());
            }
            log.info("==============================fscOrderItemDetailQueryAbilityRspBO" + fscOrderItemDetailQueryAbilityRspBO);
            for (FscComOrderListBO fscComOrderListBO2 : comOrderListPageQuery.getRows()) {
                FscBillTaxListResultQueryBO fscBillTaxListResultQueryBO = new FscBillTaxListResultQueryBO();
                FscOrderInvoicePO fscOrderInvoicePO3 = collect.get(fscComOrderListBO2.getFscOrderId());
                fscBillTaxListResultQueryBO.setBusiType(reqBO.getBusiType());
                fscBillTaxListResultQueryBO.setOrderNo(fscComOrderListBO2.getFscOrderNo());
                fscBillTaxListResultQueryBO.setYCompanyNo(this.FSC_TAX_COMPANY_NO);
                fscBillTaxListResultQueryBO.setCOrgnCode(fscComOrderListBO2.getSupplierId().toString());
                fscBillTaxListResultQueryBO.setCustName(fscOrderInvoicePO3.getBuyName());
                fscBillTaxListResultQueryBO.setCustTaxNo(fscOrderInvoicePO3.getTaxNo());
                fscBillTaxListResultQueryBO.setCustAddrPhone(fscOrderInvoicePO3.getAddress() + " " + fscOrderInvoicePO3.getPhone());
                fscBillTaxListResultQueryBO.setCustBankAccount(fscOrderInvoicePO3.getBank() + " " + fscOrderInvoicePO3.getAccount());
                Integer invoiceCategory = fscOrderInvoicePO3.getInvoiceCategory();
                if (invoiceCategory.equals(FscConstants.FscElecInvoiceType.GENERAL)) {
                    fscBillTaxListResultQueryBO.setInvType(FscConstants.FscTaxInvType.GENERAL);
                } else if (invoiceCategory.equals(FscConstants.FscElecInvoiceType.ELEC)) {
                    fscBillTaxListResultQueryBO.setInvType(FscConstants.FscTaxInvType.ELEC);
                } else {
                    fscBillTaxListResultQueryBO.setInvType(FscConstants.FscTaxInvType.SPECIAL);
                }
                fscBillTaxListResultQueryBO.setInvRemark(null);
                fscBillTaxListResultQueryBO.setDrawer(fscOrderInvoicePO3.getBillOperId());
                fscBillTaxListResultQueryBO.setPayer(fscOrderInvoicePO3.getReceiveName());
                fscBillTaxListResultQueryBO.setExpressTelphone(fscOrderInvoicePO3.getReceivePhone());
                fscBillTaxListResultQueryBO.setExpressAddress(fscOrderInvoicePO3.getAddress());
                fscBillTaxListResultQueryBO.setExpressCity(fscOrderInvoicePO3.getCity());
                fscBillTaxListResultQueryBO.setCustEmail(fscOrderInvoicePO3.getReceiveEmail());
                fscBillTaxListResultQueryBO.setCustTelephone(fscOrderInvoicePO3.getPhone());
                ArrayList fscBillTaxListDetailEntityQueryBOS = new ArrayList();
                for (FscOrderItemDetailBO fscOrderItemDetailBO : fscOrderItemDetailQueryAbilityRspBO.getFscOrderItemDetailBOS()) {
                    if (!fscOrderItemDetailBO.getFscOrderId().equals(fscComOrderListBO2.getFscOrderId())) continue;
                    FscBillTaxListDetailEntityQueryBO fscBillTaxListDetailEntityQueryBO = new FscBillTaxListDetailEntityQueryBO();
                    BeanUtils.copyProperties((Object)fscOrderItemDetailBO, (Object)fscBillTaxListDetailEntityQueryBO);
                    fscBillTaxListDetailEntityQueryBO.setGoodsNo(fscOrderItemDetailBO.getSkuNo());
                    fscBillTaxListDetailEntityQueryBO.setInspectionId(fscOrderItemDetailBO.getAcceptOrderId());
                    fscBillTaxListDetailEntityQueryBO.setGoodsName(fscOrderItemDetailBO.getSkuName());
                    fscBillTaxListDetailEntityQueryBO.setLineCode(null);
                    fscBillTaxListDetailEntityQueryBO.setQty(fscOrderItemDetailBO.getNum());
                    fscBillTaxListDetailEntityQueryBO.setTaxPrice(fscOrderItemDetailBO.getAmt().divide(fscOrderItemDetailBO.getNum(), 10));
                    fscBillTaxListDetailEntityQueryBO.setAmount(fscOrderItemDetailBO.getTaxAmt());
                    fscBillTaxListDetailEntityQueryBO.setTax(fscOrderItemDetailBO.getTaxAmt());
                    fscBillTaxListDetailEntityQueryBO.setTaxAmount(fscOrderItemDetailBO.getAmt());
                    fscBillTaxListDetailEntityQueryBO.setTaxPre(Integer.valueOf(0));
                }
            }
            return fscBillTaxListQueryAbilityRspBO;
        }
        return new FscBillTaxListQueryAbilityRspBO();
    }
}

