/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.tydic.fsc.ability.api.FscCheckResultQryAbilityService;
import com.tydic.fsc.ability.api.bo.FscCheckResultQryAbilityReqBO;
import com.tydic.fsc.ability.api.bo.FscCheckResultQryAbilityRspBO;
import com.tydic.fsc.common.bo.RelOrderBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.dao.po.FscCheckResultPO;
import com.tydic.fsc.external.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscCheckResultQryAbilityService.class)
public class FscCheckResultQryAbilityServiceImpl
implements FscCheckResultQryAbilityService {
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;

    @BigDecimalConvert
    public FscCheckResultQryAbilityRspBO dealEcomCheck(FscCheckResultQryAbilityReqBO reqBO) {
        FscCheckResultPO fscCheckResultPo = new FscCheckResultPO();
        if (null != reqBO.getOperSn()) {
            fscCheckResultPo.setOperSn(reqBO.getOperSn());
        }
        if (null != reqBO.getCheckTimeStart()) {
            fscCheckResultPo.setCheckTimeStart(reqBO.getCheckTimeStart());
        }
        if (null != reqBO.getCheckTimeEnd()) {
            fscCheckResultPo.setCheckTimeEnd(reqBO.getCheckTimeEnd());
        }
        if (null != reqBO.getRelOrderList() && reqBO.getRelOrderList().size() != 0) {
            List acceptOrderIds = reqBO.getRelOrderList().stream().map(RelOrderBO::getAcceptOrderId).collect(Collectors.toList());
            fscCheckResultPo.setAcceptOrderIds(acceptOrderIds);
        }
        List fscCheckResultPos = this.fscCheckResultMapper.getList(fscCheckResultPo);
        List relOrderBos = JSON.parseArray((String)JSON.toJSONString((Object)fscCheckResultPos), RelOrderBO.class);
        Map<Long, RelOrderBO> relOrderBOMap = reqBO.getRelOrderList().stream().collect(Collectors.toMap(RelOrderBO::getAcceptOrderId, relOrderBO -> relOrderBO));
        List equalsReOrderBos = relOrderBos.stream().filter(relOrderBO -> FscConstants.BillCheck.EQUALS.equals(relOrderBO.getStatus())).map(relOrderBO -> {
            RelOrderBO relOrder = (RelOrderBO)relOrderBOMap.get(relOrderBO.getAcceptOrderId());
            relOrder.setMyAmount(relOrderBO.getAmount());
            relOrder.setAmount(relOrderBO.getAmount());
            relOrder.setSaleAmount(relOrderBO.getSaleAmount());
            return relOrder;
        }).collect(Collectors.toList());
        List notEqualsReOrderBos = relOrderBos.stream().filter(relOrderBO -> FscConstants.BillCheck.NOT_EQUALS.equals(relOrderBO.getStatus())).collect(Collectors.toList());
        BigDecimal equalsPurAmt = equalsReOrderBos.stream().map(RelOrderBO::getMyAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal equalsSaleAmt = equalsReOrderBos.stream().map(RelOrderBO::getSaleAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        FscCheckResultQryAbilityRspBO rspBO = new FscCheckResultQryAbilityRspBO();
        rspBO.setOrderNum(Integer.valueOf(relOrderBos.size()));
        rspBO.setOrderYesNum(Integer.valueOf(equalsReOrderBos.size()));
        rspBO.setRelOrderYesList(equalsReOrderBos);
        rspBO.setOrderNoNum(Integer.valueOf(notEqualsReOrderBos.size()));
        rspBO.setRelOrderNoList(notEqualsReOrderBos);
        rspBO.setOrderYesPurAmt(equalsPurAmt);
        rspBO.setOrderYesSaleAmt(equalsSaleAmt);
        int waitNum = reqBO.getRelOrderList().size() - equalsReOrderBos.size() - notEqualsReOrderBos.size();
        rspBO.setOrderWaitNum(Integer.valueOf(waitNum));
        return rspBO;
    }
}

