/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.atom.api.FscOrderFailLogUpdateAtomService;
import com.tydic.fsc.atom.api.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.atom.api.bo.FscOrderFailLogUpdateAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscOrderFailLogUpdateAtomRspBO;
import com.tydic.fsc.busi.api.FscBillEcomCheckBusiService;
import com.tydic.fsc.busi.api.bo.FscBillEcomCheckBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscBillEcomCheckBusiRspBO;
import com.tydic.fsc.common.bo.FscOrderInfoBO;
import com.tydic.fsc.common.bo.FscOrderItemBO;
import com.tydic.fsc.common.bo.RelOrderBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultItemMapper;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.dao.po.FscCheckResultItemPO;
import com.tydic.fsc.dao.po.FscCheckResultPO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.external.api.bo.FscBillCheckOrderAccountReqBO;
import com.tydic.fsc.external.api.bo.FscBillCheckOrderAccountRspBO;
import com.tydic.fsc.external.api.bo.FscCheckOrderEntity;
import com.tydic.fsc.external.api.bo.FscUocOrderSyncCheckStatusReqBO;
import com.tydic.fsc.external.api.bo.FscUocOrderSyncCheckStatusRspBO;
import com.tydic.fsc.external.api.esb.FscBillCheckOrderAccountService;
import com.tydic.fsc.external.api.uoc.FscUocOrderSyncCheckStatusAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillEcomCheckBusiServiceImpl
implements FscBillEcomCheckBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillEcomCheckBusiServiceImpl.class);
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscCheckResultItemMapper fscCheckResultItemMapper;
    @Autowired
    private FscBillCheckOrderAccountService fscBillCheckOrderAccountService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscUocOrderSyncCheckStatusAbilityService fscUocOrderSyncCheckStatusAbilityService;
    @Autowired
    private FscOrderFailLogUpdateAtomService fscOrderFailLogUpdateAtomService;
    public static final String OPER_TYPE = "2";

    public FscBillEcomCheckBusiRspBO dealEcomCheck(FscBillEcomCheckBusiReqBO reqBO) {
        List relOrderList = reqBO.getRelOrderList();
        List<Long> acceptIds = relOrderList.stream().map(RelOrderBO::getAcceptOrderId).collect(Collectors.toList());
        FscCheckResultPO fscCheckResult = new FscCheckResultPO();
        fscCheckResult.setAcceptOrderIds(acceptIds);
        List fscCheckResultPoList = this.fscCheckResultMapper.getList(fscCheckResult);
        if (CollectionUtils.isEmpty((Collection)fscCheckResultPoList)) {
            return new FscBillEcomCheckBusiRspBO();
        }
        List otherNos = fscCheckResultPoList.stream().map(FscCheckResultPO::getOtherNo).collect(Collectors.toList());
        FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
        fscAcceptOrderListQueryAtomReqBO.setInspectionVoucherIdList(acceptIds);
        fscAcceptOrderListQueryAtomReqBO.setPageSize(Integer.valueOf(acceptIds.size()));
        FscAcceptOrderListQueryAtomRspBO queryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
        if (!"0000".equals(queryAtomRspBO.getRespCode())) {
            throw new FscBusinessException("188684", queryAtomRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Map)queryAtomRspBO.getFscOrderInfoBoMap())) {
            throw new FscBusinessException("188684", "\u67e5\u8be2\u8ba2\u5355\u4e3a\u7a7a");
        }
        Map fscOrderInfoBoMap = queryAtomRspBO.getFscOrderInfoBoMap();
        String proOrgId = ((FscOrderInfoBO)fscOrderInfoBoMap.get(acceptIds.get(0))).getProOrgId();
        FscBillCheckOrderAccountReqBO fscBillCheckOrderAccountReqBO = new FscBillCheckOrderAccountReqBO();
        fscBillCheckOrderAccountReqBO.setPurchaseNo(proOrgId);
        fscBillCheckOrderAccountReqBO.setSupplierId(((FscCheckResultPO)fscCheckResultPoList.get(0)).getSupplierId());
        fscBillCheckOrderAccountReqBO.setOperType(OPER_TYPE);
        fscBillCheckOrderAccountReqBO.setOrderIdList(otherNos);
        FscBillCheckOrderAccountRspBO checkOrderAccountRspBO = null;
        try {
            checkOrderAccountRspBO = this.fscBillCheckOrderAccountService.checkOrderAccount(fscBillCheckOrderAccountReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.getEcomCheckDataFailUpdateCheckStateToNotEquals(acceptIds, fscOrderInfoBoMap, reqBO);
            log.error("\u672a\u67e5\u8be2\u5230\u7535\u5546\u6570\u636e\uff0c\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(acceptIds));
            return new FscBillEcomCheckBusiRspBO();
        }
        if (!"0000".equals(checkOrderAccountRspBO.getRespCode())) {
            this.getEcomCheckDataFailUpdateCheckStateToNotEquals(acceptIds, fscOrderInfoBoMap, reqBO);
            log.error("\u672a\u67e5\u8be2\u5230\u7535\u5546\u6570\u636e\uff0c\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(acceptIds));
            return new FscBillEcomCheckBusiRspBO();
        }
        if (null == checkOrderAccountRspBO.getResult()) {
            this.getEcomCheckDataFailUpdateCheckStateToNotEquals(acceptIds, fscOrderInfoBoMap, reqBO);
            log.error("\u672a\u67e5\u8be2\u5230\u7535\u5546\u6570\u636e\uff0c\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(acceptIds));
            return new FscBillEcomCheckBusiRspBO();
        }
        if (null == checkOrderAccountRspBO.getResult().getOrders()) {
            this.getEcomCheckDataFailUpdateCheckStateToNotEquals(acceptIds, fscOrderInfoBoMap, reqBO);
            log.error("\u672a\u67e5\u8be2\u5230\u7535\u5546\u6570\u636e\uff0c\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(acceptIds));
            return new FscBillEcomCheckBusiRspBO();
        }
        if (!CollectionUtils.isEmpty((Collection)checkOrderAccountRspBO.getResult().getOrders())) {
            if (checkOrderAccountRspBO.getResult().getOrders().size() != otherNos.size()) {
                List backOrderNos = checkOrderAccountRspBO.getResult().getOrders().stream().map(FscCheckOrderEntity::getOrderId).collect(Collectors.toList());
                List notBackOrderNos = otherNos.stream().filter(s -> !backOrderNos.contains(s)).collect(Collectors.toList());
                List<Long> notBackAcceptIds = fscCheckResultPoList.stream().filter(fscCheckResultPO -> notBackOrderNos.contains(fscCheckResultPO.getOtherNo())).map(FscCheckResultPO::getAcceptOrderId).collect(Collectors.toList());
                List<FscCheckResultPO> backFscCheckResultPOS = fscCheckResultPoList.stream().filter(fscCheckResultPO -> backOrderNos.contains(fscCheckResultPO.getOtherNo())).collect(Collectors.toList());
                Map<Long, FscOrderInfoBO> backFscOrderInfoMap = queryAtomRspBO.getFscOrderInfoBoMap().values().stream().filter(fscOrderInfoBO -> backOrderNos.contains(fscOrderInfoBO.getExtOrderNo())).collect(Collectors.toMap(FscOrderInfoBO::getAcceptOrderId, o -> o));
                this.check(backFscCheckResultPOS, checkOrderAccountRspBO.getResult().getOrders(), reqBO, backFscOrderInfoMap);
                this.getEcomCheckDataFailUpdateCheckStateToNotEquals(notBackAcceptIds, fscOrderInfoBoMap, reqBO);
                log.error("\u7535\u5546\u672a\u8fd4\u56de\u7684\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(notBackAcceptIds));
            } else {
                this.check(fscCheckResultPoList, checkOrderAccountRspBO.getResult().getOrders(), reqBO, queryAtomRspBO.getFscOrderInfoBoMap());
            }
        } else {
            this.getEcomCheckDataFailUpdateCheckStateToNotEquals(acceptIds, fscOrderInfoBoMap, reqBO);
            log.error("\u672a\u67e5\u8be2\u5230\u7535\u5546\u6570\u636e\uff0c\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(acceptIds));
        }
        return new FscBillEcomCheckBusiRspBO();
    }

    private void check(List<FscCheckResultPO> fscCheckResultPoList, List<FscCheckOrderEntity> extOrders, FscBillEcomCheckBusiReqBO reqBO, Map<Long, FscOrderInfoBO> fscOrderInfoMap) {
        Map<Long, RelOrderBO> relOrderBoMap = reqBO.getRelOrderList().stream().collect(Collectors.toMap(RelOrderBO::getAcceptOrderId, o -> o));
        Map<Long, String> orderMap = fscCheckResultPoList.stream().collect(Collectors.toMap(FscCheckResultPO::getAcceptOrderId, FscCheckResultPO::getOtherNo));
        HashMap ours = new HashMap(16);
        fscOrderInfoMap.forEach((acceptOrderId, fscOrderInfoBO) -> ours.put(acceptOrderId, fscOrderInfoBO.getInspTotalPurchaseMoney()));
        if (log.isDebugEnabled()) {
            log.debug("\u8ba2\u5355\uff1a{}", (Object)JSON.toJSONString(ours));
        }
        Map<String, FscCheckOrderEntity> exts = extOrders.stream().collect(Collectors.toMap(FscCheckOrderEntity::getOrderId, f -> f));
        if (log.isDebugEnabled()) {
            log.debug("\u5916\u90e8\u8ba2\u5355\uff1a{}", (Object)JSON.toJSONString(exts));
        }
        ArrayList uocOrderSyncCheckStatusReqBoList = new ArrayList();
        orderMap.forEach((k, v) -> {
            BigDecimal ourPrice = (BigDecimal)ours.get(k);
            BigDecimal extPrice = ((FscCheckOrderEntity)exts.get(v)).getOrderPrice();
            FscCheckResultPO fscCheckResult = new FscCheckResultPO();
            FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO = new FscUocOrderSyncCheckStatusReqBO();
            fscCheckResult.setAcceptOrderId(k);
            fscCheckResult.setCheckTime(new Date());
            fscCheckResult.setOperId(reqBO.getUserId());
            fscCheckResult.setOperName(reqBO.getName());
            fscCheckResult.setOtherAmount(((FscCheckOrderEntity)exts.get(v)).getOrderPrice());
            if (ourPrice.compareTo(extPrice) == 0) {
                fscCheckResult.setStatus(FscConstants.BillCheck.EQUALS);
                uocOrderSyncCheckStatusReqBO.setCheckState(FscConstants.BillCheck.EQUALS);
            } else {
                fscCheckResult.setStatus(FscConstants.BillCheck.NOT_EQUALS);
                uocOrderSyncCheckStatusReqBO.setCheckState(FscConstants.BillCheck.NOT_EQUALS);
            }
            this.fscCheckResultMapper.updateByOrderId(fscCheckResult);
            List skuList = ((FscOrderInfoBO)fscOrderInfoMap.get(k)).getFscOrderItemBOS();
            ArrayList<FscCheckResultItemPO> fscCheckResultItemPOS = new ArrayList<FscCheckResultItemPO>();
            for (FscOrderItemBO fscOrderItemBO : skuList) {
                FscCheckResultItemPO fscCheckResultItem = new FscCheckResultItemPO();
                fscCheckResultItem.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscCheckResultItem.setOrderId(fscOrderItemBO.getOrderId());
                fscCheckResultItem.setAcceptOrderId(fscOrderItemBO.getAcceptOrderId());
                fscCheckResultItem.setFscOrderId(fscOrderItemBO.getFscOrderId());
                fscCheckResultItem.setSkuId(fscOrderItemBO.getSkuId());
                fscCheckResultItem.setPrice(fscOrderItemBO.getPurchasePrice());
                fscCheckResultItem.setAmount(fscOrderItemBO.getInspPurchaseMoney());
                fscCheckResultItem.setNum(fscOrderItemBO.getNum());
                fscCheckResultItemPOS.add(fscCheckResultItem);
            }
            if (!CollectionUtils.isEmpty(fscCheckResultItemPOS)) {
                this.fscCheckResultItemMapper.insertBatch(fscCheckResultItemPOS);
            }
            uocOrderSyncCheckStatusReqBO.setInspectionVoucherId(k);
            uocOrderSyncCheckStatusReqBO.setOrderId(((FscOrderItemBO)skuList.get(0)).getOrderId());
            uocOrderSyncCheckStatusReqBoList.add(uocOrderSyncCheckStatusReqBO);
        });
        for (FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO : uocOrderSyncCheckStatusReqBoList) {
            FscUocOrderSyncCheckStatusRspBO uocOrderSyncCheckStatusRspBO = this.fscUocOrderSyncCheckStatusAbilityService.dealSyncCheckStatus(uocOrderSyncCheckStatusReqBO);
            if ("0000".equals(uocOrderSyncCheckStatusRspBO.getRespCode())) continue;
            this.writeFailLog(uocOrderSyncCheckStatusRspBO, uocOrderSyncCheckStatusReqBO, relOrderBoMap);
        }
    }

    private void writeFailLog(FscUocOrderSyncCheckStatusRspBO uocOrderSyncCheckStatusRspBO, FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO, Map<Long, RelOrderBO> relOrderBoMap) {
        FscOrderFailLogUpdateAtomReqBO fscOrderFailLogUpdateAtomReqBO = new FscOrderFailLogUpdateAtomReqBO();
        long id = Sequence.getInstance().nextId();
        fscOrderFailLogUpdateAtomReqBO.setId(Long.valueOf(id));
        fscOrderFailLogUpdateAtomReqBO.setObjId(uocOrderSyncCheckStatusReqBO.getOrderId());
        fscOrderFailLogUpdateAtomReqBO.setObjNo(relOrderBoMap.get(uocOrderSyncCheckStatusReqBO.getOrderId()).getOtherNo());
        fscOrderFailLogUpdateAtomReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.ORDER_CHECK_STATUS_SYNC);
        fscOrderFailLogUpdateAtomReqBO.setBusiFailDesc(uocOrderSyncCheckStatusRspBO.getRespDesc());
        FscOrderFailLogUpdateAtomRspBO fscOrderFailLogUpdateAtomRspBO = this.fscOrderFailLogUpdateAtomService.dealInsert(fscOrderFailLogUpdateAtomReqBO);
        if (!"0000".equals(fscOrderFailLogUpdateAtomRspBO.getRespCode())) {
            throw new FscBusinessException("188684", "\u8bb0\u5f55\u5931\u8d25\u65e5\u5fd7\u51fa\u9519");
        }
    }

    private void getEcomCheckDataFailUpdateCheckStateToNotEquals(List<Long> acceptIds, Map<Long, FscOrderInfoBO> fscOrderInfoBoMap, FscBillEcomCheckBusiReqBO reqBO) {
        Map<Long, RelOrderBO> relOrderBoMap = reqBO.getRelOrderList().stream().collect(Collectors.toMap(RelOrderBO::getAcceptOrderId, o -> o));
        FscCheckResultPO fscCheckResult = new FscCheckResultPO();
        fscCheckResult.setAcceptOrderIds(acceptIds);
        this.fscCheckResultMapper.updateStatusByAcceptOrderIds(acceptIds, FscConstants.BillCheck.NOT_EQUALS);
        acceptIds.forEach(acceptId -> {
            FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO = new FscUocOrderSyncCheckStatusReqBO();
            uocOrderSyncCheckStatusReqBO.setCheckState(FscConstants.BillCheck.NOT_EQUALS);
            uocOrderSyncCheckStatusReqBO.setInspectionVoucherId(acceptId);
            uocOrderSyncCheckStatusReqBO.setOrderId(((FscOrderInfoBO)fscOrderInfoBoMap.get(acceptId)).getOrderId());
            FscUocOrderSyncCheckStatusRspBO uocOrderSyncCheckStatusRspBO = this.fscUocOrderSyncCheckStatusAbilityService.dealSyncCheckStatus(uocOrderSyncCheckStatusReqBO);
            if (!"0000".equals(uocOrderSyncCheckStatusRspBO.getRespCode())) {
                this.writeFailLog(uocOrderSyncCheckStatusRspBO, uocOrderSyncCheckStatusReqBO, relOrderBoMap);
            }
        });
    }
}

