/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.atom.api.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.atom.api.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.busi.api.FscBillOrderCreateBusiService;
import com.tydic.fsc.busi.api.bo.FscBillOrderCreateBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscBillOrderCreateBusiRspBO;
import com.tydic.fsc.common.bo.FscOrderInfoBO;
import com.tydic.fsc.common.bo.RelOrderBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceRuleMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.po.FscInvoiceRulePO;
import com.tydic.fsc.dao.po.FscOrderInvoicePO;
import com.tydic.fsc.dao.po.FscOrderItemPO;
import com.tydic.fsc.dao.po.FscOrderPO;
import com.tydic.fsc.dao.po.FscOrderRelationPO;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderCreateBusiServiceImpl
implements FscBillOrderCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderCreateBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceRuleMapper fscInvoiceRuleMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;

    public FscBillOrderCreateBusiRspBO dealCreate(FscBillOrderCreateBusiReqBO reqBO) {
        ArrayList<FscOrderPO> fscOrderPOS = new ArrayList<FscOrderPO>();
        ArrayList<FscOrderRelationPO> fscOrderRelationPOS = new ArrayList<FscOrderRelationPO>();
        ArrayList fscOrderItemPOS = new ArrayList();
        ArrayList<FscOrderInvoicePO> fscOrderInvoicePOS = new ArrayList<FscOrderInvoicePO>();
        ArrayList<FscInvoiceRulePO> fscInvoiceRulePOS = new ArrayList<FscInvoiceRulePO>();
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        Integer elecFlag = FscConstants.FscInvoiceRuleElecFlag.NO;
        if (FscConstants.FscInvoiceCategory.ELEC.equals(reqBO.getInvoiceCategory())) {
            elecFlag = FscConstants.FscInvoiceRuleElecFlag.YES;
        }
        int num = 0;
        for (Object splitOrderBO : reqBO.getSplitOrderList()) {
            FscOrderPO fscOrderPo = (FscOrderPO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderPO.class);
            fscOrderPo.setFscOrderId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderPo.setCreateTime(new Date());
            fscOrderPo.setCreateOperId(reqBO.getUserId());
            fscOrderPo.setCreateOperName(reqBO.getName());
            fscOrderPo.setCreateOrgId(reqBO.getOrgId());
            fscOrderPo.setCreateOrgName(reqBO.getOrgName());
            fscOrderPo.setCreateCompanyId(reqBO.getCompanyId());
            fscOrderPo.setCreateCompanyName(reqBO.getCompanyName());
            fscOrderPo.setTotalCharge(splitOrderBO.getAmount());
            fscOrderPo.setOrderNo((String)reqBO.getOrderNos().get(num));
            fscOrderPo.setBuildAction(FscConstants.FscOrderBuildAction.HAND);
            if (null != reqBO.getBuildAction()) {
                fscOrderPo.setBuildAction(reqBO.getBuildAction());
            }
            ++num;
            fscOrderPOS.add(fscOrderPo);
            fscOrderIds.add(fscOrderPo.getFscOrderId());
            for (RelOrderBO relOrderBO : splitOrderBO.getRelOrderList()) {
                FscOrderInfoBO fscOrderInfoBO = (FscOrderInfoBO)reqBO.getFscOrderInfoBoMap().get(relOrderBO.getAcceptOrderId());
                if (null == fscOrderInfoBO) {
                    throw new FscBusinessException("184000", "\u83b7\u53d6\u8ba2\u5355\u5bf9\u8c61\u4e3a\u7a7a");
                }
                FscOrderRelationPO fscOrderRelationPO = (FscOrderRelationPO)JSONObject.parseObject((String)JSON.toJSONString((Object)fscOrderInfoBO), FscOrderRelationPO.class);
                fscOrderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderRelationPO.setFscOrderId(fscOrderPo.getFscOrderId());
                fscOrderRelationPOS.add(fscOrderRelationPO);
                fscOrderItemPOS.addAll(JSONObject.parseArray((String)JSON.toJSONString((Object)fscOrderInfoBO.getFscOrderItemBOS()), FscOrderItemPO.class));
                fscOrderItemPOS.forEach(fscOrderItemPO -> fscOrderItemPO.setFscOrderId(fscOrderPo.getFscOrderId()));
            }
            FscOrderInvoicePO fscOrderInvoicePo = (FscOrderInvoicePO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderInvoicePO.class);
            fscOrderInvoicePo.setFscOrderId(fscOrderPo.getFscOrderId());
            fscOrderInvoicePo.setBillOperId(reqBO.getUserId().toString());
            fscOrderInvoicePo.setBillOperName(reqBO.getName());
            fscOrderInvoicePo.setBillTime(new Date());
            fscOrderInvoicePo.setBillTimeStart(new Date());
            fscOrderInvoicePOS.add(fscOrderInvoicePo);
            FscInvoiceRulePO fscInvoiceRulePO = new FscInvoiceRulePO();
            fscInvoiceRulePO.setFscOrderId(fscOrderPo.getFscOrderId());
            fscInvoiceRulePO.setDataFlag(FscConstants.FscInvoiceRuleDataFlag.YES);
            fscInvoiceRulePO.setDataStatus(FscConstants.FscInvoiceRuleStatus.NO);
            fscInvoiceRulePO.setElecFlag(elecFlag);
            fscInvoiceRulePO.setElecStatus(FscConstants.FscInvoiceRuleStatus.NO);
            fscInvoiceRulePOS.add(fscInvoiceRulePO);
        }
        if (CollectionUtils.isEmpty(fscOrderPOS) || CollectionUtils.isEmpty(fscOrderRelationPOS) || CollectionUtils.isEmpty(fscOrderItemPOS) || CollectionUtils.isEmpty(fscOrderInvoicePOS) || CollectionUtils.isEmpty(fscInvoiceRulePOS)) {
            throw new FscBusinessException("184000", "\u5f00\u7968\u4e3b\u5355\u7ec4\u88c5\u53c2\u6570\u4e3a\u7a7a");
        }
        fscOrderItemPOS.forEach(fscOrderItemPO -> fscOrderItemPO.setId(Long.valueOf(Sequence.getInstance().nextId())));
        this.fscOrderMapper.insertBatch(fscOrderPOS);
        this.fscOrderRelationMapper.insertBatch(fscOrderRelationPOS);
        this.fscOrderItemMapper.insertBatch(fscOrderItemPOS);
        this.fscOrderInvoiceMapper.insertBatch(fscOrderInvoicePOS);
        this.fscInvoiceRuleMapper.insertBatch(fscInvoiceRulePOS);
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = (FscOrderStatusStartAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderStatusStartAtomReqBO.class);
        for (Long fscOrderId : fscOrderIds) {
            fscOrderStatusStartAtomReqBO.setOrderId(fscOrderId);
            FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealStatusStart(fscOrderStatusStartAtomReqBO);
            if ("0000".equals(fscOrderStatusStartAtomRspBO.getRespCode())) continue;
            throw new FscBusinessException("188888", fscOrderStatusStartAtomRspBO.getRespDesc());
        }
        this.syncOrderStatus(fscOrderIds);
        FscBillOrderCreateBusiRspBO rspBO = new FscBillOrderCreateBusiRspBO();
        rspBO.setFscOrderIds(fscOrderIds);
        return rspBO;
    }

    private void syncOrderStatus(List<Long> fscOrderIds) {
        fscOrderIds.forEach(fscOrderId -> {
            FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
            fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
            fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
            this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
        });
    }
}

