/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.base.FscRspBaseBO;
import com.tydic.fsc.bill.ability.api.FscBillInvoiceImplAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillOrderCreateAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceSignAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillOrderSyncRetransAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceImplAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceSignAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSyncRetransAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSyncRetransAbilityRspBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderFailLogMapper;
import com.tydic.fsc.po.FscOrderFailLogPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscBillOrderSyncRetransAbilityService.class)
public class FscBillOrderSyncRetransAbilityServiceImpl
implements FscBillOrderSyncRetransAbilityService {
    @Autowired
    private FscOrderFailLogMapper fscOrderFailLogMapper;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscBillOrderInvoiceSignAbilityService fscBillOrderInvoiceSignAbilityService;
    @Autowired
    private FscBillInvoiceImplAbilityService fscBillInvoiceImplAbilityService;
    @Autowired
    private FscBillOrderCreateAbilityService fscBillOrderCreateAbilityService;
    private static final String AUTO_SIGN = "1";

    public FscBillOrderSyncRetransAbilityRspBO dealRetrans(FscBillOrderSyncRetransAbilityReqBO reqBO) {
        FscOrderFailLogPO fscOrderFailLogPO = (FscOrderFailLogPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderFailLogPO.class);
        fscOrderFailLogPO.setDealStatus(FscConstants.FscOrderFailRetransDealStatus.WAIT_DEAL);
        ArrayList<Integer> busiTypes = new ArrayList<Integer>();
        busiTypes.add(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_INVOICE_SIGN_FAIL);
        busiTypes.add(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_INVOICE_BILL_FAIL);
        busiTypes.add(FscConstants.FscOrderFailRetansBusiType.FSC_DOWN_TAKE_UP_FAIL);
        fscOrderFailLogPO.setBusiTypes(busiTypes);
        List fscOrderFailLogPOS = this.fscOrderFailLogMapper.getList(fscOrderFailLogPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderFailLogPOS)) {
            for (FscOrderFailLogPO fscOrderFailLog : fscOrderFailLogPOS) {
                this.updateStatus(FscConstants.FscOrderFailRetransDealStatus.DEALLING, fscOrderFailLog.getId(), null);
                FscRspBaseBO fscRspBaseBO = null;
                if (FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_INVOICE_SIGN_FAIL.equals(fscOrderFailLog.getBusiType())) {
                    fscRspBaseBO = this.dealInvoiceSignSync(fscOrderFailLog);
                }
                if (FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_INVOICE_BILL_FAIL.equals(fscOrderFailLog.getBusiType())) {
                    fscRspBaseBO = this.dealInvoiceSubmitSync(fscOrderFailLog);
                }
                if (FscConstants.FscOrderFailRetansBusiType.FSC_DOWN_TAKE_UP_FAIL.equals(fscOrderFailLog.getBusiType())) {
                    fscRspBaseBO = this.dealDownTakeUpCreate(fscOrderFailLog);
                }
                if (null != fscRspBaseBO) {
                    this.updateStatus(this.getDealStatus(fscRspBaseBO), fscOrderFailLog.getId(), fscRspBaseBO.getRespDesc());
                    continue;
                }
                this.updateStatus(FscConstants.FscOrderFailRetransDealStatus.WAIT_DEAL, fscOrderFailLog.getId(), null);
            }
        }
        return new FscBillOrderSyncRetransAbilityRspBO();
    }

    private FscRspBaseBO dealInvoiceSignSync(FscOrderFailLogPO fscOrderFailLog) {
        if (null == fscOrderFailLog.getObjId()) {
            return new FscRspBaseBO();
        }
        FscBillOrderInvoiceSignAbilityReqBO signAbilityReqBO = new FscBillOrderInvoiceSignAbilityReqBO();
        signAbilityReqBO.setOrderId(fscOrderFailLog.getObjId());
        signAbilityReqBO.setAutoSignFlag(AUTO_SIGN);
        return this.fscBillOrderInvoiceSignAbilityService.dealOrderInvoiceSign(signAbilityReqBO);
    }

    private FscRspBaseBO dealInvoiceSubmitSync(FscOrderFailLogPO fscOrderFailLog) {
        if (null == fscOrderFailLog.getObjId()) {
            return new FscRspBaseBO();
        }
        FscBillInvoiceImplAbilityReqBO fscBillInvoiceImplAbilityReqBO = new FscBillInvoiceImplAbilityReqBO();
        fscBillInvoiceImplAbilityReqBO.setOrderId(fscOrderFailLog.getObjId());
        return this.fscBillInvoiceImplAbilityService.dealInvoiceImpl(fscBillInvoiceImplAbilityReqBO);
    }

    private FscRspBaseBO dealDownTakeUpCreate(FscOrderFailLogPO fscOrderFailLog) {
        if (StringUtils.isBlank((CharSequence)fscOrderFailLog.getBusiFailDesc())) {
            return new FscRspBaseBO();
        }
        FscBillOrderCreateAbilityReqBO fscBillOrderCreateAbilityReqBO = (FscBillOrderCreateAbilityReqBO)JSON.parseObject((String)fscOrderFailLog.getBusiFailDesc(), FscBillOrderCreateAbilityReqBO.class);
        return this.fscBillOrderCreateAbilityService.dealCreate(fscBillOrderCreateAbilityReqBO);
    }

    private void updateStatus(Integer status, Long id, String desc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setId(id);
        fscOrderFailLogUpdateBusiReqBO.setDealStatus(status);
        fscOrderFailLogUpdateBusiReqBO.setDealResultDesc(desc);
        this.fscOrderFailLogUpdateBusiService.dealUpdate(fscOrderFailLogUpdateBusiReqBO);
    }

    private Integer getDealStatus(FscRspBaseBO fscRspBaseBO) {
        if ("0000".equals(fscRspBaseBO.getRespCode())) {
            return FscConstants.FscOrderFailRetransDealStatus.SUCCESS;
        }
        return FscConstants.FscOrderFailRetransDealStatus.FAIL;
    }
}

