/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.FscBillTaxListQueryAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillTaxListDetailEntityQueryBO;
import com.tydic.fsc.bill.ability.bo.FscBillTaxListQueryAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillTaxListQueryAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillTaxListResultQueryBO;
import com.tydic.fsc.bo.FscComOrderListBO;
import com.tydic.fsc.bo.FscOrderItemDetailBO;
import com.tydic.fsc.common.ability.api.FscComOrderListPageQueryAbilityService;
import com.tydic.fsc.common.ability.api.FscOrderItemDetailQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderInvoicePO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscBillTaxListQueryAbilityService.class)
public class FscBillTaxListQueryAbilityServiceImpl
implements FscBillTaxListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillTaxListQueryAbilityServiceImpl.class);
    @Autowired
    private FscOrderItemDetailQueryAbilityService fscOrderItemDetailQueryAbilityService;
    @Autowired
    private FscComOrderListPageQueryAbilityService fscComOrderListPageQueryAbilityService;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Value(value="${FSC_TAX_COMPANY_NO:198611102630}")
    private String FSC_TAX_COMPANY_NO;

    public FscBillTaxListQueryAbilityRspBO qryBillTaxList(FscBillTaxListQueryAbilityReqBO reqBO) {
        FscComOrderListQueryAbilityReqBO fscComOrderListQueryAbilityReqBO = new FscComOrderListQueryAbilityReqBO();
        fscComOrderListQueryAbilityReqBO.setMakeType(FscConstants.FscOrderMakeType.OPERTION);
        fscComOrderListQueryAbilityReqBO.setReceiveType(FscConstants.FscOrderReceiveType.PURCHASE);
        ArrayList<Integer> integers = new ArrayList<Integer>();
        integers.add(FscConstants.OrderFlow.INVOICE);
        fscComOrderListQueryAbilityReqBO.setOrderFlows(integers);
        ArrayList<Integer> integers1 = new ArrayList<Integer>();
        integers1.add(FscConstants.FscInvoiceOrderState.SUBMITTING);
        fscComOrderListQueryAbilityReqBO.setOrderStates(integers1);
        FscComOrderListQueryAbilityRspBO comOrderListPageQuery = this.fscComOrderListPageQueryAbilityService.getComOrderListPageQuery(fscComOrderListQueryAbilityReqBO);
        if (!"0000".equals(comOrderListPageQuery.getRespCode())) {
            throw new FscBusinessException("188686", comOrderListPageQuery.getRespDesc());
        }
        if (null != comOrderListPageQuery && comOrderListPageQuery.getRows() != null && comOrderListPageQuery.getRows().size() > 0) {
            List fscOrderIds = comOrderListPageQuery.getRows().stream().map(fscComOrderListBO -> fscComOrderListBO.getFscOrderId()).collect(Collectors.toList());
            log.info("==============================fscOrderIds" + fscOrderIds);
            FscBillTaxListQueryAbilityRspBO fscBillTaxListQueryAbilityRspBO = (FscBillTaxListQueryAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)comOrderListPageQuery), FscBillTaxListQueryAbilityRspBO.class);
            FscOrderInvoicePO fscOrderInvoicePO2 = new FscOrderInvoicePO();
            fscOrderInvoicePO2.setFscOrderIdList(fscOrderIds);
            List fscOrderInvoicePOList = this.fscOrderInvoiceMapper.getList(fscOrderInvoicePO2);
            Map<Long, FscOrderInvoicePO> collect = fscOrderInvoicePOList.stream().collect(Collectors.toMap(FscOrderInvoicePO::getFscOrderId, fscOrderInvoicePO -> fscOrderInvoicePO));
            FscOrderItemDetailQueryAbilityReqBO fscOrderItemDetailQueryAbilityReqBO = new FscOrderItemDetailQueryAbilityReqBO();
            fscOrderItemDetailQueryAbilityReqBO.setFscOrderIdList(fscOrderIds);
            FscOrderItemDetailQueryAbilityRspBO fscOrderItemDetailQueryAbilityRspBO = this.fscOrderItemDetailQueryAbilityService.queryOrderItemDetail(fscOrderItemDetailQueryAbilityReqBO);
            if (!fscOrderItemDetailQueryAbilityRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException("188686", fscOrderItemDetailQueryAbilityRspBO.getRespDesc());
            }
            log.info("==============================fscOrderItemDetailQueryAbilityRspBO" + fscOrderItemDetailQueryAbilityRspBO);
            ArrayList<FscBillTaxListResultQueryBO> fscBillTaxListResultQueryBOS = new ArrayList<FscBillTaxListResultQueryBO>();
            for (FscComOrderListBO fscComOrderListBO2 : comOrderListPageQuery.getRows()) {
                FscBillTaxListResultQueryBO fscBillTaxListResultQueryBO = new FscBillTaxListResultQueryBO();
                FscOrderInvoicePO fscOrderInvoicePO3 = collect.get(fscComOrderListBO2.getFscOrderId());
                fscBillTaxListResultQueryBO.setBusiType(reqBO.getBusiType());
                fscBillTaxListResultQueryBO.setOrderNo(String.valueOf(fscComOrderListBO2.getFscOrderId()));
                fscBillTaxListResultQueryBO.setYCompanyNo("198611102630");
                fscBillTaxListResultQueryBO.setCOrgnCode(fscComOrderListBO2.getSupplierId().toString());
                fscBillTaxListResultQueryBO.setCustName(fscOrderInvoicePO3.getBuyName());
                fscBillTaxListResultQueryBO.setCustTaxNo(fscOrderInvoicePO3.getTaxNo());
                fscBillTaxListResultQueryBO.setCustAddrPhone(fscOrderInvoicePO3.getAddress() + " " + fscOrderInvoicePO3.getPhone());
                fscBillTaxListResultQueryBO.setCustBankAccount(fscOrderInvoicePO3.getBank() + " " + fscOrderInvoicePO3.getAccount());
                Integer invoiceCategory = fscOrderInvoicePO3.getInvoiceCategory();
                if (invoiceCategory.equals(FscConstants.FscElecInvoiceType.GENERAL)) {
                    fscBillTaxListResultQueryBO.setInvType(FscConstants.FscTaxInvType.GENERAL);
                } else if (invoiceCategory.equals(FscConstants.FscElecInvoiceType.ELEC)) {
                    fscBillTaxListResultQueryBO.setInvType(FscConstants.FscTaxInvType.ELEC);
                } else {
                    fscBillTaxListResultQueryBO.setInvType(FscConstants.FscTaxInvType.SPECIAL);
                }
                fscBillTaxListResultQueryBO.setInvRemark(null);
                fscBillTaxListResultQueryBO.setDrawer(fscOrderInvoicePO3.getBillOperId());
                fscBillTaxListResultQueryBO.setPayer(fscOrderInvoicePO3.getReceiveName());
                fscBillTaxListResultQueryBO.setReviewer("");
                fscBillTaxListResultQueryBO.setExpressTelphone(fscOrderInvoicePO3.getReceivePhone());
                fscBillTaxListResultQueryBO.setSellerAddrPhone("");
                fscBillTaxListResultQueryBO.setSellerBankAccount("");
                SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
                String format = f.format(fscComOrderListBO2.getCreateTime());
                fscBillTaxListResultQueryBO.setOrderDate(format);
                fscBillTaxListResultQueryBO.setOrderType(fscComOrderListBO2.getOrderFlowStr());
                fscBillTaxListResultQueryBO.setExpressAddress(fscOrderInvoicePO3.getAddress());
                fscBillTaxListResultQueryBO.setExpressCity(fscOrderInvoicePO3.getCity());
                fscBillTaxListResultQueryBO.setExpressContact(fscOrderInvoicePO3.getSignOperName());
                fscBillTaxListResultQueryBO.setExpressTelphone(fscOrderInvoicePO3.getReceivePhone());
                fscBillTaxListResultQueryBO.setCustEmail(fscOrderInvoicePO3.getReceiveEmail());
                fscBillTaxListResultQueryBO.setCustTelephone("");
                ArrayList<FscBillTaxListDetailEntityQueryBO> fscBillTaxListDetailEntityQueryBOS = new ArrayList<FscBillTaxListDetailEntityQueryBO>();
                for (FscOrderItemDetailBO fscOrderItemDetailBO : fscOrderItemDetailQueryAbilityRspBO.getFscOrderItemDetailBOS()) {
                    if (!fscOrderItemDetailBO.getFscOrderId().equals(fscComOrderListBO2.getFscOrderId())) continue;
                    FscBillTaxListDetailEntityQueryBO fscBillTaxListDetailEntityQueryBO = new FscBillTaxListDetailEntityQueryBO();
                    BeanUtils.copyProperties((Object)fscOrderItemDetailBO, (Object)fscBillTaxListDetailEntityQueryBO);
                    fscBillTaxListDetailEntityQueryBO.setGoodsNo(String.valueOf(fscOrderItemDetailBO.getOrderItemId()));
                    fscBillTaxListDetailEntityQueryBO.setOldOrderNo(fscOrderItemDetailBO.getOrderNo());
                    fscBillTaxListDetailEntityQueryBO.setInspectionId(fscOrderItemDetailBO.getAcceptOrderId());
                    fscBillTaxListDetailEntityQueryBO.setGoodsName(fscOrderItemDetailBO.getSkuName());
                    if (null != fscOrderItemDetailBO.getSkuId()) {
                        String s = String.valueOf(fscOrderItemDetailBO.getSkuId());
                        fscBillTaxListDetailEntityQueryBO.setLineCode(Integer.valueOf(s));
                    }
                    fscBillTaxListDetailEntityQueryBO.setQty(fscOrderItemDetailBO.getNum());
                    fscBillTaxListDetailEntityQueryBO.setTaxPrice(fscOrderItemDetailBO.getAmt().divide(fscOrderItemDetailBO.getNum(), 3));
                    fscBillTaxListDetailEntityQueryBO.setAmount(fscOrderItemDetailBO.getTaxAmt());
                    fscBillTaxListDetailEntityQueryBO.setDisAmount(null);
                    fscBillTaxListDetailEntityQueryBO.setDistaxAmount(null);
                    fscBillTaxListDetailEntityQueryBO.setGropGoodsNo("");
                    fscBillTaxListResultQueryBO.setInvRemark(fscOrderItemDetailBO.getOrderDesc());
                    fscBillTaxListDetailEntityQueryBO.setTax(fscOrderItemDetailBO.getTaxAmt());
                    fscBillTaxListDetailEntityQueryBO.setTaxAmount(fscOrderItemDetailBO.getAmt());
                    fscBillTaxListDetailEntityQueryBO.setTaxPre(Integer.valueOf(0));
                    fscBillTaxListDetailEntityQueryBO.setTaxCode(fscOrderItemDetailBO.getTaxCode());
                    fscBillTaxListDetailEntityQueryBO.setTaxRate(fscOrderItemDetailBO.getTaxRate().setScale(2, 4));
                    fscBillTaxListDetailEntityQueryBO.setItemSpare1(String.valueOf(fscOrderItemDetailBO.getOrderItemId()));
                    fscBillTaxListDetailEntityQueryBOS.add(fscBillTaxListDetailEntityQueryBO);
                }
                fscBillTaxListResultQueryBO.setDetail(fscBillTaxListDetailEntityQueryBOS);
                fscBillTaxListResultQueryBOS.add(fscBillTaxListResultQueryBO);
            }
            fscBillTaxListQueryAbilityRspBO.setRows(fscBillTaxListResultQueryBOS);
            return fscBillTaxListQueryAbilityRspBO;
        }
        return new FscBillTaxListQueryAbilityRspBO();
    }
}

