/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.FscBillTaxReturnAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillTaxReturnAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillTaxReturnAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillTaxReturnBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillTaxReturnBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillTaxReturnBusiRspBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscBillTaxReturnAbilityService.class)
public class FscBillTaxReturnAbilityServiceImpl
implements FscBillTaxReturnAbilityService {
    @Autowired
    private FscBillTaxReturnBusiService fscBillTaxReturnBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    public FscBillTaxReturnAbilityRspBO dealBillTaxReturn(FscBillTaxReturnAbilityReqBO reqBO) {
        this.var(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        Long aLong = new Long(reqBO.getOrderNo());
        fscOrderPO.setFscOrderId(aLong);
        FscOrderPO modelBy = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (FscConstants.FscInvoiceOrderState.SUBMITTING.equals(modelBy.getOrderState())) {
            FscBillTaxReturnBusiReqBO fscBillTaxReturnBusiReqBO = (FscBillTaxReturnBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillTaxReturnBusiReqBO.class));
            fscBillTaxReturnBusiReqBO.setOrderState(modelBy.getOrderState());
            fscBillTaxReturnBusiReqBO.setFscOrderId(modelBy.getFscOrderId());
            FscBillTaxReturnBusiRspBO fscBillTaxReturnBusiRspBO = this.fscBillTaxReturnBusiService.dealBillTaxReturn(fscBillTaxReturnBusiReqBO);
            if (!"0000".equals(fscBillTaxReturnBusiRspBO.getRespCode())) {
                this.writeFailLog(aLong, fscBillTaxReturnBusiRspBO.getRespDesc());
                throw new FscBusinessException("188686", fscBillTaxReturnBusiRspBO.getRespDesc());
            }
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(modelBy.getFscOrderId());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
            return new FscBillTaxReturnAbilityRspBO();
        }
        this.writeFailLog(aLong, "\u72b6\u6001\u975e\u5f85\u5f00\u7968");
        throw new FscBusinessException("188686", "\u72b6\u6001\u975e\u5f85\u5f00\u7968");
    }

    private void writeFailLog(Long fscOrderId, String errorMsg) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(fscOrderId);
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(errorMsg);
        fscOrderFailLogUpdateBusiReqBO.setBusiFailTime(new Date());
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_BILL_TAX_RETURN_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }

    private void var(FscBillTaxReturnAbilityReqBO reqBO) {
        if (StringUtils.isBlank((CharSequence)reqBO.getBusiType())) {
            throw new FscBusinessException("184000", "\u5165\u53c2[busiType]\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderNo())) {
            throw new FscBusinessException("184000", "\u5165\u53c2[orderNo]\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getYCompanyNo())) {
            throw new FscBusinessException("184000", "\u5165\u53c2[y_company_no]\u4e3a\u7a7a");
        }
    }
}

