/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.FscBillEcomCheckAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillEcomCheckBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckBusiRspBO;
import com.tydic.fsc.bo.FscEcomJdOrderDetailBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillCheckOrderAccountReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillCheckOrderAccountRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscBillCheckOrderAccountService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCheckResultPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscBillEcomCheckAbilityService.class)
public class FscBillEcomCheckAbilityServiceImpl
implements FscBillEcomCheckAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillEcomCheckAbilityServiceImpl.class);
    @Autowired
    private FscBillEcomCheckBusiService fscBillEcomCheckBusiService;
    @Autowired
    private FscBillCheckOrderAccountService fscBillCheckOrderAccountService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Value(value="${JD_SUP_ID:100055}")
    private Long JD_SUP_ID;
    public static final String OPER_TYPE = "2";
    private static final Integer ERROR = 1;

    @BigDecimalConvert(value=2)
    @FscDuplicateCommitLimit
    public FscBillEcomCheckAbilityRspBO dealEcomCheck(FscBillEcomCheckAbilityReqBO reqBO) {
        this.val(reqBO);
        FscBillEcomCheckBusiReqBO busiReqBO = (FscBillEcomCheckBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillEcomCheckBusiReqBO.class));
        List relOrderList = reqBO.getRelOrderList();
        List<Long> acceptIds = relOrderList.stream().map(RelOrderBO::getAcceptOrderId).collect(Collectors.toList());
        FscCheckResultPO fscCheckResult = new FscCheckResultPO();
        fscCheckResult.setAcceptOrderIds(acceptIds);
        List fscCheckResultPoList = this.fscCheckResultMapper.getList(fscCheckResult);
        if (CollectionUtils.isEmpty((Collection)fscCheckResultPoList)) {
            return new FscBillEcomCheckAbilityRspBO();
        }
        List<String> otherNos = fscCheckResultPoList.stream().map(FscCheckResultPO::getOtherNo).collect(Collectors.toList());
        FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
        fscAcceptOrderListQueryAtomReqBO.setInspectionVoucherIdList(acceptIds);
        fscAcceptOrderListQueryAtomReqBO.setPageSize(Integer.valueOf(acceptIds.size()));
        FscAcceptOrderListQueryAtomRspBO queryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
        if (!"0000".equals(queryAtomRspBO.getRespCode())) {
            throw new FscBusinessException("191033", queryAtomRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Map)queryAtomRspBO.getFscOrderInfoBoMap())) {
            throw new FscBusinessException("191033", "\u67e5\u8be2\u8ba2\u5355\u4e3a\u7a7a");
        }
        Map fscOrderInfoBoMap = queryAtomRspBO.getFscOrderInfoBoMap();
        if (this.JD_SUP_ID.equals(Long.valueOf(((FscOrderInfoBO)fscOrderInfoBoMap.get(acceptIds.get(0))).getSupplierId()))) {
            List<FscEcomJdOrderDetailBO> jdOrderDetailBOS = this.getJdOrderDetailBOS(busiReqBO, acceptIds, fscCheckResultPoList, otherNos, fscOrderInfoBoMap);
            busiReqBO.setJdOrderDetailBOS(jdOrderDetailBOS);
            busiReqBO.setEcomType("JD");
        } else {
            FscBillCheckOrderAccountRspBO checkOrderAccountRspBO = this.getOtherEcomBillCheckData(busiReqBO, acceptIds, fscCheckResultPoList, otherNos, fscOrderInfoBoMap);
            busiReqBO.setCheckOrderAccountRspBO(checkOrderAccountRspBO);
            busiReqBO.setEcomType("OTHER_ECOM");
        }
        busiReqBO.setAcceptIds(acceptIds);
        busiReqBO.setOtherNos(otherNos);
        busiReqBO.setQueryAtomRspBO(queryAtomRspBO);
        busiReqBO.setFscCheckResultPoList(fscCheckResultPoList);
        FscBillEcomCheckBusiRspBO busiRspBO = this.fscBillEcomCheckBusiService.dealEcomCheck(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("191033", busiRspBO.getRespDesc());
        }
        return new FscBillEcomCheckAbilityRspBO();
    }

    private List<FscEcomJdOrderDetailBO> getJdOrderDetailBOS(FscBillEcomCheckBusiReqBO busiReqBO, List<Long> acceptIds, List<FscCheckResultPO> fscCheckResultPoList, List<String> otherNos, Map<Long, FscOrderInfoBO> fscOrderInfoBoMap) {
        ArrayList<FscEcomJdOrderDetailBO> jdOrderDetailBOS = new ArrayList<FscEcomJdOrderDetailBO>();
        for (String otherNo : otherNos) {
            FscBillCheckOrderAccountReqBO fscBillCheckOrderAccountReqBO = new FscBillCheckOrderAccountReqBO();
            fscBillCheckOrderAccountReqBO.setOrderId(otherNo);
            fscBillCheckOrderAccountReqBO.setSupplierId(fscCheckResultPoList.get(0).getSupplierId());
            if (FscConstants.FscBusiModel.TRADE.equals(fscOrderInfoBoMap.get(acceptIds.get(0)).getBusiMode())) {
                fscBillCheckOrderAccountReqBO.setOrgId(this.str2Long(fscOrderInfoBoMap.get(acceptIds.get(0)).getProOrgId()));
            } else {
                fscBillCheckOrderAccountReqBO.setOrgId(this.str2Long(fscOrderInfoBoMap.get(acceptIds.get(0)).getPurchaserId()));
            }
            FscBillCheckOrderAccountRspBO checkOrderAccountRspBO = null;
            try {
                checkOrderAccountRspBO = this.fscBillCheckOrderAccountService.checkOrderAccount(fscBillCheckOrderAccountReqBO);
            }
            catch (Exception e) {
                e.printStackTrace();
                busiReqBO.setErrorFlag(ERROR);
                log.error("\u672a\u67e5\u8be2\u5230\u4eac\u4e1c\u7535\u5546\u6570\u636e\uff0c\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(acceptIds));
                continue;
            }
            if (null == checkOrderAccountRspBO || !"0000".equals(checkOrderAccountRspBO.getRespCode())) {
                busiReqBO.setErrorFlag(ERROR);
                log.error("\u672a\u67e5\u8be2\u5230\u4eac\u4e1c\u7535\u5546\u6570\u636e\uff0c\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(acceptIds));
                continue;
            }
            if (null == checkOrderAccountRspBO.getResult()) {
                busiReqBO.setErrorFlag(ERROR);
                log.error("\u672a\u67e5\u8be2\u5230\u4eac\u4e1c\u7535\u5546\u6570\u636e\uff0c\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(acceptIds));
                continue;
            }
            if (null == checkOrderAccountRspBO.getResult().getOrderDetail()) {
                busiReqBO.setErrorFlag(ERROR);
                log.error("\u672a\u67e5\u8be2\u5230\u4eac\u4e1c\u7535\u5546\u6570\u636e\uff0c\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(acceptIds));
                continue;
            }
            jdOrderDetailBOS.add(checkOrderAccountRspBO.getResult().getOrderDetail());
        }
        if (otherNos.size() != jdOrderDetailBOS.size()) {
            busiReqBO.setErrorFlag(ERROR);
        }
        return jdOrderDetailBOS;
    }

    private FscBillCheckOrderAccountRspBO getOtherEcomBillCheckData(FscBillEcomCheckBusiReqBO busiReqBO, List<Long> acceptIds, List<FscCheckResultPO> fscCheckResultPoList, List<String> otherNos, Map<Long, FscOrderInfoBO> fscOrderInfoBoMap) {
        FscBillCheckOrderAccountReqBO fscBillCheckOrderAccountReqBO = new FscBillCheckOrderAccountReqBO();
        String proOrgId = fscOrderInfoBoMap.get(acceptIds.get(0)).getProOrgId();
        fscBillCheckOrderAccountReqBO.setPurchaseNo(proOrgId);
        fscBillCheckOrderAccountReqBO.setSupplierId(fscCheckResultPoList.get(0).getSupplierId());
        fscBillCheckOrderAccountReqBO.setOperType(OPER_TYPE);
        fscBillCheckOrderAccountReqBO.setOrderIdList(otherNos);
        FscBillCheckOrderAccountRspBO checkOrderAccountRspBO = null;
        try {
            checkOrderAccountRspBO = this.fscBillCheckOrderAccountService.checkOrderAccount(fscBillCheckOrderAccountReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            busiReqBO.setErrorFlag(ERROR);
            log.error("\u672a\u67e5\u8be2\u5230\u7535\u5546\u6570\u636e\uff0c\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(acceptIds));
        }
        if (null == checkOrderAccountRspBO || !"0000".equals(checkOrderAccountRspBO.getRespCode())) {
            busiReqBO.setErrorFlag(ERROR);
            log.error("\u672a\u67e5\u8be2\u5230\u7535\u5546\u6570\u636e\uff0c\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(acceptIds));
            return checkOrderAccountRspBO;
        }
        if (null == checkOrderAccountRspBO.getResult()) {
            busiReqBO.setErrorFlag(ERROR);
            log.error("\u672a\u67e5\u8be2\u5230\u7535\u5546\u6570\u636e\uff0c\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(acceptIds));
            return checkOrderAccountRspBO;
        }
        if (null == checkOrderAccountRspBO.getResult().getOrders()) {
            busiReqBO.setErrorFlag(ERROR);
            log.error("\u672a\u67e5\u8be2\u5230\u7535\u5546\u6570\u636e\uff0c\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(acceptIds));
            return checkOrderAccountRspBO;
        }
        return checkOrderAccountRspBO;
    }

    private void val(FscBillEcomCheckAbilityReqBO reqBO) {
        if (reqBO.getRelOrderList().size() == 0) {
            throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e3a\u7a7a");
        }
    }

    private Long str2Long(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            throw new FscBusinessException("191033", "\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
        }
    }
}

