/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.fsc.bill.ability.api.FscBillTaxDeaInvoiceAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillTaxDealInvoiceAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillTaxDealInvoiceAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillTaxListDetailEntityQueryBO;
import com.tydic.fsc.bill.busi.api.FscBillInvoiceUploadBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscInvoiceInfoBO;
import com.tydic.fsc.bo.InvoiceItemBO;
import com.tydic.fsc.common.ability.api.FscBillMailSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscBillMailListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscBillTaxDeaInvoiceAbilityService.class)
public class FscBillTaxDeaInvoiceAbilityServiceImpl
implements FscBillTaxDeaInvoiceAbilityService {
    @Autowired
    private FscBillInvoiceUploadBusiService fscBillInvoiceUploadBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscBillMailSyncAbilityService fscBillMailSyncAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Value(value="${TYPE_SWITCH:true}")
    private Boolean TYPE_SWITCH;

    public FscBillTaxDealInvoiceAbilityRspBO dealBillTaxReturnInvoice(FscBillTaxDealInvoiceAbilityReqBO reqBO) {
        this.val(reqBO);
        FscBillInvoiceUploadBusiReqBO fscBillInvoiceUploadBusiReqBO = new FscBillInvoiceUploadBusiReqBO();
        Long fscOrderId = new Long(reqBO.getOrderNo());
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(fscOrderId);
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        fscBillInvoiceUploadBusiReqBO.setFscOrderId(fscOrderId);
        fscBillInvoiceUploadBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        FscInvoiceInfoBO fscInvoiceInfoBO = new FscInvoiceInfoBO();
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderId(fscOrderId);
        fscOrderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePO);
        fscInvoiceInfoBO.setBuyName(fscOrderInvoicePO.getBuyName());
        fscInvoiceInfoBO.setTaxNo(fscOrderInvoicePO.getTaxNo());
        fscInvoiceInfoBO.setBank(fscOrderInvoicePO.getBank());
        fscInvoiceInfoBO.setAccount(fscOrderInvoicePO.getAccount());
        fscInvoiceInfoBO.setPhone(fscOrderInvoicePO.getPhone());
        fscInvoiceInfoBO.setAddress(fscOrderInvoicePO.getAddress());
        fscInvoiceInfoBO.setFscOrderId(fscOrderId);
        fscInvoiceInfoBO.setInvoiceNo(reqBO.getInvNo());
        fscInvoiceInfoBO.setInvoiceCode(reqBO.getInvCode());
        fscInvoiceInfoBO.setBillDate(reqBO.getInvDate().substring(0, 10));
        BigDecimal totalsAmount = new BigDecimal(reqBO.getTotalAmount());
        fscInvoiceInfoBO.setUntaxAmt(totalsAmount);
        BigDecimal taxAmt = new BigDecimal(reqBO.getTotalTax());
        fscInvoiceInfoBO.setTaxAmt(taxAmt);
        fscInvoiceInfoBO.setAmt(totalsAmount.add(taxAmt));
        if (FscConstants.FscTaxInvType.GENERAL.equals(reqBO.getInvType())) {
            fscInvoiceInfoBO.setInvoiceCategory(FscConstants.InvoiceCategory.PAPER);
            fscInvoiceInfoBO.setInvoiceType("01");
        } else if (FscConstants.FscTaxInvType.SPECIAL.equals(reqBO.getInvType())) {
            fscInvoiceInfoBO.setInvoiceCategory(FscConstants.InvoiceCategory.PAPER);
            fscInvoiceInfoBO.setInvoiceType("00");
        } else if (this.TYPE_SWITCH.booleanValue()) {
            fscInvoiceInfoBO.setInvoiceCategory(FscConstants.InvoiceCategory.ELECTRON);
            fscInvoiceInfoBO.setInvoiceType("00");
        } else if (FscConstants.FscTaxInvType.ELEC_GENERAL.equals(reqBO.getInvType())) {
            fscInvoiceInfoBO.setInvoiceCategory(FscConstants.InvoiceCategory.ELECTRON);
            fscInvoiceInfoBO.setInvoiceType("01");
        } else if (FscConstants.FscTaxInvType.ELEC_SPECIAL.equals(reqBO.getInvType())) {
            fscInvoiceInfoBO.setInvoiceCategory(FscConstants.InvoiceCategory.ELECTRON);
            fscInvoiceInfoBO.setInvoiceType("00");
        }
        if (FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow())) {
            ArrayList<InvoiceItemBO> invoiceItemBOS = new ArrayList<InvoiceItemBO>();
            for (FscBillTaxListDetailEntityQueryBO fscBillTaxListDetailEntityQueryBO : reqBO.getDetail()) {
                FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
                fscOrderItemPO.setFscOrderId(fscOrderId);
                fscOrderItemPO.setOrderItemId(Long.valueOf(Long.parseLong(fscBillTaxListDetailEntityQueryBO.getGoodsNo())));
                fscOrderItemPO = this.fscOrderItemMapper.getModelBy(fscOrderItemPO);
                InvoiceItemBO invoiceItemBO = new InvoiceItemBO();
                invoiceItemBO.setOrderId(fscOrderItemPO.getOrderId());
                invoiceItemBO.setSkuId(fscOrderItemPO.getSkuId());
                invoiceItemBO.setAcceptOrderId(fscBillTaxListDetailEntityQueryBO.getInspectionId());
                invoiceItemBO.setLineNo(fscBillTaxListDetailEntityQueryBO.getLineCode());
                invoiceItemBO.setSkuName(fscBillTaxListDetailEntityQueryBO.getGoodsName());
                invoiceItemBO.setModel(fscBillTaxListDetailEntityQueryBO.getModel());
                invoiceItemBO.setUnit(fscBillTaxListDetailEntityQueryBO.getUnit());
                invoiceItemBO.setNum(fscBillTaxListDetailEntityQueryBO.getQty());
                invoiceItemBO.setPrice(fscBillTaxListDetailEntityQueryBO.getPrice());
                invoiceItemBO.setOrderItemId(Long.valueOf(Long.parseLong(fscBillTaxListDetailEntityQueryBO.getGoodsNo())));
                invoiceItemBO.setAmt(fscBillTaxListDetailEntityQueryBO.getAmount().add(fscBillTaxListDetailEntityQueryBO.getTax()));
                invoiceItemBO.setUntaxAmt(fscBillTaxListDetailEntityQueryBO.getAmount());
                invoiceItemBO.setTaxAmt(fscBillTaxListDetailEntityQueryBO.getTax());
                invoiceItemBO.setTaxCode(fscBillTaxListDetailEntityQueryBO.getTaxClassCode());
                invoiceItemBOS.add(invoiceItemBO);
            }
            fscInvoiceInfoBO.setInvoiceItemBOS(invoiceItemBOS);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPdfUrl())) {
            AttachmentBO attachmentBO = new AttachmentBO();
            attachmentBO.setAttachmentUrl(reqBO.getPdfUrl());
            attachmentBO.setAttachmentName("\u7535\u5b50\u53d1\u7968");
            ArrayList<AttachmentBO> attachmentList = new ArrayList<AttachmentBO>(1);
            attachmentList.add(attachmentBO);
            fscInvoiceInfoBO.setAttachmentList(attachmentList);
        }
        ArrayList<FscInvoiceInfoBO> fscInvoiceInfoBOS = new ArrayList<FscInvoiceInfoBO>();
        fscInvoiceInfoBOS.add(fscInvoiceInfoBO);
        fscBillInvoiceUploadBusiReqBO.setFscInvoiceInfoBOS(fscInvoiceInfoBOS);
        FscBillInvoiceUploadBusiRspBO fscBillInvoiceUploadBusiRspBO = this.fscBillInvoiceUploadBusiService.dealInvoiceUpload(fscBillInvoiceUploadBusiReqBO);
        if (!fscBillInvoiceUploadBusiRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("191026", fscBillInvoiceUploadBusiRspBO.getRespDesc());
        }
        this.sendMq(fscOrderId);
        return new FscBillTaxDealInvoiceAbilityRspBO();
    }

    private void val(FscBillTaxDealInvoiceAbilityReqBO reqBO) {
        if (null == reqBO.getYCompanyNo()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[yCompanyNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getBusiType()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[busiType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderNo()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvCode()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invCode]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvNo()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getTotalAmount()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[totalAmount]\u4e3a\u7a7a");
        }
        if (null == reqBO.getTotalTax()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[totalTax]\u4e3a\u7a7a");
        }
        if (null == reqBO.getDetail() || reqBO.getDetail().size() == 0) {
            throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e3a\u7a7a");
        }
        List detail = reqBO.getDetail();
        for (FscBillTaxListDetailEntityQueryBO fscBillTaxListDetailEntityQueryBO : detail) {
            if (null == fscBillTaxListDetailEntityQueryBO.getInspectionId()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e2d\u7684inspectionId\u4e3a\u7a7a");
            }
            if (null == fscBillTaxListDetailEntityQueryBO.getLineCode()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e2d\u7684linecode\u4e3a\u7a7a");
            }
            if (null == fscBillTaxListDetailEntityQueryBO.getModel()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e2d\u7684model\u4e3a\u7a7a");
            }
            if (null == fscBillTaxListDetailEntityQueryBO.getGoodsName()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e2d\u7684goodsName\u4e3a\u7a7a");
            }
            if (null == fscBillTaxListDetailEntityQueryBO.getUnit()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e2d\u7684unit\u4e3a\u7a7a");
            }
            if (null == fscBillTaxListDetailEntityQueryBO.getQty()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e2d\u7684qry\u4e3a\u7a7a");
            }
            if (null == fscBillTaxListDetailEntityQueryBO.getPrice()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e2d\u7684price\u4e3a\u7a7a");
            }
            if (null == fscBillTaxListDetailEntityQueryBO.getAmount()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e2d\u7684amount\u4e3a\u7a7a");
            }
            if (null == fscBillTaxListDetailEntityQueryBO.getTax()) {
                throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e2d\u7684tax\u4e3a\u7a7a");
            }
            if (null != fscBillTaxListDetailEntityQueryBO.getTaxRate()) continue;
            throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e2d\u7684taxRate\u4e3a\u7a7a");
        }
    }

    private void sendMq(Long fscOrderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscBillMailListSyncAbilityReqBO fscBillMailListSyncAbilityReqBO = new FscBillMailListSyncAbilityReqBO();
        fscBillMailListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscBillMailSyncAbilityService.syncBillMail(fscBillMailListSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
    }
}

