/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.FscBillChangeInfoAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillEcomCheckApplyAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillChangeInfoAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillChangeInfoAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckApplyAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillChangeInfoBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillChangeInfoBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillChangeInfoBusiRspBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillChangeInfoAbilityService"})
public class FscBillChangeInfoAbilityServiceImpl
implements FscBillChangeInfoAbilityService {
    @Autowired
    private FscBillChangeInfoBusiService fscBillChangeInfoBusiService;
    @Autowired
    private FscBillEcomCheckApplyAbilityService fscBillEcomCheckApplyAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;

    @PostMapping(value={"dealBillChange"})
    public FscBillChangeInfoAbilityRspBO dealBillChange(@RequestBody FscBillChangeInfoAbilityReqBO reqBO) {
        this.check(reqBO);
        FscBillChangeInfoAbilityRspBO rspBO = new FscBillChangeInfoAbilityRspBO();
        Long fscOrderId = this.getFscOrderId(reqBO);
        if (ObjectUtil.isNull((Object)fscOrderId)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        FscBillChangeInfoBusiRspBO changeInfoBusiRspBO = this.fscBillChangeInfoBusiService.dealBillChangeInfo((FscBillChangeInfoBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillChangeInfoBusiReqBO.class)));
        if (!"0000".equals(changeInfoBusiRspBO.getRespCode())) {
            throw new FscBusinessException("191038", "\u9a8c\u6536\u5355\u660e\u7ec6\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
        }
        BigDecimal sum = this.sum(fscOrderId);
        this.updateFscOrder(reqBO, sum, fscOrderId);
        this.dealEcomCheckApply(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealEcomCheckApply(FscBillChangeInfoAbilityReqBO reqBO) {
        FscBillEcomCheckApplyAbilityReqBO applyAbilityReqBO = new FscBillEcomCheckApplyAbilityReqBO();
        applyAbilityReqBO.setSupplierId(reqBO.getSupplierId());
        RelOrderBO relOrderBO = new RelOrderBO();
        relOrderBO.setOrderId(reqBO.getOrderId());
        relOrderBO.setAcceptOrderId(reqBO.getAcceptOrderId());
        relOrderBO.setAmount(reqBO.getMyAmount());
        relOrderBO.setOtherNo(relOrderBO.getOtherNo());
        applyAbilityReqBO.setRelOrderList(Collections.singletonList(relOrderBO));
        this.fscBillEcomCheckApplyAbilityService.dealEcomCheckApply(applyAbilityReqBO);
    }

    private void check(FscBillChangeInfoAbilityReqBO reqBO) {
        if (ObjectUtil.isNull((Object)reqBO.getSupplierId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[supplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBO.getAcceptOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[acceptOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBO.getOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty((CharSequence)reqBO.getOtherNo())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[otherNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBO.getMyAmount())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[myAmount]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBO.getUserId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isEmpty((CharSequence)reqBO.getUserName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[userName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty((Collection)reqBO.getFscOrderItemBOList())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[fscOrderItemBOList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void updateFscOrder(FscBillChangeInfoAbilityReqBO reqBO, BigDecimal sum, Long fscOrderId) {
        FscOrderPO set = new FscOrderPO();
        set.setTotalCharge(sum);
        set.setUpdateOperId(reqBO.getUserId().toString());
        set.setUpdateTime(new Date());
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderId(fscOrderId);
        this.fscOrderMapper.updateBy(set, where);
    }

    private BigDecimal sum(Long fscOrderId) {
        FscOrderItemPO fscOrderItemWhere = new FscOrderItemPO();
        fscOrderItemWhere.setFscOrderId(fscOrderId);
        List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemWhere);
        return fscOrderItemPOList.stream().map(FscOrderItemPO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private Long getFscOrderId(FscBillChangeInfoAbilityReqBO reqBO) {
        FscOrderItemPO fscOrderItemWhere = new FscOrderItemPO();
        fscOrderItemWhere.setAcceptOrderId(reqBO.getAcceptOrderId());
        List fscOrderItemList = this.fscOrderItemMapper.getList(fscOrderItemWhere);
        List fscOrderIdList = fscOrderItemList.stream().map(FscOrderItemPO::getFscOrderId).distinct().collect(Collectors.toList());
        return fscOrderIdList.size() > 1 ? null : (Long)fscOrderIdList.get(0);
    }
}

