/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.busi.api.FscBillOrderSplitComputeBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSplitComputeBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSplitComputeBusiRspBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderSplitComputeBusiServiceImpl
implements FscBillOrderSplitComputeBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderSplitComputeBusiServiceImpl.class);
    private static final Integer GROUPWAY_NOSPLIT = 0;
    private static final Integer GROUPWAY_PURUNIT = 1;
    private static final Integer GROUPWAY_ORDER = 2;

    @Override
    public FscBillOrderSplitComputeBusiRspBO getSplitCompute(FscBillOrderSplitComputeBusiReqBO reqBO) {
        List<Object> splitOrderList = new LinkedList();
        Integer ruleType = reqBO.getRuleType();
        if (GROUPWAY_NOSPLIT.equals(ruleType)) {
            splitOrderList = this.noSplit(reqBO);
        } else if (GROUPWAY_PURUNIT.equals(ruleType)) {
            splitOrderList = this.groupByPur(reqBO);
        } else if (GROUPWAY_ORDER.equals(ruleType)) {
            splitOrderList = this.groupByOrder(reqBO);
        }
        LinkedList<SplitOrderBO> splitOrderBOList = new LinkedList<SplitOrderBO>();
        for (List list : splitOrderList) {
            SplitOrderBO splitOrderBO = new SplitOrderBO();
            long purNum = list.stream().map(RelOrderBO::getPurchaserId).distinct().count();
            BigDecimal amt = list.stream().map(RelOrderBO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            splitOrderBO.setPurchaserNum(Integer.valueOf(new Long(purNum).intValue()));
            splitOrderBO.setAmount(amt);
            splitOrderBO.setOrderNum(Integer.valueOf(list.size()));
            splitOrderBO.setRelOrderList(list);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            RelOrderBO relOrderBO = (RelOrderBO)list.get(0);
            splitOrderBO.setSupplierId(relOrderBO.getSupId());
            splitOrderBO.setSupplierName(relOrderBO.getSupName());
            splitOrderBO.setInvoiceTittle(relOrderBO.getInvoiceTittle());
            splitOrderBO.setInvoiceTittleStr(relOrderBO.getInvoiceTittleStr());
            splitOrderBO.setValue1(relOrderBO.getValue1());
            splitOrderBO.setValue2(relOrderBO.getValue2());
            splitOrderBO.setValue3(relOrderBO.getValue3());
            splitOrderBO.setValue4(relOrderBO.getValue4());
            splitOrderBO.setValue5(relOrderBO.getValue5());
            splitOrderBO.setValue6(relOrderBO.getValue6());
            splitOrderBO.setValue7(relOrderBO.getValue7());
            splitOrderBO.setValue8(relOrderBO.getValue8());
            splitOrderBO.setValue9(relOrderBO.getValue9());
            splitOrderBO.setValue10(relOrderBO.getValue10());
            splitOrderBO.setKey1(relOrderBO.getKey1());
            splitOrderBO.setKey2(relOrderBO.getKey2());
            splitOrderBO.setKey3(relOrderBO.getKey3());
            splitOrderBO.setKey4(relOrderBO.getKey4());
            splitOrderBO.setKey5(relOrderBO.getKey5());
            splitOrderBO.setKey6(relOrderBO.getKey6());
            splitOrderBO.setKey7(relOrderBO.getKey7());
            splitOrderBO.setKey8(relOrderBO.getKey8());
            splitOrderBO.setKey9(relOrderBO.getKey9());
            splitOrderBO.setKey10(relOrderBO.getKey10());
            splitOrderBO.setName1(relOrderBO.getName1());
            splitOrderBO.setName2(relOrderBO.getName2());
            splitOrderBO.setName3(relOrderBO.getName3());
            splitOrderBO.setName4(relOrderBO.getName4());
            splitOrderBO.setName5(relOrderBO.getName5());
            splitOrderBO.setName6(relOrderBO.getName6());
            splitOrderBO.setName7(relOrderBO.getName7());
            splitOrderBO.setName8(relOrderBO.getName8());
            splitOrderBO.setName9(relOrderBO.getName9());
            splitOrderBO.setName10(relOrderBO.getName10());
            splitOrderBOList.add(splitOrderBO);
        }
        FscBillOrderSplitComputeBusiRspBO busiRspBO = new FscBillOrderSplitComputeBusiRspBO();
        busiRspBO.setRows(splitOrderBOList);
        if (log.isDebugEnabled()) {
            log.debug("\u5206\u7ec4\u65b9\u5f0f\uff1a{}\uff0c\u5bf9\u5e94\u7684\u62c6\u5206\u7ed3\u679c\u4e3a\uff1a{}", (Object)ruleType, (Object)JSON.toJSONString((Object)((Object)busiRspBO)));
        }
        return busiRspBO;
    }

    private List<List<RelOrderBO>> groupByOrder(FscBillOrderSplitComputeBusiReqBO reqBO) {
        LinkedList<List<RelOrderBO>> orderInfosList = new LinkedList<List<RelOrderBO>>();
        for (RelOrderBO orderInfoVO : reqBO.getRelOrderList()) {
            LinkedList<RelOrderBO> orderInfoForSingleInvoice = new LinkedList<RelOrderBO>();
            orderInfoForSingleInvoice.add(orderInfoVO);
            orderInfosList.add(orderInfoForSingleInvoice);
        }
        return orderInfosList;
    }

    private List<List<RelOrderBO>> groupByPur(FscBillOrderSplitComputeBusiReqBO reqBO) {
        List<List<RelOrderBO>> orderInfosList = this.baseSplit(reqBO.getRelOrderList());
        orderInfosList = this.splitByPurchaseUnit(orderInfosList);
        orderInfosList = this.splitByMaxOrderCount(orderInfosList, reqBO.getMaxOrderCount(), reqBO.getMaxCharge());
        return orderInfosList;
    }

    private List<List<RelOrderBO>> noSplit(FscBillOrderSplitComputeBusiReqBO reqBO) {
        List<List<RelOrderBO>> orderInfosList = this.baseSplit(reqBO.getRelOrderList());
        orderInfosList = this.splitByMaxOrderCount(orderInfosList, reqBO.getMaxOrderCount(), reqBO.getMaxCharge());
        return orderInfosList;
    }

    private List<List<RelOrderBO>> splitByPurchaseUnit(List<List<RelOrderBO>> orderInfosList) {
        LinkedList<List<RelOrderBO>> orderInfosSplitList = new LinkedList<List<RelOrderBO>>();
        LinkedList valList = new LinkedList();
        for (List<RelOrderBO> list : orderInfosList) {
            HashMap purUnitMap = new HashMap(list.size() + 1);
            for (RelOrderBO orderInfoVO : list) {
                if (purUnitMap.containsKey(orderInfoVO.getPurchaserId())) {
                    ((List)purUnitMap.get(orderInfoVO.getPurchaserId())).add(orderInfoVO);
                    continue;
                }
                LinkedList<RelOrderBO> newOrderInfoVOList = new LinkedList<RelOrderBO>();
                newOrderInfoVOList.add(orderInfoVO);
                purUnitMap.put(orderInfoVO.getPurchaserId(), newOrderInfoVOList);
            }
            valList.add(purUnitMap);
        }
        for (Map map : valList) {
            for (Map.Entry entry : map.entrySet()) {
                orderInfosSplitList.add((List<RelOrderBO>)entry.getValue());
            }
        }
        return orderInfosSplitList;
    }

    private List<List<RelOrderBO>> splitByMaxOrderCount(List<List<RelOrderBO>> orderInfosList, Integer maxOrderCount, BigDecimal maxCharge) {
        LinkedList<List<RelOrderBO>> orderInfosSplitList = new LinkedList<List<RelOrderBO>>();
        for (List<RelOrderBO> orderInfoVoList : orderInfosList) {
            LinkedList<RelOrderBO> minOrderInfoForSingle = new LinkedList<RelOrderBO>();
            BigDecimal amt = BigDecimal.ZERO;
            for (RelOrderBO orderInfoVO : orderInfoVoList) {
                if ((amt = amt.add(orderInfoVO.getAmount())).compareTo(maxCharge) > 0 || minOrderInfoForSingle.size() >= maxOrderCount) {
                    if (!CollectionUtils.isEmpty(minOrderInfoForSingle)) {
                        orderInfosSplitList.add(minOrderInfoForSingle);
                    }
                    minOrderInfoForSingle = new LinkedList();
                    amt = orderInfoVO.getAmount();
                }
                minOrderInfoForSingle.add(orderInfoVO);
            }
            orderInfosSplitList.add(minOrderInfoForSingle);
        }
        return orderInfosSplitList;
    }

    private List<List<RelOrderBO>> baseSplit(List<RelOrderBO> relOrderList) {
        LinkedList<List<RelOrderBO>> orderInfosList = new LinkedList<List<RelOrderBO>>();
        orderInfosList.add(relOrderList);
        return orderInfosList;
    }
}

