/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.fsc.bill.busi.api.FscBillOrderSplitComputeBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSplitComputeBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSplitComputeBusiRspBO;
import com.tydic.fsc.bill.busi.bo.checkApplyWrap.FscUocAcceptOrderInfoBO;
import com.tydic.fsc.bill.busi.bo.checkApplyWrap.FscUocQryAcceptOrderListRspBO;
import com.tydic.fsc.bill.comb.api.FscBigDataSplitCombService;
import com.tydic.fsc.bill.comb.bo.FscBigDataSplitCombReqBo;
import com.tydic.fsc.bill.comb.bo.FscBigDataSplitCombRspBo;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.atom.api.FscGeneralQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscGeneralQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscGeneralQueryAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.FscOrderSplitUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscBigDataSplitCombServiceImpl
implements FscBigDataSplitCombService {
    private static final Logger log = LoggerFactory.getLogger(FscBigDataSplitCombServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private FscGeneralQueryAtomService fscGeneralQueryAtomService;
    @Autowired
    private FscOrderSplitUtil fscOrderSplitUtil;
    @Autowired
    private FscBillOrderSplitComputeBusiService fscBillOrderSplitComputeBusiService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Value(value="#{'${create.fsc.order.split.default.param:supId,invoiceTittle,expand1,expand2}'.split(',')}")
    private List<String> defaultSplitParams;
    @Value(value="${create.fsc.order.split.enable:true}")
    private Boolean splitEnable;
    @Value(value="${bigData.split.maxDealCount:20000}")
    private Integer maxCount;
    @Value(value="${bigData.split.qyrCount:1000}")
    private Integer qryCount;
    private static final Integer GROUPWAY_NOSPLIT = 0;

    @Override
    public FscBigDataSplitCombRspBo bigDataSplit(FscBigDataSplitCombReqBo reqBo) {
        this.val(reqBo);
        JSONObject reqJson = JSON.parseObject((String)reqBo.getQryJson());
        ArrayList<SplitOrderBO> splitOrderBOList = new ArrayList<SplitOrderBO>();
        int times = this.maxCount % this.qryCount == 0 ? this.maxCount % this.qryCount : this.maxCount % this.qryCount + 1;
        for (int i = 0; i < times; ++i) {
            reqJson.put("pageNo", (Object)(i + 1));
            reqJson.put("pageSize", (Object)this.qryCount);
            List<FscUocAcceptOrderInfoBO> inspectionList = this.getInspectionList(reqJson);
            List<RelOrderBO> relOrderBOList = inspectionList.stream().map(fscUocAcceptOrderInfoBO -> {
                RelOrderBO relOrderBO = new RelOrderBO();
                relOrderBO.setAcceptOrderId(fscUocAcceptOrderInfoBO.getAcceptOrderId());
                return relOrderBO;
            }).collect(Collectors.toList());
            splitOrderBOList.addAll(this.split(relOrderBOList, reqBo));
        }
        return new FscBigDataSplitCombRspBo();
    }

    private List<SplitOrderBO> split(List<RelOrderBO> relOrderBOList, FscBigDataSplitCombReqBo reqBo) {
        ArrayList<SplitOrderBO> rows = new ArrayList<SplitOrderBO>();
        List<List<RelOrderBO>> baseSplitList = this.baseSplit(relOrderBOList);
        for (List<RelOrderBO> relOrderBOS : baseSplitList) {
            FscBillOrderSplitComputeBusiReqBO busiReqBO = new FscBillOrderSplitComputeBusiReqBO();
            busiReqBO.setMaxCharge(reqBo.getMaxCharge());
            busiReqBO.setMaxOrderCount(reqBo.getMaxOrderCount());
            busiReqBO.setRuleType(reqBo.getRuleType());
            busiReqBO.setRelOrderList(relOrderBOS);
            FscBillOrderSplitComputeBusiRspBO busiRspBO = this.fscBillOrderSplitComputeBusiService.getSplitCompute(busiReqBO);
            if (!"0000".equals(busiRspBO.getRespCode())) {
                throw new FscBusinessException("191020", busiRspBO.getRespDesc());
            }
            rows.addAll(busiRspBO.getRows());
        }
        return rows;
    }

    private List<List<RelOrderBO>> baseSplit(List<RelOrderBO> relOrderList) {
        return this.fscOrderSplitUtil.splitListByFields(relOrderList, this.defaultSplitParams, this.splitEnable.booleanValue());
    }

    private void val(FscBigDataSplitCombReqBo reqBo) {
        if (null == reqBo.getBatchId()) {
            throw new FscBusinessException("198888", "\u62c6\u5206\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getQryJson())) {
            throw new FscBusinessException("198888", "\u7b5b\u9009\u6761\u4ef6json\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private FscCfcUniteParamQryListDetailExternalRspBO getCfcSplitRuleType() {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("order_split_conditon");
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191020", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        return fscCfcUniteParamQryListDetailExternalRspBO;
    }

    private List<FscUocAcceptOrderInfoBO> getInspectionList(JSONObject reqJson) {
        FscGeneralQueryAtomReqBO fscGeneralQueryAtomReqBO = new FscGeneralQueryAtomReqBO();
        fscGeneralQueryAtomReqBO.setQueryCountFlag(Boolean.valueOf(false));
        fscGeneralQueryAtomReqBO.setReqParams(JSON.toJSONString((Object)reqJson));
        log.info("\u62c6\u5355\u8c03\u7528\u67e5\u8be2\u4e2d\u5fc3\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscGeneralQueryAtomReqBO));
        FscGeneralQueryAtomRspBO fscGeneralQueryAtomRspBO = this.fscGeneralQueryAtomService.generalQuery(fscGeneralQueryAtomReqBO);
        log.info("\u62c6\u5355\u8c03\u7528\u67e5\u8be2\u4e2d\u5fc3\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)fscGeneralQueryAtomRspBO.getRspJsonStr());
        return ((FscUocQryAcceptOrderListRspBO)((Object)JSON.parseObject((String)fscGeneralQueryAtomRspBO.getRspJsonStr(), FscUocQryAcceptOrderListRspBO.class))).getRows();
    }
}

