/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.fsc.bill.ability.api.FscBillInvoiceImplAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceImplAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceImplAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillInvoiceImplBusiService;
import com.tydic.fsc.bill.busi.api.FscBillOrderDescUpdateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceImplBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceImplBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderDescUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillInvoiceImplAbilityService"})
public class FscBillInvoiceImplAbilityServiceImpl
implements FscBillInvoiceImplAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscBillInvoiceImplBusiService fscBillInvoiceImplBusiService;
    @Resource(name="ecomInvoiceBatchNo")
    private OrderSequence ecomInvoiceBatchNo;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscBillOrderDescUpdateBusiService fscBillOrderDescUpdateBusiService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;

    @PostMapping(value={"dealInvoiceImpl"})
    public FscBillInvoiceImplAbilityRspBO dealInvoiceImpl(@RequestBody FscBillInvoiceImplAbilityReqBO reqBO) {
        this.val(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getOrderInvoiceInfoByFscOrderId(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191009", "\u67e5\u8be2\u7ed3\u7b97\u4e3b\u5355\u4e3a\u7a7a");
        }
        if (!Convert.toInt((Object)"2").equals(fscOrderPO.getOrderSource())) {
            return new FscBillInvoiceImplAbilityRspBO();
        }
        if (!FscBillStatus.INVOICING_SUBMISSION.getCode().equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191009", "\u5f53\u524d\u72b6\u6001\u4e0d\u5904\u7406\u5f00\u7968");
        }
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderId(reqBO.getOrderId());
        List fscOrderRelationPOS = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderRelationPOS)) {
            throw new FscBusinessException("191009", "\u5f00\u7968\u5931\u8d25\uff0c\u67e5\u8be2\u7ed3\u7b97\u5355\u8ba2\u5355\u4e3a\u7a7a");
        }
        ArrayList<String> extOrderNos = new ArrayList<String>();
        for (FscOrderRelationPO fscOrderRelation : fscOrderRelationPOS) {
            if (StringUtils.isBlank((CharSequence)fscOrderRelation.getExtOrderNo())) {
                throw new FscBusinessException("191009", "\u5f00\u7968\u5931\u8d25\uff0c\u67e5\u8be2\u4f9b\u5e94\u5546\u8ba2\u5355\u53f7\u4e3a\u7a7a");
            }
            extOrderNos.add(fscOrderRelation.getExtOrderNo());
        }
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getOrderId());
        List fscOrderItemPOs = this.fscOrderItemMapper.getList(fscOrderItemPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderItemPOs)) {
            throw new FscBusinessException("191009", "\u5f00\u7968\u5931\u8d25\uff0c\u67e5\u8be2\u7ed3\u7b97\u5355\u660e\u7ec6\u4e3a\u7a7a");
        }
        BigDecimal totalUntaxAmt = fscOrderItemPOs.stream().map(FscOrderItemPO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalTaxAmt = fscOrderItemPOs.stream().map(FscOrderItemPO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        FscBillInvoiceImplBusiReqBO fscBillInvoiceImplBusiReqBO = (FscBillInvoiceImplBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderPO), FscBillInvoiceImplBusiReqBO.class));
        fscBillInvoiceImplBusiReqBO.setExtOrderNos(extOrderNos);
        fscBillInvoiceImplBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        fscBillInvoiceImplBusiReqBO.setInvoiceCategory(fscOrderPO.getInvoiceCategory());
        fscBillInvoiceImplBusiReqBO.setSettlementNakedPrice(totalUntaxAmt);
        fscBillInvoiceImplBusiReqBO.setSettlementTaxPrice(totalTaxAmt);
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType())) {
            fscBillInvoiceImplBusiReqBO.setReceiveOrgName(fscOrderPO.getPurchaserName());
            fscBillInvoiceImplBusiReqBO.setJdOrgId(fscOrderPO.getPurchaserId().toString());
        }
        if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderPO.getReceiveType())) {
            fscBillInvoiceImplBusiReqBO.setReceiveOrgName(fscOrderPO.getProOrgName());
            fscBillInvoiceImplBusiReqBO.setJdOrgId(fscOrderPO.getProOrgId().toString());
        }
        fscBillInvoiceImplBusiReqBO.setReceiveAddr(fscOrderPO.getProvince() + fscOrderPO.getCity() + fscOrderPO.getArea() + fscOrderPO.getTown() + fscOrderPO.getReceiveAddr());
        fscBillInvoiceImplBusiReqBO.setCurrentBatch(this.getCurrentBatch());
        FscBillInvoiceImplBusiRspBO fscBillInvoiceImplBusiRspBO = this.fscBillInvoiceImplBusiService.dealInvoiceImpl(fscBillInvoiceImplBusiReqBO);
        FscBillOrderDescUpdateBusiReqBO fscBillOrderDescUpdateBusiReqBO = new FscBillOrderDescUpdateBusiReqBO();
        fscBillOrderDescUpdateBusiReqBO.setFscOrderId(reqBO.getOrderId());
        FscBillInvoiceImplAbilityRspBO fscBillInvoiceImplAbilityRspBO = new FscBillInvoiceImplAbilityRspBO();
        if (!"0000".equals(fscBillInvoiceImplBusiRspBO.getRespCode())) {
            fscBillOrderDescUpdateBusiReqBO.setOrderDesc(fscBillInvoiceImplBusiRspBO.getRespDesc());
            fscBillInvoiceImplAbilityRspBO.setRespCode(fscBillInvoiceImplBusiRspBO.getRespCode());
            fscBillInvoiceImplAbilityRspBO.setRespDesc(fscBillInvoiceImplBusiRspBO.getRespDesc());
        } else {
            fscBillOrderDescUpdateBusiReqBO.setSuccessRetransFlag("1");
        }
        this.fscBillOrderDescUpdateBusiService.dealOrderDesc(fscBillOrderDescUpdateBusiReqBO);
        this.sendMq(reqBO);
        return fscBillInvoiceImplAbilityRspBO;
    }

    private void val(FscBillInvoiceImplAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2orderId\u4e3a\u7a7a");
        }
    }

    private Long getCurrentBatch() {
        try {
            return this.ecomInvoiceBatchNo.nextId();
        }
        catch (SQLException throwables) {
            throw new FscBusinessException("191000", "\u83b7\u53d6\u7535\u5546\u6279\u6b21\u53f7\u5931\u8d25");
        }
    }

    private void sendMq(FscBillInvoiceImplAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        fscComOrderListSyncAbilityReqBO.setCreateTime(new Date());
        fscComOrderListSyncAbilityReqBO.setSendService(this.getClass().getName());
        fscComOrderListSyncAbilityReqBO.setCreateTime(new Date());
        fscComOrderListSyncAbilityReqBO.setSendService(this.getClass().getName());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

