/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.tydic.fsc.bill.ability.api.FscBillSupCheckConfirmAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillSupCheckConfirmAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillSupCheckConfirmAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillSupCheckConfirmBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillSupCheckConfirmBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillSupCheckConfirmBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillSupCheckConfirmAbilityService"})
public class FscBillSupCheckConfirmAbilityServiceImpl
implements FscBillSupCheckConfirmAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSupCheckConfirmAbilityServiceImpl.class);
    @Autowired
    private FscBillSupCheckConfirmBusiService fscBillSupCheckConfirmBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Value(value="${FSC_FEED_BACK_DOWN_TOPIC:FSC_FEED_BACK_DOWN_TOPIC}")
    private String FSC_FEED_BACK_DOWN_TOPIC;
    @Value(value="${FSC_FEED_BACK_DOWN_TAG:*}")
    private String FSC_FEED_BACK_DOWN_TAG;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealSupCheckConfirm"})
    public FscBillSupCheckConfirmAbilityRspBO dealSupCheckConfirm(@RequestBody FscBillSupCheckConfirmAbilityReqBO reqBO) {
        this.verify(reqBO);
        FscBillSupCheckConfirmBusiReqBO busiReqBO = new FscBillSupCheckConfirmBusiReqBO();
        busiReqBO.setOrderId(reqBO.getOrderId());
        busiReqBO.setResult(reqBO.getResult());
        busiReqBO.setUserId(reqBO.getUserId());
        busiReqBO.setUserName(reqBO.getUserName());
        FscBillSupCheckConfirmBusiRspBO busiRspBO = this.fscBillSupCheckConfirmBusiService.dealSupCheckConfirm(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("191023", busiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        return new FscBillSupCheckConfirmAbilityRspBO();
    }

    private void verify(FscBillSupCheckConfirmAbilityReqBO reqBO) {
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getResult()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[result]\u4e3a\u7a7a");
        }
    }

    private void sendMq(FscBillSupCheckConfirmAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        fscComOrderListSyncAbilityReqBO.setCreateTime(new Date());
        fscComOrderListSyncAbilityReqBO.setSendService(this.getClass().getName());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

