/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillServiceFeeInvoiceUploadAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillServiceFeeInvoiceUploadAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillServiceFeeInvoiceUploadAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillInvoiceUploadBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiRspBO;
import com.tydic.fsc.bo.FscInvoiceInfoBO;
import com.tydic.fsc.common.ability.api.FscBillMailSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscBillMailListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.ExcelUtils;
import com.tydic.fsc.util.FileUtils;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillServiceFeeInvoiceUploadAbilityService"})
public class FscBillServiceFeeInvoiceUploadAbilityServiceImpl
implements FscBillServiceFeeInvoiceUploadAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillServiceFeeInvoiceUploadAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscBillInvoiceUploadBusiService fscBillInvoiceUploadBusiService;
    @Autowired
    private FscBillMailSyncAbilityService fscBillMailSyncAbilityService;
    private static final String BUSI_NAME = "\u670d\u52a1\u8d39\u53d1\u7968\u4e0a\u4f20";
    private static final String BUSI_CODE = "1001";
    public static final Map<Integer, String> ERROR_MAP = new LinkedHashMap<Integer, String>(10);

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealServiceFeeInvoiceUpload"})
    public FscBillServiceFeeInvoiceUploadAbilityRspBO dealServiceFeeInvoiceUpload(@RequestBody FscBillServiceFeeInvoiceUploadAbilityReqBO reqBO) {
        List excelData;
        this.verification(reqBO);
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (!FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPo.getMakeType())) {
            throw new FscBusinessException("191022", "\u5f00\u7968\u65b9\u5fc5\u987b\u4e3a\u8fd0\u8425\u65b9");
        }
        File file = FileUtils.getExcelFileByUrl((String)reqBO.getDataFileUrl());
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile("excel" + file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            excelData = ExcelUtils.getExcelData((MultipartFile)multipartFile, (Integer)1);
            if (log.isDebugEnabled()) {
                log.debug("\u8bfb\u53d6\u7684excel\u6570\u636e:{}", (Object)JSON.toJSONString((Object)excelData));
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new FscBusinessException("191022", "\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
        }
        FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
        fscOrderInvoicePo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderInvoicePo = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePo);
        if (null == fscOrderInvoicePo) {
            throw new FscBusinessException("191022", "\u67e5\u8be2\u7ed3\u7b97\u5355\u53d1\u7968\u4e3a\u7a7a");
        }
        FscBillInvoiceUploadBusiReqBO uploadBusiReqBO = new FscBillInvoiceUploadBusiReqBO();
        ArrayList<FscInvoiceInfoBO> fscInvoiceInfoBos = new ArrayList<FscInvoiceInfoBO>();
        for (List excelDatum : excelData) {
            this.val(excelDatum);
            FscInvoiceInfoBO fscInvoiceInfoBo = (FscInvoiceInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderInvoicePo), FscInvoiceInfoBO.class);
            fscInvoiceInfoBo.setInvoiceId(Long.valueOf(Sequence.getInstance().nextId()));
            fscInvoiceInfoBo.setFscOrderNo((String)excelDatum.get(0));
            fscInvoiceInfoBo.setInvoiceCode((String)excelDatum.get(1));
            fscInvoiceInfoBo.setInvoiceNo((String)excelDatum.get(2));
            fscInvoiceInfoBo.setBillDate((String)excelDatum.get(3));
            fscInvoiceInfoBo.setPurchaserId(fscOrderPo.getPurchaserId());
            fscInvoiceInfoBo.setAmt(new BigDecimal((String)excelDatum.get(5)));
            fscInvoiceInfoBo.setUntaxAmt(new BigDecimal((String)excelDatum.get(6)));
            fscInvoiceInfoBo.setTaxAmt(new BigDecimal((String)excelDatum.get(7)));
            fscInvoiceInfoBo.setTax((String)excelDatum.get(8));
            fscInvoiceInfoBos.add(fscInvoiceInfoBo);
        }
        uploadBusiReqBO.setFscInvoiceInfoBOS(fscInvoiceInfoBos);
        uploadBusiReqBO.setFscOrderId(reqBO.getFscOrderId());
        uploadBusiReqBO.setBusiName(BUSI_NAME);
        uploadBusiReqBO.setCurStatus(FscBillStatus.TO_BE_INVOICED.getCode());
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("directFlag", FscConstants.BillOrderDirectFlag.SERVICE_FEE_UPLOAD);
        uploadBusiReqBO.setParamMap(paramMap);
        FscBillInvoiceUploadBusiRspBO fscBillInvoiceUploadBusiRspBO = this.fscBillInvoiceUploadBusiService.dealInvoiceUpload(uploadBusiReqBO);
        if (!"0000".equals(fscBillInvoiceUploadBusiRspBO.getRespCode())) {
            throw new FscBusinessException("191022", fscBillInvoiceUploadBusiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        return new FscBillServiceFeeInvoiceUploadAbilityRspBO();
    }

    private void val(List<String> excelDatum) {
        for (int i = 0; i < excelDatum.size(); ++i) {
            if (!StringUtils.isBlank((CharSequence)excelDatum.get(i))) continue;
            throw new FscBusinessException("191022", ERROR_MAP.get(i));
        }
    }

    private void verification(FscBillServiceFeeInvoiceUploadAbilityReqBO reqBO) {
        if (null == reqBO.getDataFileUrl() || "".equals(reqBO.getDataFileUrl())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[dataFileUrl]\u4e3a\u7a7a");
        }
        if (null == reqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fscOrderId]\u4e3a\u7a7a");
        }
    }

    private void sendMq(FscBillServiceFeeInvoiceUploadAbilityReqBO reqBO) {
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscComInvoiceListSyncAbilityReqBO.setCreateTime(new Date());
        fscComInvoiceListSyncAbilityReqBO.setSendService(this.getClass().getName());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscComOrderListSyncAbilityReqBO.setCreateTime(new Date());
        fscComOrderListSyncAbilityReqBO.setSendService(this.getClass().getName());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscBillMailListSyncAbilityReqBO fscBillMailListSyncAbilityReqBO = new FscBillMailListSyncAbilityReqBO();
        fscBillMailListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscBillMailListSyncAbilityReqBO.setCreateTime(new Date());
        fscBillMailListSyncAbilityReqBO.setSendService(this.getClass().getName());
        this.fscBillMailSyncAbilityService.syncBillMail(fscBillMailListSyncAbilityReqBO);
    }

    static {
        ERROR_MAP.put(0, "\u3010\u7ed3\u7b97\u5355\u53f7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        ERROR_MAP.put(1, "\u3010\u53d1\u7968\u4ee3\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        ERROR_MAP.put(2, "\u3010\u53d1\u7968\u53f7\u7801\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        ERROR_MAP.put(3, "\u3010\u5f00\u7968\u65e5\u671f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        ERROR_MAP.put(4, "\u3010\u91c7\u8d2d\u5355\u4f4d\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        ERROR_MAP.put(5, "\u3010\u4ef7\u7a0e\u5408\u8ba1\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        ERROR_MAP.put(6, "\u3010\u91d1\u989d(\u4e0d\u542b\u7a0e)\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        ERROR_MAP.put(7, "\u3010\u7a0e\u989d\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        ERROR_MAP.put(8, "\u3010\u7a0e\u7387\u3011\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

