/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.convert.Convert;
import com.tydic.fsc.bill.ability.api.FscBillAutoSignAbilityService;
import com.tydic.fsc.bill.ability.api.FscGetInvoiceDataAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillAutoSignAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscGetInvoiceDataAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscGetInvoiceDataAbilityRspBO;
import com.tydic.fsc.bill.atom.api.FscFileUploadOSSByUrlAtomService;
import com.tydic.fsc.bill.atom.bo.FscFileUploadOSSByUrlAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscFileUploadOSSByUrlAtomRspBO;
import com.tydic.fsc.bill.busi.api.FscBillInvoiceUploadBusiService;
import com.tydic.fsc.bill.busi.api.FscBillOrderDescUpdateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderDescUpdateBusiReqBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscInvoiceInfoBO;
import com.tydic.fsc.bo.InvoiceItemBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoItemReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoItemRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoItemSkuRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoListRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.busibase.external.api.esb.FscGetInvoiceInfoExternalService;
import com.tydic.fsc.busibase.external.api.esb.FscGetInvoiceInfoItemExternalService;
import com.tydic.fsc.common.ability.api.FscBillMailSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComInvoiceDeleteSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscBillMailListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceDeleteSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscGetInvoiceDataAbilityService"})
public class FscGetInvoiceDataAbilityServiceImpl
implements FscGetInvoiceDataAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscGetInvoiceDataAbilityServiceImpl.class);
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscComInvoiceDeleteSyncAbilityService fscComInvoiceDeleteSyncAbilityService;
    @Autowired
    private FscBillInvoiceUploadBusiService fscBillInvoiceUploadBusiService;
    @Autowired
    private FscGetInvoiceInfoExternalService fscGetInvoiceInfoExternalService;
    @Autowired
    private FscGetInvoiceInfoItemExternalService fscGetInvoiceInfoItemExternalService;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscBillMailSyncAbilityService fscBillMailSyncAbilityService;
    @Autowired
    private FscBillAutoSignAbilityService fscBillAutoSignAbilityService;
    @Autowired
    private FscBillOrderDescUpdateBusiService fscBillOrderDescUpdateBusiService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscFileUploadOSSByUrlAtomService fscFileUploadOSSByUrlAtomService;
    @Value(value="#{'${ecom.invoice.convertUrl.supplierId:}'.split(',')}")
    private List<String> convertUrlSupplierIds;
    private static final String AUTO_SIGN = "0";
    private static final String BUSI_NAME = "\u83b7\u53d6\u7535\u5546\u53d1\u7968";
    private static final String NOT_NEED_INVOICE_INFO = "0";
    @Value(value="${JD_SUPPLIER_ID:100055}")
    private Long JD_SUPPLIER_ID;

    @PostMapping(value={"getInvoiceData"})
    public FscGetInvoiceDataAbilityRspBO getInvoiceData(@RequestBody FscGetInvoiceDataAbilityReqBO reqBO) {
        this.val(reqBO);
        FscGetInvoiceInfoReqBO fscGetInvoiceInfoReqBO = new FscGetInvoiceInfoReqBO();
        fscGetInvoiceInfoReqBO.setMarkId(String.valueOf(reqBO.getFscOrderId()));
        fscGetInvoiceInfoReqBO.setSupplierId(String.valueOf(reqBO.getSupplierId()));
        fscGetInvoiceInfoReqBO.setProOrgId(String.valueOf(reqBO.getProOrgId()));
        FscGetInvoiceInfoRspBO invoiceInfo = this.fscGetInvoiceInfoExternalService.getInvoiceInfo(fscGetInvoiceInfoReqBO);
        if (!"0000".equals(invoiceInfo.getRespCode())) {
            throw new FscBusinessException("191031", invoiceInfo.getRespDesc());
        }
        List invoiceInfoResultList = invoiceInfo.getResult();
        FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
        fscOrderInvoicePo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderInvoicePo = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePo);
        if (null == fscOrderInvoicePo) {
            throw new FscBusinessException("191031", "\u67e5\u8be2\u4e3b\u5355\u53d1\u7968\u4e3a\u7a7a");
        }
        FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
        fscOrderItemPo.setFscOrderId(reqBO.getFscOrderId());
        List fscOrderItemPos = this.fscOrderItemMapper.getListBySkuNumNotZero(fscOrderItemPo);
        if (CollectionUtils.isEmpty((Collection)fscOrderItemPos)) {
            throw new FscBusinessException("191031", "\u67e5\u8be2\u4e3b\u5355\u660e\u7ec6\u4e3a\u7a7a");
        }
        Boolean isAutoSign = this.isAutoSign(reqBO);
        ArrayList<FscInvoiceInfoBO> fscInvoiceInfoBos = new ArrayList<FscInvoiceInfoBO>();
        if (!CollectionUtils.isEmpty((Collection)invoiceInfoResultList)) {
            for (FscGetInvoiceInfoListRspBO fscGetInvoiceInfoListRspBO : invoiceInfoResultList) {
                FscInvoiceInfoBO fscInvoiceInfoBO = this.createEntity(fscGetInvoiceInfoListRspBO, reqBO, fscOrderInvoicePo, fscOrderItemPos);
                fscInvoiceInfoBos.add(fscInvoiceInfoBO);
            }
        }
        FscBillInvoiceUploadBusiReqBO fscBillInvoiceUploadBusiReqBO = new FscBillInvoiceUploadBusiReqBO();
        fscBillInvoiceUploadBusiReqBO.setFscInvoiceInfoBOS(fscInvoiceInfoBos);
        fscBillInvoiceUploadBusiReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscBillInvoiceUploadBusiReqBO.setBusiName(BUSI_NAME);
        fscBillInvoiceUploadBusiReqBO.setCurStatus(FscBillStatus.INVOICING_SUBMISSION.getCode());
        FscBillInvoiceUploadBusiRspBO fscBillInvoiceUploadBusiRspBO = this.fscBillInvoiceUploadBusiService.dealInvoiceUpload(fscBillInvoiceUploadBusiReqBO);
        if (!"0000".equals(fscBillInvoiceUploadBusiRspBO.getRespCode())) {
            throw new FscBusinessException("191031", fscBillInvoiceUploadBusiRspBO.getRespDesc());
        }
        this.updateOrderDesc(reqBO.getFscOrderId());
        this.sendMq(reqBO);
        if (isAutoSign.booleanValue()) {
            this.autoSign(reqBO);
        }
        return new FscGetInvoiceDataAbilityRspBO();
    }

    private void autoSign(FscGetInvoiceDataAbilityReqBO reqBO) {
        FscBillAutoSignAbilityReqBO fscBillAutoSignAbilityReqBO = new FscBillAutoSignAbilityReqBO();
        fscBillAutoSignAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscBillAutoSignAbilityReqBO.setUserId(reqBO.getUserId());
        fscBillAutoSignAbilityReqBO.setUserName(reqBO.getUserName());
        this.fscBillAutoSignAbilityService.dealAutoSign(fscBillAutoSignAbilityReqBO);
    }

    private boolean isAutoSign(FscGetInvoiceDataAbilityReqBO reqBO) {
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
            FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
            fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("operinvoice_sign");
            fscCfcUniteParamQryListDetailExternalReqBO.setRelId(String.valueOf(reqBO.getProOrgId()));
            FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
            if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
                throw new FscBusinessException("191031", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
            }
            if (StringUtils.isBlank((String)fscCfcUniteParamQryListDetailExternalRspBO.getReqSign())) {
                throw new FscBusinessException("191031", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3[operinvoice_sign]\u8fd4\u56de[reqSign]\u4e3a\u7a7a");
            }
            return "0".equals(fscCfcUniteParamQryListDetailExternalRspBO.getReqSign());
        }
        return false;
    }

    private boolean needInvoiceInfos() {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("invoice_upload_details_2");
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191031", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getReqDetailed())) {
            String reqDetailed = fscCfcUniteParamQryListDetailExternalRspBO.getReqDetailed();
            return !"0".equals(reqDetailed);
        }
        return true;
    }

    private void val(FscGetInvoiceDataAbilityReqBO reqBO) {
        if (null == reqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fscOrderId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getReceiveType()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[receiveType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getMakeType()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[makeType]\u4e3a\u7a7a");
        }
    }

    private FscInvoiceInfoBO createEntity(FscGetInvoiceInfoListRspBO fscGetInvoiceInfoListRspBO, FscGetInvoiceDataAbilityReqBO reqBO, FscOrderInvoicePO fscOrderInvoicePo, List<FscOrderItemPO> fscOrderItemPos) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        FscInvoiceInfoBO fscInvoiceInfoBO = new FscInvoiceInfoBO();
        ArrayList<InvoiceItemBO> invoiceItemBOList = new ArrayList<InvoiceItemBO>();
        if (!this.needInvoiceInfos()) {
            fscOrderItemPos.forEach(fscOrderItemPo -> {
                InvoiceItemBO invoiceItemBO = new InvoiceItemBO();
                invoiceItemBO.setFscOrderId(fscOrderItemPo.getFscOrderId());
                invoiceItemBO.setAcceptOrderId(fscOrderItemPo.getAcceptOrderId());
                invoiceItemBO.setOrderId(fscOrderItemPo.getOrderId());
                invoiceItemBO.setOrderItemId(fscOrderItemPo.getOrderItemId());
                invoiceItemBO.setSkuId(fscOrderItemPo.getSkuId());
                invoiceItemBO.setSkuName(fscOrderItemPo.getSkuName());
                invoiceItemBO.setSpec(fscOrderItemPo.getSpec());
                invoiceItemBO.setModel(fscOrderItemPo.getModel());
                invoiceItemBO.setPrice(fscOrderItemPo.getPrice());
                invoiceItemBO.setTaxAmt(fscOrderItemPo.getTaxAmt());
                invoiceItemBO.setUnit(fscOrderItemPo.getUnit());
                invoiceItemBO.setTaxCode(fscOrderItemPo.getTaxCode());
                invoiceItemBO.setNum(fscOrderItemPo.getNum());
                invoiceItemBO.setAmt(fscOrderItemPo.getAmt());
                invoiceItemBO.setTaxRate(fscOrderItemPo.getTaxRate());
                invoiceItemBO.setUntaxAmt(fscOrderItemPo.getUntaxAmt());
                invoiceItemBOList.add(invoiceItemBO);
            });
        } else if (this.JD_SUPPLIER_ID.equals(reqBO.getSupplierId())) {
            this.jdInvoiceItem(fscGetInvoiceInfoListRspBO, reqBO, fscOrderItemPos, invoiceItemBOList);
        } else {
            this.otherEcomInvoiceItem(fscGetInvoiceInfoListRspBO, reqBO, fscOrderItemPos, invoiceItemBOList);
        }
        fscInvoiceInfoBO.setInvoiceItemBOS(invoiceItemBOList);
        fscInvoiceInfoBO.setFscOrderId(reqBO.getFscOrderId());
        fscInvoiceInfoBO.setInvoiceType(fscOrderInvoicePo.getInvoiceType());
        fscInvoiceInfoBO.setInvoiceCategory(fscOrderInvoicePo.getInvoiceCategory());
        fscInvoiceInfoBO.setCreateTime(fscOrderInvoicePo.getBillTime());
        fscInvoiceInfoBO.setCreateOperId(fscOrderInvoicePo.getBillOperId());
        fscInvoiceInfoBO.setCreateOperName(fscOrderInvoicePo.getBillOperName());
        fscInvoiceInfoBO.setInvoiceCode(fscGetInvoiceInfoListRspBO.getInvoiceCode());
        fscInvoiceInfoBO.setInvoiceNo(fscGetInvoiceInfoListRspBO.getInvoiceId());
        fscInvoiceInfoBO.setBillDate(simpleDateFormat.format(fscGetInvoiceInfoListRspBO.getInvoiceDate()));
        fscInvoiceInfoBO.setUntaxAmt(fscGetInvoiceInfoListRspBO.getInvoiceNakedAmount());
        fscInvoiceInfoBO.setTax(fscGetInvoiceInfoListRspBO.getInvoiceTaxRate());
        fscInvoiceInfoBO.setTaxAmt(fscGetInvoiceInfoListRspBO.getInvoiceTaxAmount());
        fscInvoiceInfoBO.setAmt(fscGetInvoiceInfoListRspBO.getInvoiceAmount());
        if (this.JD_SUPPLIER_ID.equals(reqBO.getSupplierId())) {
            if (FscConstants.InvoiceCategory.ELECTRON.equals(fscOrderInvoicePo.getInvoiceCategory())) {
                fscInvoiceInfoBO.setUntaxAmt(invoiceItemBOList.stream().map(InvoiceItemBO::getUntaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
                fscInvoiceInfoBO.setTaxAmt(invoiceItemBOList.stream().map(InvoiceItemBO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            fscInvoiceInfoBO.setBuyName(fscOrderInvoicePo.getBuyName());
            fscInvoiceInfoBO.setTaxNo(fscOrderInvoicePo.getTaxNo());
            fscInvoiceInfoBO.setAddress(fscOrderInvoicePo.getAddress());
            fscInvoiceInfoBO.setPhone(fscOrderInvoicePo.getPhone());
            fscInvoiceInfoBO.setAccount(fscOrderInvoicePo.getAccount());
            fscInvoiceInfoBO.setBank(fscOrderInvoicePo.getBank());
        } else {
            fscInvoiceInfoBO.setBuyName(fscGetInvoiceInfoListRspBO.getTitle());
            fscInvoiceInfoBO.setTaxNo(fscGetInvoiceInfoListRspBO.getEnterpriseTaxpayer());
            fscInvoiceInfoBO.setAddress(fscGetInvoiceInfoListRspBO.getAddress());
            fscInvoiceInfoBO.setPhone(fscGetInvoiceInfoListRspBO.getTel());
            fscInvoiceInfoBO.setAccount(fscGetInvoiceInfoListRspBO.getAccount());
            fscInvoiceInfoBO.setBank(fscGetInvoiceInfoListRspBO.getBank());
        }
        if (!StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getFileUrl())) {
            ArrayList<AttachmentBO> attachmentBos = new ArrayList<AttachmentBO>();
            AttachmentBO attachmentBo = new AttachmentBO();
            attachmentBo.setAttachmentType(FscConstants.AttachmentType.INVOICE);
            if (this.convertUrlSupplierIds.contains(reqBO.getSupplierId().toString())) {
                attachmentBo.setAttachmentUrl(this.getFileUrl(fscGetInvoiceInfoListRspBO.getFileUrl()));
                attachmentBo.setAttachmentUrlSource(fscGetInvoiceInfoListRspBO.getFileUrl());
            } else {
                attachmentBo.setAttachmentUrl(fscGetInvoiceInfoListRspBO.getFileUrl());
            }
            attachmentBos.add(attachmentBo);
            fscInvoiceInfoBO.setAttachmentList(attachmentBos);
        }
        return fscInvoiceInfoBO;
    }

    private void jdInvoiceItem(FscGetInvoiceInfoListRspBO fscGetInvoiceInfoListRspBO, FscGetInvoiceDataAbilityReqBO reqBO, List<FscOrderItemPO> fscOrderItemPos, List<InvoiceItemBO> invoiceItemBOList) {
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderId(reqBO.getFscOrderId());
        List fscOrderRelationPOS = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
        Map orderRelationPOMap = fscOrderRelationPOS.stream().collect(Collectors.toMap(FscOrderRelationPO::getOrderId, Function.identity(), (old, cur) -> cur));
        FscGetInvoiceInfoItemReqBO fscGetInvoiceInfoItemReqBO = new FscGetInvoiceInfoItemReqBO();
        fscGetInvoiceInfoItemReqBO.setInvoiceCode(fscGetInvoiceInfoListRspBO.getInvoiceCode());
        fscGetInvoiceInfoItemReqBO.setInvoiceId(fscGetInvoiceInfoListRspBO.getInvoiceId());
        fscGetInvoiceInfoItemReqBO.setSupplierId(String.valueOf(reqBO.getSupplierId()));
        fscGetInvoiceInfoItemReqBO.setProOrgId(String.valueOf(reqBO.getProOrgId()));
        FscGetInvoiceInfoItemRspBO invoiceInfoItem = this.fscGetInvoiceInfoItemExternalService.getInvoiceInfoItem(fscGetInvoiceInfoItemReqBO);
        if (!"0000".equals(invoiceInfoItem.getRespCode())) {
            throw new FscBusinessException("191031", invoiceInfoItem.getRespDesc());
        }
        List skuEntity = invoiceInfoItem.getResult().getSkuEntity();
        if (CollectionUtils.isEmpty((Collection)skuEntity)) {
            throw new FscBusinessException("191031", "\u83b7\u53d6\u7535\u5546\u53d1\u7968Sku\u5217\u8868\u4e3a\u7a7a");
        }
        Map<String, FscGetInvoiceInfoItemSkuRspBO> extInvoiceItemMap = skuEntity.stream().collect(Collectors.toMap(extSku -> extSku.getSupplierOrder() + extSku.getExtSkuId(), v -> v));
        if (!CollectionUtils.isEmpty(extInvoiceItemMap) && extInvoiceItemMap.size() >= fscOrderItemPos.size()) {
            fscOrderItemPos.forEach(fscOrderItemPo -> {
                String extKey = ((FscOrderRelationPO)orderRelationPOMap.get(fscOrderItemPo.getOrderId())).getExtOrderNo() + fscOrderItemPo.getSkuIdExt();
                InvoiceItemBO invoiceItemBO = new InvoiceItemBO();
                invoiceItemBO.setFscOrderId(fscOrderItemPo.getFscOrderId());
                invoiceItemBO.setAcceptOrderId(fscOrderItemPo.getAcceptOrderId());
                invoiceItemBO.setOrderId(fscOrderItemPo.getOrderId());
                invoiceItemBO.setOrderItemId(fscOrderItemPo.getOrderItemId());
                invoiceItemBO.setSkuId(fscOrderItemPo.getSkuId());
                invoiceItemBO.setSkuName(fscOrderItemPo.getSkuName());
                invoiceItemBO.setSpec(fscOrderItemPo.getSpec());
                invoiceItemBO.setModel(fscOrderItemPo.getModel());
                invoiceItemBO.setPrice(fscOrderItemPo.getPrice());
                invoiceItemBO.setTaxRate(Convert.toBigDecimal((Object)((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(extKey)).getTax()));
                invoiceItemBO.setTaxAmt(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(extKey)).getTaxAmount());
                invoiceItemBO.setUnit(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(extKey)).getSettleUnit());
                invoiceItemBO.setTaxCode(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(extKey)).getTaxId());
                invoiceItemBO.setNum(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(extKey)).getNum());
                invoiceItemBO.setAmt(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(extKey)).getAmount());
                invoiceItemBO.setUntaxAmt(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(extKey)).getAmountUnTax());
                invoiceItemBOList.add(invoiceItemBO);
            });
        }
        if (!CollectionUtils.isEmpty(extInvoiceItemMap) && extInvoiceItemMap.size() < fscOrderItemPos.size()) {
            Map<String, FscOrderItemPO> fscOrderItemMap = fscOrderItemPos.stream().collect(Collectors.toMap(FscOrderItemPO::getSkuIdExt, o -> o));
            extInvoiceItemMap.values().forEach(fscGetInvoiceInfoItemSkuRspBO -> {
                InvoiceItemBO invoiceItemBO = new InvoiceItemBO();
                invoiceItemBO.setFscOrderId(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getFscOrderId());
                invoiceItemBO.setAcceptOrderId(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getAcceptOrderId());
                invoiceItemBO.setOrderId(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getOrderId());
                invoiceItemBO.setOrderItemId(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getOrderItemId());
                invoiceItemBO.setSkuId(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getSkuId());
                invoiceItemBO.setSkuName(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getSkuName());
                invoiceItemBO.setSpec(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getSpec());
                invoiceItemBO.setModel(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getModel());
                invoiceItemBO.setPrice(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getPrice());
                invoiceItemBO.setTaxRate(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getTaxRate());
                invoiceItemBO.setTaxAmt(fscGetInvoiceInfoItemSkuRspBO.getTaxAmount());
                invoiceItemBO.setUnit(fscGetInvoiceInfoItemSkuRspBO.getSettleUnit());
                invoiceItemBO.setTaxCode(fscGetInvoiceInfoItemSkuRspBO.getTaxId());
                invoiceItemBO.setNum(fscGetInvoiceInfoItemSkuRspBO.getNum());
                invoiceItemBO.setAmt(fscGetInvoiceInfoItemSkuRspBO.getAmount());
                invoiceItemBO.setUntaxAmt(fscGetInvoiceInfoItemSkuRspBO.getAmountUnTax());
                invoiceItemBOList.add(invoiceItemBO);
            });
        }
    }

    private void otherEcomInvoiceItem(FscGetInvoiceInfoListRspBO fscGetInvoiceInfoListRspBO, FscGetInvoiceDataAbilityReqBO reqBO, List<FscOrderItemPO> fscOrderItemPos, List<InvoiceItemBO> invoiceItemBOList) {
        FscGetInvoiceInfoItemReqBO fscGetInvoiceInfoItemReqBO = new FscGetInvoiceInfoItemReqBO();
        fscGetInvoiceInfoItemReqBO.setInvoiceCode(fscGetInvoiceInfoListRspBO.getInvoiceCode());
        fscGetInvoiceInfoItemReqBO.setInvoiceId(fscGetInvoiceInfoListRspBO.getInvoiceId());
        fscGetInvoiceInfoItemReqBO.setSupplierId(String.valueOf(reqBO.getSupplierId()));
        fscGetInvoiceInfoItemReqBO.setProOrgId(String.valueOf(reqBO.getProOrgId()));
        FscGetInvoiceInfoItemRspBO invoiceInfoItem = this.fscGetInvoiceInfoItemExternalService.getInvoiceInfoItem(fscGetInvoiceInfoItemReqBO);
        if (!"0000".equals(invoiceInfoItem.getRespCode())) {
            throw new FscBusinessException("191031", invoiceInfoItem.getRespDesc());
        }
        List skuEntity = invoiceInfoItem.getResult().getSkuEntity();
        if (CollectionUtils.isEmpty((Collection)skuEntity)) {
            throw new FscBusinessException("191031", "\u83b7\u53d6\u7535\u5546\u53d1\u7968Sku\u5217\u8868\u4e3a\u7a7a");
        }
        Map<String, FscGetInvoiceInfoItemSkuRspBO> extInvoiceItemMap = skuEntity.stream().collect(Collectors.toMap(extSku -> extSku.getEOrderId() + extSku.getExtSkuId(), v -> v));
        if (!CollectionUtils.isEmpty(extInvoiceItemMap) && extInvoiceItemMap.size() >= fscOrderItemPos.size()) {
            fscOrderItemPos.forEach(fscOrderItemPo -> {
                String extKey = fscOrderItemPo.getOrderId() + fscOrderItemPo.getSkuIdExt();
                InvoiceItemBO invoiceItemBO = new InvoiceItemBO();
                invoiceItemBO.setFscOrderId(fscOrderItemPo.getFscOrderId());
                invoiceItemBO.setAcceptOrderId(fscOrderItemPo.getAcceptOrderId());
                invoiceItemBO.setOrderId(fscOrderItemPo.getOrderId());
                invoiceItemBO.setOrderItemId(fscOrderItemPo.getOrderItemId());
                invoiceItemBO.setSkuId(fscOrderItemPo.getSkuId());
                invoiceItemBO.setSkuName(fscOrderItemPo.getSkuName());
                invoiceItemBO.setSpec(fscOrderItemPo.getSpec());
                invoiceItemBO.setModel(fscOrderItemPo.getModel());
                invoiceItemBO.setPrice(fscOrderItemPo.getPrice());
                invoiceItemBO.setTaxRate(Convert.toBigDecimal((Object)((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(extKey)).getTax()));
                invoiceItemBO.setTaxAmt(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(extKey)).getTaxAmount());
                invoiceItemBO.setUnit(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(extKey)).getSettleUnit());
                invoiceItemBO.setTaxCode(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(extKey)).getTaxId());
                invoiceItemBO.setNum(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(extKey)).getNum());
                invoiceItemBO.setAmt(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(extKey)).getAmount());
                invoiceItemBO.setUntaxAmt(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(extKey)).getAmountUnTax());
                invoiceItemBOList.add(invoiceItemBO);
            });
        }
        if (!CollectionUtils.isEmpty(extInvoiceItemMap) && extInvoiceItemMap.size() < fscOrderItemPos.size()) {
            Map<String, FscOrderItemPO> fscOrderItemMap = fscOrderItemPos.stream().collect(Collectors.toMap(FscOrderItemPO::getSkuIdExt, o -> o));
            extInvoiceItemMap.values().forEach(fscGetInvoiceInfoItemSkuRspBO -> {
                InvoiceItemBO invoiceItemBO = new InvoiceItemBO();
                invoiceItemBO.setFscOrderId(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getFscOrderId());
                invoiceItemBO.setAcceptOrderId(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getAcceptOrderId());
                invoiceItemBO.setOrderId(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getOrderId());
                invoiceItemBO.setOrderItemId(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getOrderItemId());
                invoiceItemBO.setSkuId(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getSkuId());
                invoiceItemBO.setSkuName(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getSkuName());
                invoiceItemBO.setSpec(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getSpec());
                invoiceItemBO.setModel(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getModel());
                invoiceItemBO.setPrice(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getPrice());
                invoiceItemBO.setTaxRate(((FscOrderItemPO)fscOrderItemMap.get(fscGetInvoiceInfoItemSkuRspBO.getExtSkuId())).getTaxRate());
                invoiceItemBO.setTaxAmt(fscGetInvoiceInfoItemSkuRspBO.getTaxAmount());
                invoiceItemBO.setUnit(fscGetInvoiceInfoItemSkuRspBO.getSettleUnit());
                invoiceItemBO.setTaxCode(fscGetInvoiceInfoItemSkuRspBO.getTaxId());
                invoiceItemBO.setNum(fscGetInvoiceInfoItemSkuRspBO.getNum());
                invoiceItemBO.setAmt(fscGetInvoiceInfoItemSkuRspBO.getAmount());
                invoiceItemBO.setUntaxAmt(fscGetInvoiceInfoItemSkuRspBO.getAmountUnTax());
                invoiceItemBOList.add(invoiceItemBO);
            });
        }
    }

    private String getFileUrl(String fileUrl) {
        FscFileUploadOSSByUrlAtomReqBO fscFileUploadOSSByUrlAtomReqBO = new FscFileUploadOSSByUrlAtomReqBO();
        fscFileUploadOSSByUrlAtomReqBO.setOldUrl(fileUrl);
        FscFileUploadOSSByUrlAtomRspBO fscFileUploadOSSByUrlAtomRspBO = this.fscFileUploadOSSByUrlAtomService.uploadFileByBrl(fscFileUploadOSSByUrlAtomReqBO);
        if (!"0000".equals(fscFileUploadOSSByUrlAtomRspBO.getRespCode())) {
            return fileUrl;
        }
        return fscFileUploadOSSByUrlAtomRspBO.getInnerFileUrl();
    }

    private void sendMq(FscGetInvoiceDataAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscComOrderListSyncAbilityReqBO.setCreateTime(new Date());
        fscComOrderListSyncAbilityReqBO.setSendService(this.getClass().getName());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscComInvoiceDeleteSyncAbilityReqBO fscComInvoiceDeleteSyncAbilityReqBO = new FscComInvoiceDeleteSyncAbilityReqBO();
        fscComInvoiceDeleteSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComInvoiceDeleteSyncAbilityService.deleteComInvoiceSyncEs(fscComInvoiceDeleteSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscComInvoiceListSyncAbilityReqBO.setCreateTime(new Date());
        fscComInvoiceListSyncAbilityReqBO.setSendService(this.getClass().getName());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
            FscBillMailListSyncAbilityReqBO fscBillMailListSyncAbilityReqBO = new FscBillMailListSyncAbilityReqBO();
            fscBillMailListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
            fscBillMailListSyncAbilityReqBO.setCreateTime(new Date());
            fscBillMailListSyncAbilityReqBO.setSendService(this.getClass().getName());
            this.fscBillMailSyncAbilityService.syncBillMail(fscBillMailListSyncAbilityReqBO);
        }
    }

    private void updateOrderDesc(Long fscOrderId) {
        FscBillOrderDescUpdateBusiReqBO fscBillOrderDescUpdateBusiReqBO = new FscBillOrderDescUpdateBusiReqBO();
        fscBillOrderDescUpdateBusiReqBO.setFscOrderId(fscOrderId);
        fscBillOrderDescUpdateBusiReqBO.setSuccessRetransFlag("1");
        this.fscBillOrderDescUpdateBusiService.dealOrderDesc(fscBillOrderDescUpdateBusiReqBO);
    }
}

