/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.consumer;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.bill.ability.api.FscBillOrderFeedbackAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderFeedbackAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderFeedbackAbilityRspBO;
import com.tydic.fsc.busibase.busi.api.FscSystemBusiLogBusiService;
import com.tydic.fsc.busibase.busi.bo.FscSystemBusiLogBusiServiceReqBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FscFeedBackDownServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscFeedBackDownServiceConsumer.class);
    @Autowired
    private FscBillOrderFeedbackAbilityService fscBillOrderFeedbackAbilityService;
    @Autowired
    private FscSystemBusiLogBusiService fscSystemBusiLogBusiService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            FscBillOrderFeedbackAbilityRspBO rspBO;
            FscBillOrderFeedbackAbilityReqBO feedbackAbilityReqBO = (FscBillOrderFeedbackAbilityReqBO)JSON.parseObject((String)message.getContent(), FscBillOrderFeedbackAbilityReqBO.class);
            if (log.isDebugEnabled()) {
                log.debug("\u4e0a\u6e38\u5bf9\u8d26\u786e\u8ba4\u81ea\u52a8\u53cd\u9988\u4e0b\u6e38\u6d88\u8d39\u8005\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)feedbackAbilityReqBO));
            }
            if (!"0000".equals((rspBO = this.fscBillOrderFeedbackAbilityService.dealOrderFeedback(feedbackAbilityReqBO)).getRespCode())) {
                this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, JSON.toJSONString((Object)feedbackAbilityReqBO), JSON.toJSONString((Object)rspBO), new Date(), rspBO.getRespDesc());
                throw new FscBusinessException("198888", rspBO.getRespDesc());
            }
            this.systemBusiLog(FscConstants.SystemLogFlag.SUCCESS, JSON.toJSONString((Object)feedbackAbilityReqBO), JSON.toJSONString((Object)rspBO), new Date(), null);
        }
        catch (Exception e) {
            this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, message.getContent(), null, new Date(), ExceptionUtil.stacktraceToString((Throwable)e));
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void systemBusiLog(Integer logFlag, String reqStr, String rspStr, Date createTime, String failureReason) {
        FscSystemBusiLogBusiServiceReqBo logBusiServiceReqBo = new FscSystemBusiLogBusiServiceReqBo();
        logBusiServiceReqBo.setSystemType(FscConstants.SystemType.INNER);
        logBusiServiceReqBo.setLogType(FscConstants.SystemLogType.FORWARD);
        logBusiServiceReqBo.setLogFlag(logFlag);
        logBusiServiceReqBo.setBusiType(FscConstants.SystemLogBusiType.UP_FEED_BACK_DOWN);
        logBusiServiceReqBo.setCallService("FscBillOrderFeedbackAbilityService");
        logBusiServiceReqBo.setSendService("FscBillSupCheckConfirmAbilityService");
        logBusiServiceReqBo.setReqParam(reqStr);
        logBusiServiceReqBo.setRspParam(rspStr);
        logBusiServiceReqBo.setCreateTime(createTime);
        logBusiServiceReqBo.setFailureReason(failureReason);
        this.fscSystemBusiLogBusiService.systemBusiLog(logBusiServiceReqBo);
    }
}

