/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.consumer;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.cfc.ability.api.CfcUniteParamQryListDetailAbilityService;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListDetailAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListDetailAbilityRspBO;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.bill.ability.api.FscBillOrderCreateAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillOrderSplitComputeAbilityService;
import com.tydic.fsc.bill.ability.api.FscOrderTotalSubmitCheckAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSplitComputeAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSplitComputeAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscOrderTotalSubmitAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscOrderTotalSubmitCheckAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.checkApplyWrap.FscCfcUniteParamQryListDetailRspBO;
import com.tydic.fsc.bill.ability.bo.checkApplyWrap.FscUocAcceptOrderInfoBO;
import com.tydic.fsc.bill.ability.bo.checkApplyWrap.FscUocQryAcceptOrderListReqBO;
import com.tydic.fsc.bill.ability.bo.checkApplyWrap.FscUocQryAcceptOrderListRspBO;
import com.tydic.fsc.bill.ability.bo.checkApplyWrap.PebExtOrderListQryForFscReqBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.atom.api.FscGeneralQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscGeneralQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscGeneralQueryAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCheckResultPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public class FscOrderTotalSubmitConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscOrderTotalSubmitConsumer.class);
    private static final Integer ALLOW_UP_NOT_SIGN_DOWN_LAUNCH = 1;
    public static final String OPERATE = "0";
    @Autowired
    private CfcUniteParamQryListDetailAbilityService cfcUniteParamQryListDetailAbilityService;
    @Autowired
    private FscGeneralQueryAtomService fscGeneralQueryAtomService;
    @Autowired
    private FscOrderTotalSubmitCheckAbilityService fscOrderTotalSubmitCheckAbilityService;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscBillOrderSplitComputeAbilityService fscBillOrderSplitComputeAbilityService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscBillOrderCreateAbilityService fscBillOrderCreateAbilityService;
    @Value(value="${qry.pageSize:1000}")
    private Integer pageSize;
    ValueFilter propertyFilter = (object, name, value) -> {
        if (value != null && value.getClass().equals(String.class) && "".equals(value)) {
            value = null;
        }
        return value;
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        FscOrderTotalSubmitAbilityReqBO reqBO = null;
        try {
            int total;
            reqBO = (FscOrderTotalSubmitAbilityReqBO)JSON.parseObject((String)message.getContent(), FscOrderTotalSubmitAbilityReqBO.class);
            FscBillOrderCreateAbilityReqBO createAbilityReqBO = reqBO.getCreateAbilityReqBO();
            log.info("\u7ed3\u7b97\u5355\u5168\u91cf\u63d0\u4ea4\u6d88\u8d39\u8005\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)reqBO));
            FscUocQryAcceptOrderListReqBO qryBO = this.convertData(reqBO.getQryForFscReqBO());
            log.info("\u7ed3\u7b97\u5355\u5168\u91cf\u63d0\u4ea4\u67e5\u8be2\u9a8c\u6536\u5355\u5165\u53c2\u4e3a: {}" + JSON.toJSONString((Object)qryBO));
            ArrayList<FscUocAcceptOrderInfoBO> acceptOrderInfoBOList = new ArrayList<FscUocAcceptOrderInfoBO>();
            Long operSn = Sequence.getInstance().nextId();
            int pageNo = 1;
            do {
                qryBO.setPageNo(Integer.valueOf(pageNo));
                qryBO.setPageSize(this.pageSize);
                FscUocQryAcceptOrderListRspBO qryInfoRsp = this.qry(qryBO);
                log.info("\u7ed3\u7b97\u5355\u5168\u91cf\u63d0\u4ea4\u67e5\u8be2\u9a8c\u6536\u5355\u51fa\u53c2\u4e3a: {}" + JSON.toJSONString((Object)qryInfoRsp));
                if (ObjectUtil.isNull((Object)qryInfoRsp) || CollectionUtil.isEmpty((Collection)qryInfoRsp.getRows())) {
                    ProxyConsumerStatus proxyConsumerStatus = ProxyConsumerStatus.CONSUME_SUCCESS;
                    return proxyConsumerStatus;
                }
                List fscUocAcceptOrderInfoBOS = qryInfoRsp.getRows();
                if (FscOrderSourceEnum.ELECTRIC_MARKET.getCode().toString().equals(createAbilityReqBO.getOrderSource())) {
                    this.dealCheck(createAbilityReqBO, operSn, fscUocAcceptOrderInfoBOS);
                }
                acceptOrderInfoBOList.addAll(fscUocAcceptOrderInfoBOS);
                total = qryInfoRsp.getTotal();
                log.info("\u7ed3\u7b97\u5355\u5168\u91cf\u63d0\u4ea4\u9a8c\u6536\u5355\u603b\u9875\u6570={}, \u5f53\u524d\u9875\u6570\u4e3a={}", (Object)total, (Object)pageNo);
            } while (total > 1 && ++pageNo <= total);
            List<SplitOrderBO> splitOrderBOList = this.dealSplit(operSn, createAbilityReqBO, acceptOrderInfoBOList);
            this.dealCreate(createAbilityReqBO, splitOrderBOList);
        }
        catch (Exception e) {
            log.info("\u7ed3\u7b97\u5355\u5168\u91cf\u63d0\u4ea4\u6d88\u8d39\u8005\u5904\u7406\u5931\u8d25: {}" + e.getMessage());
        }
        finally {
            this.cacheClient.delete(reqBO.getCreateAbilityReqBO().getPurchaserId().toString());
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
    }

    private void dealCheck(FscBillOrderCreateAbilityReqBO createAbilityReqBO, Long operSn, List<FscUocAcceptOrderInfoBO> fscUocAcceptOrderInfoBOS) {
        FscOrderTotalSubmitCheckAbilityReqBO fscOrderTotalSubmitCheckAbilityReqBO = new FscOrderTotalSubmitCheckAbilityReqBO();
        fscOrderTotalSubmitCheckAbilityReqBO.setOperSn(operSn);
        fscOrderTotalSubmitCheckAbilityReqBO.setMakeType(createAbilityReqBO.getMakeType());
        fscOrderTotalSubmitCheckAbilityReqBO.setOrderSource(createAbilityReqBO.getOrderSource());
        fscOrderTotalSubmitCheckAbilityReqBO.setPurchaserId(createAbilityReqBO.getPurchaserId());
        fscOrderTotalSubmitCheckAbilityReqBO.setReceiveType(createAbilityReqBO.getReceiveType());
        fscOrderTotalSubmitCheckAbilityReqBO.setRows(fscUocAcceptOrderInfoBOS);
        this.fscOrderTotalSubmitCheckAbilityService.dealFscOrderTotalSubmitCheck(fscOrderTotalSubmitCheckAbilityReqBO);
    }

    private void dealCreate(FscBillOrderCreateAbilityReqBO createAbilityReqBO, List<SplitOrderBO> splitOrderBOList) {
        createAbilityReqBO.setSplitOrderList(splitOrderBOList);
        log.info("\u5168\u91cf\u63d0\u4ea4\u7ed3\u7b97\u5355\u5165\u53c2\u4e3a: {}" + JSON.toJSONString((Object)createAbilityReqBO));
        this.fscBillOrderCreateAbilityService.dealCreate(createAbilityReqBO);
    }

    private List<SplitOrderBO> dealSplit(Long operSn, FscBillOrderCreateAbilityReqBO createAbilityReqBO, List<FscUocAcceptOrderInfoBO> acceptOrderInfoBOList) {
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.qrySplitParam();
        FscBillOrderSplitComputeAbilityReqBO splitComputeAbilityReqBO = (FscBillOrderSplitComputeAbilityReqBO)JUtil.js((Object)createAbilityReqBO, FscBillOrderSplitComputeAbilityReqBO.class);
        splitComputeAbilityReqBO.setOrderSource(Integer.valueOf(createAbilityReqBO.getOrderSource()));
        splitComputeAbilityReqBO.setRuleType(FscConstants.YesOrNoEnum.NO.getCode());
        splitComputeAbilityReqBO.setMaxCharge(new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getSettleMoneyMax()));
        splitComputeAbilityReqBO.setMaxOrderCount(Integer.valueOf(fscCfcUniteParamQryListDetailExternalRspBO.getOrderNumMax()));
        List<Object> splitAccepteOrderInfoList = new ArrayList();
        if (FscOrderSourceEnum.ELECTRIC_MARKET.getCode().toString().equals(createAbilityReqBO.getOrderSource())) {
            FscCheckResultPO fscCheckResultWhere = new FscCheckResultPO();
            fscCheckResultWhere.setOperSn(operSn);
            fscCheckResultWhere.setStatus(FscConstants.BillCheck.EQUALS);
            List fscCheckResultList = this.fscCheckResultMapper.getList(fscCheckResultWhere);
            Map acceptIdAndObjMap = acceptOrderInfoBOList.stream().collect(Collectors.toMap(FscUocAcceptOrderInfoBO::getAcceptOrderId, Function.identity(), (a, b) -> a));
            for (FscCheckResultPO fscCheckResultPO : fscCheckResultList) {
                FscUocAcceptOrderInfoBO fscUocAcceptOrderInfoBO = (FscUocAcceptOrderInfoBO)acceptIdAndObjMap.get(fscCheckResultPO.getAcceptOrderId());
                if (ObjectUtil.isNull((Object)fscUocAcceptOrderInfoBO)) {
                    throw new FscBusinessException("191136", "\u4e0d\u5b58\u5728\u8be5\u5bf9\u8d26\u4e00\u81f4\u7684\u9a8c\u6536\u5355\u4fe1\u606f, \u8be5\u9a8c\u6536\u5355\u4e3a: {}" + JSON.toJSONString((Object)fscCheckResultPO.getAcceptOrderId()));
                }
                splitAccepteOrderInfoList.add(fscUocAcceptOrderInfoBO);
            }
        } else {
            splitAccepteOrderInfoList = acceptOrderInfoBOList;
        }
        List relOrderBOList = splitAccepteOrderInfoList.stream().map(e -> {
            RelOrderBO relOrderBO = new RelOrderBO();
            relOrderBO.setAcceptOrderId(e.getAcceptOrderId());
            relOrderBO.setMyAmount(e.getInspTotalPurchaseFee());
            relOrderBO.setOrderId(e.getSaleOrderId());
            relOrderBO.setOtherNo(e.getSaleOrderNoExt());
            relOrderBO.setSaleAmount(e.getInspTotalSalefee());
            relOrderBO.setAmount(e.getInspTotalSalefee());
            relOrderBO.setInvoiceTittleStr(e.getBuyerName());
            relOrderBO.setSupId(Long.valueOf(e.getSupplierId()));
            relOrderBO.setSupName(e.getSupplierName());
            relOrderBO.setValue1(e.getExpand1());
            relOrderBO.setValue2(e.getExpand2());
            relOrderBO.setValue3(e.getExpand3());
            relOrderBO.setValue4(e.getExpand4());
            relOrderBO.setValue9(e.getExpand9());
            relOrderBO.setValue10(e.getExpand10());
            relOrderBO.setValue11(e.getExpand11());
            return relOrderBO;
        }).collect(Collectors.toList());
        splitComputeAbilityReqBO.setRelOrderList(relOrderBOList);
        log.info("\u7ed3\u7b97\u5355\u5168\u91cf\u63d0\u4ea4\u62c6\u5355\u5165\u53c2: " + JSON.toJSONString((Object)splitComputeAbilityReqBO));
        FscBillOrderSplitComputeAbilityRspBO splitComputeAbilityRspBO = this.fscBillOrderSplitComputeAbilityService.getSplitCompute(splitComputeAbilityReqBO);
        log.info("\u7ed3\u7b97\u5355\u5168\u91cf\u63d0\u4ea4\u62c6\u5355\u51fa\u53c2: " + JSON.toJSONString((Object)splitComputeAbilityRspBO));
        return splitComputeAbilityRspBO.getRows();
    }

    private FscCfcUniteParamQryListDetailExternalRspBO qrySplitParam() {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("order_split_conditon");
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        return fscCfcUniteParamQryListDetailExternalRspBO;
    }

    private FscUocQryAcceptOrderListReqBO convertData(PebExtOrderListQryForFscReqBO reqBO) {
        FscCfcUniteParamQryListDetailRspBO dycFscCfcUniteParamQryListDetailRspBO;
        FscUocQryAcceptOrderListReqBO uocInspectionDetailsListPageQueryReqBO = (FscUocQryAcceptOrderListReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO, (SerializeFilter)this.propertyFilter, (SerializerFeature[])new SerializerFeature[0]), FscUocQryAcceptOrderListReqBO.class);
        this.createBoundVerifyParam(uocInspectionDetailsListPageQueryReqBO, reqBO);
        if (null != reqBO.getInspSaleFeeBegin()) {
            uocInspectionDetailsListPageQueryReqBO.setTotalSaleFeeLongBegin(reqBO.getInspSaleFeeBegin().multiply(new BigDecimal(10000)));
        }
        if (null != reqBO.getInspSaleFeeEnd()) {
            uocInspectionDetailsListPageQueryReqBO.setTotalSaleFeeLongEnd(reqBO.getInspSaleFeeEnd().multiply(new BigDecimal(10000)));
        }
        uocInspectionDetailsListPageQueryReqBO.setSupNo(reqBO.getSupNo());
        uocInspectionDetailsListPageQueryReqBO.setSupName(reqBO.getSupNameWeb());
        uocInspectionDetailsListPageQueryReqBO.setCompanyId(reqBO.getCompanyIdWeb());
        uocInspectionDetailsListPageQueryReqBO.setSaleOrderNoExt(reqBO.getOutOrderNo());
        uocInspectionDetailsListPageQueryReqBO.setSaleOrderId(Convert.toStr((Object)reqBO.getSaleVoucherId()));
        uocInspectionDetailsListPageQueryReqBO.setSaleOrderNo(Optional.ofNullable(reqBO.getSaleOrderNo()).orElse(Optional.ofNullable(reqBO.getSaleVoucherNo()).orElse(reqBO.getPurchaseVoucherNo())));
        uocInspectionDetailsListPageQueryReqBO.setInspOrderId(reqBO.getInspectionVoucherId());
        uocInspectionDetailsListPageQueryReqBO.setInspOrderNo(reqBO.getInspectionVoucherCode());
        uocInspectionDetailsListPageQueryReqBO.setInspOrderIdList(reqBO.getInspectionVoucherIdList());
        uocInspectionDetailsListPageQueryReqBO.setInspOrderNoList(reqBO.getInspectionVoucherCodeList());
        uocInspectionDetailsListPageQueryReqBO.setOrderCreateUserType(Convert.toInt((Object)reqBO.getUserType()));
        uocInspectionDetailsListPageQueryReqBO.setOrderCreateOperName(reqBO.getPurPlaceOrderName());
        if (FscConstants.FscRelType.TRADE_INVOICE.equals(reqBO.getRelType())) {
            dycFscCfcUniteParamQryListDetailRspBO = this.queryConfig(reqBO, "individual_settle");
            if (!StringUtils.isBlank((CharSequence)dycFscCfcUniteParamQryListDetailRspBO.getAllowSettle())) {
                List<String> allowAssemble = this.isAllowAssemble(ALLOW_UP_NOT_SIGN_DOWN_LAUNCH.equals(Integer.parseInt(dycFscCfcUniteParamQryListDetailRspBO.getAllowSettle())));
                uocInspectionDetailsListPageQueryReqBO.setRelInfo(allowAssemble);
            } else {
                throw new ZTBusinessException("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3[allowSettle]\u8fd4\u56de\u4e3a\u7a7a");
            }
        }
        if (StringUtils.isBlank((CharSequence)(dycFscCfcUniteParamQryListDetailRspBO = this.queryConfig(reqBO, "bill_auth")).getSettleReq())) {
            throw new ZTBusinessException("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3[settleReq]\u8fd4\u56de\u4e3a\u7a7a");
        }
        if ("1".equals(reqBO.getIsProfessionalOrgExt()) && !OPERATE.equals(dycFscCfcUniteParamQryListDetailRspBO.getSettleReq())) {
            if (null == reqBO.getUserId()) {
                return null;
            }
            uocInspectionDetailsListPageQueryReqBO.setCreateOperId(reqBO.getUserId().toString());
        }
        if (null != reqBO.getRelState() && null != reqBO.getRelType()) {
            ArrayList<String> relInfo = new ArrayList<String>(1);
            relInfo.add(reqBO.getRelState() + "," + reqBO.getRelType());
            if (!CollectionUtils.isEmpty((Collection)uocInspectionDetailsListPageQueryReqBO.getRelInfo())) {
                uocInspectionDetailsListPageQueryReqBO.getRelInfo().addAll(relInfo);
            } else {
                uocInspectionDetailsListPageQueryReqBO.setRelInfo(relInfo);
            }
        }
        if (null != reqBO.getPurAccount() && !"".equals(reqBO.getPurAccount())) {
            uocInspectionDetailsListPageQueryReqBO.setPurAccountList(Collections.singletonList(reqBO.getPurAccount()));
        }
        return uocInspectionDetailsListPageQueryReqBO;
    }

    private void createBoundVerifyParam(FscUocQryAcceptOrderListReqBO uocInspectionDetailsListPageQueryReqBO, PebExtOrderListQryForFscReqBO reqBO) {
        if (OPERATE.equals(reqBO.getIsprofess())) {
            if (null != reqBO.getPayAccountDay()) {
                uocInspectionDetailsListPageQueryReqBO.setProPayAccountDay(reqBO.getPayAccountDay());
            }
            if (null != reqBO.getPayAccountDayRule()) {
                uocInspectionDetailsListPageQueryReqBO.setProPayAccountDayRule(reqBO.getPayAccountDayRule());
            }
            if (null != reqBO.getPayNodeAccountDay()) {
                uocInspectionDetailsListPageQueryReqBO.setProPaymentDays(reqBO.getPayNodeAccountDay());
            }
            if (null != reqBO.getPayNodeRule()) {
                uocInspectionDetailsListPageQueryReqBO.setProPayNodeRule(reqBO.getPayNodeRule());
            }
            if (null != reqBO.getPayRule()) {
                uocInspectionDetailsListPageQueryReqBO.setProPayRule(reqBO.getPayRule());
            }
        } else {
            if (null != reqBO.getPayAccountDay()) {
                uocInspectionDetailsListPageQueryReqBO.setPayAccountDay(reqBO.getPayAccountDay());
            }
            if (null != reqBO.getPayAccountDayRule()) {
                uocInspectionDetailsListPageQueryReqBO.setPayAccountDayRule(reqBO.getPayAccountDayRule());
            }
            if (null != reqBO.getPayNodeAccountDay()) {
                uocInspectionDetailsListPageQueryReqBO.setPaymentDays(reqBO.getPayNodeAccountDay());
            }
            if (null != reqBO.getPayNodeRule()) {
                uocInspectionDetailsListPageQueryReqBO.setPayNodeRule(reqBO.getPayNodeRule());
            }
            if (null != reqBO.getPayRule()) {
                uocInspectionDetailsListPageQueryReqBO.setPayRule(reqBO.getPayRule());
            }
        }
    }

    private FscCfcUniteParamQryListDetailRspBO queryConfig(PebExtOrderListQryForFscReqBO reqBO, String cfcParamCodes) {
        CfcUniteParamQryListDetailAbilityReqBO cfcUniteParamQryListDetailAbilityReqBO = new CfcUniteParamQryListDetailAbilityReqBO();
        cfcUniteParamQryListDetailAbilityReqBO.setParamCode(cfcParamCodes);
        cfcUniteParamQryListDetailAbilityReqBO.setRelId(String.valueOf(reqBO.getCompanyIdWeb()));
        cfcUniteParamQryListDetailAbilityReqBO.setCenter("FSC");
        CfcUniteParamQryListDetailAbilityRspBO cfcUniteParamQryListDetailAbilityRspBO = this.cfcUniteParamQryListDetailAbilityService.qryListDetail(cfcUniteParamQryListDetailAbilityReqBO);
        if (null == cfcUniteParamQryListDetailAbilityRspBO || null == cfcUniteParamQryListDetailAbilityRspBO.getJsonObject() || cfcUniteParamQryListDetailAbilityRspBO.getJsonObject().isEmpty()) {
            throw new ZTBusinessException("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u8fd4\u56de\u4e3a\u7a7a");
        }
        return (FscCfcUniteParamQryListDetailRspBO)JSON.parseObject((String)cfcUniteParamQryListDetailAbilityRspBO.getJsonObject().toJSONString(), FscCfcUniteParamQryListDetailRspBO.class);
    }

    private List<String> isAllowAssemble(boolean flag) {
        ArrayList<String> relInfos = new ArrayList<String>();
        if (!flag) {
            relInfos.add(FscConstants.FscRelStatus.SIGN + "," + FscConstants.FscRelType.PRO_INVOICE);
        }
        return relInfos;
    }

    private FscUocQryAcceptOrderListRspBO qry(FscUocQryAcceptOrderListReqBO qryInfo) {
        FscGeneralQueryAtomReqBO fscGeneralQueryAtomReqBO = new FscGeneralQueryAtomReqBO();
        fscGeneralQueryAtomReqBO.setQueryCountFlag(Boolean.valueOf(false));
        fscGeneralQueryAtomReqBO.setReqParams(JSON.toJSONString((Object)qryInfo));
        FscGeneralQueryAtomRspBO fscGeneralQueryAtomRspBO = this.fscGeneralQueryAtomService.generalQuery(fscGeneralQueryAtomReqBO);
        return (FscUocQryAcceptOrderListRspBO)JSON.parseObject((String)fscGeneralQueryAtomRspBO.getRspJsonStr(), FscUocQryAcceptOrderListRspBO.class);
    }
}

