/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.fsc.bill.ability.api.FscBillAutoSignAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillInvoiceUploadAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceSignAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillAutoSignAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceUploadAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceUploadAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillInvoiceUploadBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscInvoiceInfoBO;
import com.tydic.fsc.bo.InvoiceBO;
import com.tydic.fsc.bo.InvoiceItemBO;
import com.tydic.fsc.busibase.atom.api.FscInvoiceCheckAtomService;
import com.tydic.fsc.busibase.atom.bo.FscInvoiceCheckAtomServiceReqBo;
import com.tydic.fsc.busibase.atom.bo.FscInvoiceCheckAtomServiceRspBo;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.common.ability.api.FscBillMailSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComInvoiceDeleteSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscBillMailListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceDeleteSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceRuleMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceRulePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.fsc.util.InvoiceExcelUtilsNew;
import com.tydic.fsc.util.TrustAllTrustManager;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillInvoiceUploadAbilityService"})
public class FscBillInvoiceUploadAbilityServiceImpl
implements FscBillInvoiceUploadAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillInvoiceUploadAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscInvoiceRuleMapper fscInvoiceRuleMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscBillInvoiceUploadBusiService fscBillInvoiceUploadBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscComInvoiceDeleteSyncAbilityService fscComInvoiceDeleteSyncAbilityService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscBillOrderInvoiceSignAbilityService fscBillOrderInvoiceSignAbilityService;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscBillMailSyncAbilityService fscBillMailSyncAbilityService;
    @Autowired
    private FscBillAutoSignAbilityService fscBillAutoSignAbilityService;
    @Autowired
    private FscInvoiceCheckAtomService fscInvoiceCheckAtomService;
    private static final String BUSI_NAME = "\u4e3b\u5355\u53d1\u7968\u4e0a\u4f20";
    private static final String NOT_NEED_INVOICE_INFO = "0";
    private final String downloadFile = "/downloadFile/";
    @Autowired
    private FileClient fileClient;
    @Value(value="${fsc.getInvoiceData.isCheckInvoice:false}")
    private Boolean isCheckInvoice;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealInvoiceUpload"})
    public FscBillInvoiceUploadAbilityRspBO dealInvoiceUpload(@RequestBody FscBillInvoiceUploadAbilityReqBO reqBO) {
        this.val(reqBO);
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (null == fscOrderPo) {
            throw new FscBusinessException("191011", "\u7ed3\u7b97\u5355\u4e0d\u5b58\u5728");
        }
        FscInvoiceRulePO fscInvoiceRulePO = new FscInvoiceRulePO();
        fscInvoiceRulePO.setFscOrderId(reqBO.getOrderId());
        fscInvoiceRulePO = this.fscInvoiceRuleMapper.getModelBy(fscInvoiceRulePO);
        if (null == fscInvoiceRulePO) {
            throw new FscBusinessException("191011", "\u7ed3\u7b97\u5355\u53d1\u7968\u89c4\u5219\u67e5\u8be2\u4e3a\u7a7a");
        }
        if (FscConstants.FscInvoiceRuleElecFlag.YES.equals(fscInvoiceRulePO.getElecFlag()) && FscConstants.FscInvoiceRuleStatus.NO.equals(fscInvoiceRulePO.getElecStatus())) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getEInvoiceUrl())) {
                throw new FscBusinessException("191011", "\u8bf7\u4e0a\u4f20\u7535\u5b50\u53d1\u7968\u9644\u4ef6");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getEInvoiceName())) {
                throw new FscBusinessException("191011", "\u7535\u5b50\u53d1\u7968\u9644\u4ef6\u540d\u4e3a\u7a7a");
            }
        }
        if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(fscOrderPo.getMakeType())) {
            throw new FscBusinessException("191011", "\u65e0\u4e0a\u4f20\u53d1\u7968\u6743\u9650");
        }
        File file = this.getFileByUrl(reqBO.getDataFileUrl());
        if (null == file) {
            throw new FscBusinessException("191011", "\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
        }
        FscOrderInvoicePO fscOrderInvoicePO = new FscOrderInvoicePO();
        fscOrderInvoicePO.setFscOrderId(reqBO.getOrderId());
        fscOrderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePO);
        if (null == fscOrderInvoicePO) {
            throw new FscBusinessException("191011", "\u67e5\u8be2\u4e3b\u5355\u53d1\u7968\u4e3a\u7a7a");
        }
        List fscInvoiceInfoBOList = InvoiceExcelUtilsNew.dealExcel((File)file);
        for (FscInvoiceInfoBO fscInvoiceInfoBO : fscInvoiceInfoBOList) {
            if (null == fscInvoiceInfoBO) {
                throw new FscBusinessException("191011", "\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a");
            }
            if (this.isCheckInvoice.booleanValue()) {
                this.invoiceCheck(fscOrderInvoicePO, fscInvoiceInfoBO);
            }
            if (!this.isDateFormat(fscInvoiceInfoBO.getBillDate())) {
                throw new FscBusinessException("191011", "\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u6309\u7167\u6587\u6863\u63d0\u793a\u586b\u5199\uff01");
            }
            if (CollectionUtils.isEmpty((Collection)fscInvoiceInfoBO.getInvoiceItemBOS())) {
                throw new FscBusinessException("191011", "\u53d1\u7968\u660e\u7ec6\u4e3a\u7a7a");
            }
            if (!fscOrderPo.getOrderNo().equals(fscInvoiceInfoBO.getFscOrderNo())) {
                throw new FscBusinessException("191011", "Excel\u5185\u7ed3\u7b97\u5355\u53f7\u4e0e\u6240\u9009\u7ed3\u7b97\u5355\u53f7\u4e0d\u4e00\u81f4");
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getEInvoiceUrl())) {
                ArrayList attachmentBoList = new ArrayList();
                AttachmentBO attachmentBo = new AttachmentBO();
                attachmentBo.setAttachmentUrl(reqBO.getEInvoiceUrl());
                String end = reqBO.getEInvoiceUrl().substring(reqBO.getEInvoiceUrl().lastIndexOf("."));
                attachmentBo.setAttachmentName(reqBO.getOrderId().toString() + "\u53d1\u7968\u9644\u4ef6" + end);
                attachmentBoList.add(attachmentBo);
                fscInvoiceInfoBO.setAttachmentList((List)attachmentBoList);
            }
            fscInvoiceInfoBO.setFscOrderId(fscOrderPo.getFscOrderId());
            for (InvoiceItemBO invoiceItemBO2 : fscInvoiceInfoBO.getInvoiceItemBOS()) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)invoiceItemBO2.getIdentify()) || !invoiceItemBO2.getIdentify().contains("-")) {
                    throw new FscBusinessException("191000", "\u5546\u54c1\u884c\u53f7-\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                String[] itemNoArr = invoiceItemBO2.getIdentify().split("-");
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)itemNoArr[0])) {
                    throw new FscBusinessException("191000", "\u5546\u54c1\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                invoiceItemBO2.setOrderItemId(this.string2Long(itemNoArr[0]));
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)itemNoArr[1])) {
                    throw new FscBusinessException("191000", "\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                invoiceItemBO2.setFscOrderItemId(this.string2Long(itemNoArr[1]));
            }
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(reqBO.getOrderId());
            List fscOrderItemPOS = this.fscOrderItemMapper.getList(fscOrderItemPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderItemPOS)) {
                throw new FscBusinessException("191011", "\u67e5\u8be2\u4e3b\u5355\u660e\u7ec6\u4e3a\u7a7a");
            }
            Map<Long, FscOrderItemPO> fscOrderItemMap = fscOrderItemPOS.stream().collect(Collectors.toMap(FscOrderItemPO::getId, fscOrderItem -> fscOrderItem));
            fscInvoiceInfoBO.setInvoiceCategory(fscOrderInvoicePO.getInvoiceCategory());
            fscInvoiceInfoBO.setInvoiceType(fscOrderInvoicePO.getInvoiceType());
            if (!this.needInvoiceInfos(fscOrderPo)) {
                List invoiceItemBOList = JSON.parseArray((String)JSON.toJSONString((Object)fscOrderItemPOS), InvoiceItemBO.class);
                fscInvoiceInfoBO.setInvoiceItemBOS(invoiceItemBOList);
            }
            if (null == fscInvoiceInfoBO.getBillDate()) {
                fscInvoiceInfoBO.setBillDate(DateUtil.dateToStrYYYYMMdd((Date)new Date()));
            }
            fscInvoiceInfoBO.getInvoiceItemBOS().forEach(invoiceItemBO -> {
                invoiceItemBO.setFscOrderId(fscInvoiceInfoBO.getFscOrderId());
                FscOrderItemPO fscOrderItemGet = (FscOrderItemPO)fscOrderItemMap.get(invoiceItemBO.getFscOrderItemId());
                if (null != fscOrderItemGet) {
                    invoiceItemBO.setModel(fscOrderItemGet.getModel());
                    invoiceItemBO.setSpec(fscOrderItemGet.getSpec());
                    invoiceItemBO.setUnit(fscOrderItemGet.getUnit());
                    invoiceItemBO.setAcceptOrderId(fscOrderItemGet.getAcceptOrderId());
                    invoiceItemBO.setOrderId(fscOrderItemGet.getOrderId());
                    invoiceItemBO.setSkuId(fscOrderItemGet.getSkuId());
                }
            });
        }
        FscBillInvoiceUploadBusiReqBO fscBillInvoiceUploadBusiReqBO = (FscBillInvoiceUploadBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillInvoiceUploadBusiReqBO.class));
        fscBillInvoiceUploadBusiReqBO.setFscInvoiceInfoBOS(fscInvoiceInfoBOList);
        fscBillInvoiceUploadBusiReqBO.setFscOrderId(reqBO.getOrderId());
        fscBillInvoiceUploadBusiReqBO.setBusiName(BUSI_NAME);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("skigFlag", FscConstants.BillOrderSkigFlag.SUPPLIER_UPLOAD);
        fscBillInvoiceUploadBusiReqBO.setParamMap(paramMap);
        fscBillInvoiceUploadBusiReqBO.setCurStatus(fscOrderPo.getOrderState());
        FscBillInvoiceUploadBusiRspBO fscBillInvoiceUploadBusiRspBO = this.fscBillInvoiceUploadBusiService.dealInvoiceUpload(fscBillInvoiceUploadBusiReqBO);
        if (!"0000".equals(fscBillInvoiceUploadBusiRspBO.getRespCode())) {
            throw new FscBusinessException("191011", fscBillInvoiceUploadBusiRspBO.getRespDesc());
        }
        if (this.isAutoSign(reqBO, fscOrderPo)) {
            this.autoSign(reqBO);
        } else {
            this.sendMq(reqBO, fscOrderPo);
        }
        FscBillInvoiceUploadAbilityRspBO rspBO = new FscBillInvoiceUploadAbilityRspBO();
        return rspBO;
    }

    private void invoiceCheck(FscOrderInvoicePO fscOrderInvoicePO, FscInvoiceInfoBO fscInvoiceInfoBO) {
        FscInvoiceCheckAtomServiceReqBo fscInvoiceCheckAtomServiceReqBo = new FscInvoiceCheckAtomServiceReqBo();
        fscInvoiceCheckAtomServiceReqBo.setInvoiceType(fscOrderInvoicePO.getInvoiceType());
        fscInvoiceCheckAtomServiceReqBo.setInvoiceCategory(fscOrderInvoicePO.getInvoiceCategory());
        fscInvoiceCheckAtomServiceReqBo.setInvoiceBO((InvoiceBO)fscInvoiceInfoBO);
        FscInvoiceCheckAtomServiceRspBo fscInvoiceCheckAtomServiceRspBo = this.fscInvoiceCheckAtomService.checkInvoice(fscInvoiceCheckAtomServiceReqBo);
        if (!"0000".equals(fscInvoiceCheckAtomServiceRspBo.getRespCode())) {
            throw new FscBusinessException(fscInvoiceCheckAtomServiceRspBo.getRespCode(), fscInvoiceCheckAtomServiceRspBo.getRespDesc());
        }
    }

    private void autoSign(FscBillInvoiceUploadAbilityReqBO reqBO) {
        FscBillAutoSignAbilityReqBO fscBillAutoSignAbilityReqBO = new FscBillAutoSignAbilityReqBO();
        fscBillAutoSignAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        fscBillAutoSignAbilityReqBO.setUserId(reqBO.getUserId());
        fscBillAutoSignAbilityReqBO.setUserName(reqBO.getUserName());
        this.fscBillAutoSignAbilityService.dealAutoSign(fscBillAutoSignAbilityReqBO);
    }

    private boolean isAutoSign(FscBillInvoiceUploadAbilityReqBO reqBO, FscOrderPO fscOrderPo) {
        if (FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPo.getMakeType())) {
            FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
            fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("operinvoice_sign");
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPo.getReceiveType())) {
                fscCfcUniteParamQryListDetailExternalReqBO.setRelId(String.valueOf(fscOrderPo.getPurchaserId()));
            } else if (FscConstants.FscOrderReceiveType.SUPPLIER.equals(fscOrderPo.getReceiveType())) {
                fscCfcUniteParamQryListDetailExternalReqBO.setRelId(String.valueOf(fscOrderPo.getSupplierId()));
            }
            FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
            if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
                throw new FscBusinessException("191011", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
            }
            if (StringUtils.isBlank((String)fscCfcUniteParamQryListDetailExternalRspBO.getReqSign())) {
                throw new FscBusinessException("191011", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3[operinvoice_sign]\u8fd4\u56de[reqSign]\u4e3a\u7a7a");
            }
            return NOT_NEED_INVOICE_INFO.equals(fscCfcUniteParamQryListDetailExternalRspBO.getReqSign());
        }
        return false;
    }

    private boolean needInvoiceInfos(FscOrderPO fscOrderPo) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        String orderSource = fscOrderPo.getOrderSource().toString();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("invoice_upload_details_" + orderSource);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191011", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getReqDetailed())) {
            String reqDetailed = fscCfcUniteParamQryListDetailExternalRspBO.getReqDetailed();
            return !NOT_NEED_INVOICE_INFO.equals(reqDetailed);
        }
        return true;
    }

    private void writeFailLog(FscBillInvoiceUploadAbilityReqBO reqBO, String failDesc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(reqBO.getOrderId());
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(failDesc);
        fscOrderFailLogUpdateBusiReqBO.setBusiFailTime(new Date());
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_INVOICE_SIGN_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }

    private void val(FscBillInvoiceUploadAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getDataFileUrl())) {
            throw new FscBusinessException("191000", "\u8bf7\u4e0a\u4f20\u53d1\u7968\u7535\u5b50\u6570\u636e");
        }
    }

    private Long string2Long(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            throw new FscBusinessException("191011", "\u5546\u54c1\u660e\u7ec6ID\u8f6c\u6362\u5f02\u5e38");
        }
    }

    private void sendMq(FscBillInvoiceUploadAbilityReqBO reqBO, FscOrderPO fscOrderPo) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        fscComOrderListSyncAbilityReqBO.setCreateTime(new Date());
        fscComOrderListSyncAbilityReqBO.setSendService(this.getClass().getName());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscComInvoiceDeleteSyncAbilityReqBO fscComInvoiceDeleteSyncAbilityReqBO = new FscComInvoiceDeleteSyncAbilityReqBO();
        fscComInvoiceDeleteSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComInvoiceDeleteSyncAbilityService.deleteComInvoiceSyncEs(fscComInvoiceDeleteSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        fscComInvoiceListSyncAbilityReqBO.setCreateTime(new Date());
        fscComInvoiceListSyncAbilityReqBO.setSendService(this.getClass().getName());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        if (FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPo.getMakeType())) {
            FscBillMailListSyncAbilityReqBO fscBillMailListSyncAbilityReqBO = new FscBillMailListSyncAbilityReqBO();
            fscBillMailListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
            fscBillMailListSyncAbilityReqBO.setCreateTime(new Date());
            fscBillMailListSyncAbilityReqBO.setSendService(this.getClass().getName());
            this.fscBillMailSyncAbilityService.syncBillMail(fscBillMailListSyncAbilityReqBO);
        }
    }

    public boolean isDateFormat(String date) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)date)) {
            return false;
        }
        String regexp = "[0-9]{4}-[0-9]{2}-[0-9]{2}";
        return Pattern.compile(regexp).matcher(date).matches();
    }

    private File getFileByUrl(String fileUrl) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FilterOutputStream stream = null;
        InputStream inputStream = null;
        File file = null;
        try {
            if (fileUrl.startsWith("https")) {
                this.dealHttps();
            }
            log.info("\u8bf7\u6c42\u8bfb {}", (Object)fileUrl);
            String requestUri = null;
            requestUri = fileUrl.contains("/downloadFile/") ? fileUrl.substring(fileUrl.indexOf("/downloadFile/") + "/downloadFile/".length()) : fileUrl;
            String s = URLDecoder.decode(requestUri, "utf-8");
            log.info("\u66ff\u6362\u540e\u7684\u8def\u5f84 {} ", (Object)s);
            inputStream = this.fileClient.downLoadToInputStream(s);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            String suffix = fileUrl.substring(fileUrl.lastIndexOf("."));
            file = File.createTempFile("file", suffix);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            stream = new BufferedOutputStream(fileOutputStream);
            stream.write(outStream.toByteArray());
        }
        catch (Exception e) {
            log.error("url\u8f6c\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
            throw new FscBusinessException("198888", "url\u8f6c\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (stream != null) {
                    stream.close();
                }
                outStream.close();
            }
            catch (Exception exception) {}
        }
        return file;
    }

    private void dealHttps() throws NoSuchAlgorithmException, KeyManagementException {
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
        TrustManager[] trustAllCerts = new TrustManager[]{new TrustAllTrustManager()};
        SSLContext sc = SSLContext.getInstance("SSL");
        SSLSessionContext sslsc = sc.getServerSessionContext();
        sslsc.setSessionTimeout(0);
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
    }
}

