/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceSignAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceSignAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceSignAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceSignBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.bo.InvoiceCmpResultBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderInfoPushAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayBillCreateAuditAtomService;
import com.tydic.fsc.busibase.atom.api.FscQryOrderInfoPushAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderInfoPushAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscQryOrderInfoPushAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscQryOrderInfoPushAtomRspBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.common.ability.api.FscBillMailSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComInvoiceDeleteSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscBillMailListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceDeleteSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscInvoiceSignErrorMsgEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceSignAbilityService"})
public class FscBillOrderInvoiceSignAbilityServiceImpl
implements FscBillOrderInvoiceSignAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscBillOrderInvoiceSignBusiService fscBillOrderInvoiceSignBusiService;
    private static String SYS_LIMIT_SIGN_CMP_AMT = "3";
    private static BigDecimal TAX_AMOUNT_OTHER_CHECK = BigDecimal.ZERO;
    private static BigDecimal TOTAL_AMOUNT_EX_OTHER_CHECK = BigDecimal.ZERO;
    private static final String REPLACE_KEY = "#replace#";
    private static final String REPLACE_LIMIT_AMT = "##";
    private static final String ERROR_MSG_TITLE_BEGIN = "\u7ed3\u7b97\u5355";
    private static final String ERROR_MSG_TITLE_END = "\u4e0d\u7b26\u5408\u7b7e\u6536\u89c4\u5219\uff0c\u539f\u56e0\u5982\u4e0b\uff1a<br>";
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscComInvoiceDeleteSyncAbilityService fscComInvoiceDeleteSyncAbilityService;
    @Autowired
    private FscBillMailSyncAbilityService fscBillMailSyncAbilityService;
    @Autowired
    private FscPayBillCreateAuditAtomService fscPayBillCreateAuditAtomService;
    private static final Integer IN = 1;
    private static final Integer OUT = 2;
    @Value(value="${signStartAuditSwitch:false}")
    private Boolean signStartAuditSwitch;
    @Autowired
    private FscOrderInfoPushAtomService fscOrderInfoPushAtomService;
    @Autowired
    private FscQryOrderInfoPushAtomService fscQryOrderInfoPushAtomService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealOrderInvoiceSign"})
    public FscBillOrderInvoiceSignAbilityRspBO dealOrderInvoiceSign(@RequestBody FscBillOrderInvoiceSignAbilityReqBO reqBO) {
        FscBillOrderInvoiceSignBusiRspBO fscBillOrderInvoiceSignBusiRspBO;
        this.val(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u4e3b\u5355\u4e0d\u5b58\u5728");
        }
        if (!FscConstants.FscInvoiceOrderState.BILLED.equals(fscOrderPO.getOrderState())) {
            Map orderStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_LIST_STATE");
            throw new FscBusinessException("191019", "\u5f53\u524d\u72b6\u6001[" + (String)orderStateMap.get(Convert.toStr((Object)fscOrderPO.getOrderState())) + "]\u4e0d\u5141\u8bb8\u7b7e\u6536");
        }
        if (!"0".equals(reqBO.getAutoSignFlag()) && FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow())) {
            this.valCmpResult(reqBO);
            this.checkCmpResult(reqBO.getInvoiceCmpResult(), fscOrderPO);
        }
        FscBillOrderInvoiceSignBusiReqBO fscBillOrderInvoiceSignBusiReqBO = (FscBillOrderInvoiceSignBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillOrderInvoiceSignBusiReqBO.class));
        fscBillOrderInvoiceSignBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        if (FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow())) {
            this.dealOrderCheck(fscBillOrderInvoiceSignBusiReqBO, fscOrderPO, reqBO);
            this.dealStockFlag(fscBillOrderInvoiceSignBusiReqBO, fscOrderPO);
        }
        if (!"0000".equals((fscBillOrderInvoiceSignBusiRspBO = this.fscBillOrderInvoiceSignBusiService.dealOrderInvoiceSign(fscBillOrderInvoiceSignBusiReqBO)).getRespCode())) {
            throw new FscBusinessException("191019", fscBillOrderInvoiceSignBusiRspBO.getRespDesc());
        }
        this.sendMq(reqBO, fscOrderPO);
        if (this.signStartAuditSwitch.booleanValue()) {
            this.dealAudit(fscOrderPO);
        }
        return new FscBillOrderInvoiceSignAbilityRspBO();
    }

    private void dealAudit(FscOrderPO fscOrderPO) {
        FscOrderInfoPushAtomReqBO qryOrderInfoAtomReqBO = new FscOrderInfoPushAtomReqBO();
        qryOrderInfoAtomReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
        qryOrderInfoAtomReqBO.setSendService(this.getClass().getName());
        FscQryOrderInfoPushAtomReqBO qryOrderInfoPush = new FscQryOrderInfoPushAtomReqBO();
        qryOrderInfoPush.setFscOrderId(fscOrderPO.getFscOrderId());
        FscQryOrderInfoPushAtomRspBO fscQryOrderInfoPushAtomRspBO = this.fscQryOrderInfoPushAtomService.qryOrderInfoPush(qryOrderInfoPush);
        FscOrderInfoPushAtomReqBO fscOrderInfoPushAtomReqBO = (FscOrderInfoPushAtomReqBO)JUtil.js((Object)fscQryOrderInfoPushAtomRspBO, FscOrderInfoPushAtomReqBO.class);
        fscOrderInfoPushAtomReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
        fscOrderInfoPushAtomReqBO.setSendService(this.getClass().getName());
        this.fscOrderInfoPushAtomService.dealPushFscOrderInfo(fscOrderInfoPushAtomReqBO);
    }

    private void checkCmpResult(InvoiceCmpResultBO invoiceCmpResultBO, FscOrderPO fscOrderPO) {
        this.checkCfcParam(invoiceCmpResultBO, fscOrderPO.getOrderSource());
        if (invoiceCmpResultBO.getCmpResultStr().contains(FscConstants.FscInvoiceVerifyResult.NO.toString())) {
            StringBuffer errorMsg = new StringBuffer();
            int strLen = invoiceCmpResultBO.getCmpResultStr().length();
            int seq = 1;
            for (int i = 0; i < strLen; ++i) {
                if (invoiceCmpResultBO.getCmpResultStr().charAt(i) == FscConstants.FscInvoiceVerifyResult.NO.toString().charAt(0)) {
                    errorMsg.append(seq);
                    errorMsg.append(FscInvoiceSignErrorMsgEnum.getInstance((Integer)(i + 1)).getDescr());
                    ++seq;
                }
                if (i == 5) break;
            }
            if (invoiceCmpResultBO.getAmountMargin().compareTo(BigDecimal.ZERO) != 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getAmountMargin().toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getUntaxAmtMargin().compareTo(TOTAL_AMOUNT_EX_OTHER_CHECK) > 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.UNTAX_AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getUntaxAmtMargin().toString()).replace(REPLACE_LIMIT_AMT, TOTAL_AMOUNT_EX_OTHER_CHECK.toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getTaxMargin().compareTo(TAX_AMOUNT_OTHER_CHECK) > 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.TAX_AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getTaxMargin().toString()).replace(REPLACE_LIMIT_AMT, TAX_AMOUNT_OTHER_CHECK.toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getItemNumMargin().compareTo(BigDecimal.ZERO) != 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.ITEM.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getItemNumMargin().toString()));
                ++seq;
            }
            if (seq > 1) {
                throw new FscBusinessException("191035", errorMsg.toString());
            }
        }
    }

    private void val(FscBillOrderInvoiceSignAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2orderId\u4e3a\u7a7a");
        }
    }

    private void valCmpResult(FscBillOrderInvoiceSignAbilityReqBO reqBO) {
        if (null == reqBO.getInvoiceCmpResult()) {
            throw new FscBusinessException("191000", "\u5165\u53c2invoiceCmpResult\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCmpResult().getUntaxAmtMargin()) {
            throw new FscBusinessException("191000", "\u5165\u53c2untaxAmtMargin\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCmpResult().getTaxMargin()) {
            throw new FscBusinessException("191000", "\u5165\u53c2taxMargin\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCmpResult().getAmountMargin()) {
            throw new FscBusinessException("191000", "\u5165\u53c2amountMargin\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getInvoiceCmpResult().getCmpResultStr())) {
            throw new FscBusinessException("191000", "\u5165\u53c2cmpResultStr\u4e3a\u7a7a");
        }
    }

    private void sendMq(FscBillOrderInvoiceSignAbilityReqBO reqBO, FscOrderPO fscOrderPO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        fscComOrderListSyncAbilityReqBO.setCreateTime(new Date());
        fscComOrderListSyncAbilityReqBO.setSendService(this.getClass().getName());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscComInvoiceDeleteSyncAbilityReqBO fscComInvoiceDeleteSyncAbilityReqBO = new FscComInvoiceDeleteSyncAbilityReqBO();
        fscComInvoiceDeleteSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComInvoiceDeleteSyncAbilityService.deleteComInvoiceSyncEs(fscComInvoiceDeleteSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        fscComInvoiceListSyncAbilityReqBO.setCreateTime(new Date());
        fscComInvoiceListSyncAbilityReqBO.setSendService(this.getClass().getName());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        if (FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType())) {
            FscBillMailListSyncAbilityReqBO fscBillMailListSyncAbilityReqBO = new FscBillMailListSyncAbilityReqBO();
            fscBillMailListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
            fscBillMailListSyncAbilityReqBO.setCreateTime(new Date());
            fscBillMailListSyncAbilityReqBO.setSendService(this.getClass().getName());
            this.fscBillMailSyncAbilityService.syncBillMail(fscBillMailListSyncAbilityReqBO);
        }
    }

    private void dealAccountRule(FscBillOrderInvoiceSignBusiReqBO fscBillOrderInvoiceSignBusiReqBO, FscOrderPO fscOrderPO, FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO) {
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscOrderPO.getPayType())) {
            FscOrderInfoBO fscOrderInfoBO = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().values().stream().max(Comparator.comparing(FscOrderInfoBO::getOrderCreateTime)).get();
            if (null == fscOrderInfoBO) {
                throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
            }
            if (FscConstants.MerchantPayAccountDayRule.SIGN.equals(fscOrderInfoBO.getPayAccountDayRule()) || FscConstants.MerchantPayNodeRule.SIGN.equals(fscOrderInfoBO.getPayNodeRule())) {
                ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
                FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
                fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
                fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
                fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
                fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
                fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
                fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge());
                fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
                fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
                fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
                fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
                fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
                fscShouldPayBO.setContractId(fscOrderInfoBO.getModelContractId());
                fscShouldPayBO.setContractNo(fscOrderInfoBO.getModelContractNo());
                fscShouldPayBO.setShouldPayDate(this.calShouldPayDate(fscOrderInfoBO, fscOrderPO.getOrderSource()));
                fscShouldPayBOS.add(fscShouldPayBO);
                fscBillOrderInvoiceSignBusiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
                fscBillOrderInvoiceSignBusiReqBO.setCreateShouldPayFlag(true);
            }
        }
    }

    private Date calShouldPayDate(FscOrderInfoBO fscOrderInfoBO, Integer orderSource) {
        Calendar now = Calendar.getInstance();
        if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayAccountDay()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e3a\u7a7a");
            }
            Integer day = now.get(5);
            if (day >= fscOrderInfoBO.getPayAccountDay()) {
                now.add(2, 1);
            }
            now.add(5, fscOrderInfoBO.getPayAccountDay() - day);
        }
        if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayNodeAccountDays()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
            }
            now.add(5, fscOrderInfoBO.getPayNodeAccountDays());
        }
        return now.getTime();
    }

    private void checkCfcParam(InvoiceCmpResultBO invoiceCmpResultBO, Integer orderSource) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("invoice_check_" + orderSource);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191019", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        StringBuffer cmpResult = new StringBuffer(invoiceCmpResultBO.getCmpResultStr());
        char resultYesChar = FscConstants.FscInvoiceVerifyResult.YES.toString().charAt(0);
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getInvoiceTitleCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BUY_NAME.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxpayerIdCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.TAX_NO.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAddressCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ADDRESS.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getPhoneCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.PHONE.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getBankCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BANK.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAccountCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ACCOUNT.getCode() - 1, resultYesChar);
        }
        invoiceCmpResultBO.setCmpResultStr(cmpResult.toString());
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountCheck())) {
            invoiceCmpResultBO.setAmountMargin(BigDecimal.ZERO);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExCheck())) {
            invoiceCmpResultBO.setUntaxAmtMargin(BigDecimal.ZERO);
        } else if (!StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck())) {
            BigDecimal diffUntaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck());
            TOTAL_AMOUNT_EX_OTHER_CHECK = diffUntaxAmt.divide(BigDecimal.valueOf(100L), 2, 4);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountCheck())) {
            invoiceCmpResultBO.setTaxMargin(BigDecimal.ZERO);
        } else if (!StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck())) {
            BigDecimal diffTaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck());
            TAX_AMOUNT_OTHER_CHECK = diffTaxAmt.divide(BigDecimal.valueOf(100L), 2, 4);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getInvoiceDetailCheck())) {
            invoiceCmpResultBO.setItemNumMargin(BigDecimal.ZERO);
        }
    }

    private void dealStockFlag(FscBillOrderInvoiceSignBusiReqBO fscBillOrderInvoiceSignBusiReqBO, FscOrderPO fscOrderPO) {
        if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscOrderPO.getReceiveType())) {
            fscBillOrderInvoiceSignBusiReqBO.setNeedOperStockEnable(true);
            fscBillOrderInvoiceSignBusiReqBO.setStockFlag(IN);
        }
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType())) {
            fscBillOrderInvoiceSignBusiReqBO.setNeedOperStockEnable(true);
            fscBillOrderInvoiceSignBusiReqBO.setStockFlag(OUT);
        }
    }

    private void dealOrderCheck(FscBillOrderInvoiceSignBusiReqBO fscBillOrderInvoiceSignBusiReqBO, FscOrderPO fscOrderPO, FscBillOrderInvoiceSignAbilityReqBO reqBO) {
        FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
        fscAcceptOrderListQueryAtomReqBO.setRelId(Convert.toStr((Object)fscOrderPO.getFscOrderId()));
        fscAcceptOrderListQueryAtomReqBO.setReceiveType(fscOrderPO.getReceiveType());
        FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
        if (!"0000".equals(fscAcceptOrderListQueryAtomRspBO.getRespCode())) {
            throw new FscBusinessException("191019", fscAcceptOrderListQueryAtomRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Map)fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
            throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
        }
        this.dealAccountRule(fscBillOrderInvoiceSignBusiReqBO, fscOrderPO, fscAcceptOrderListQueryAtomRspBO);
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType())) {
            this.checkProSign(fscAcceptOrderListQueryAtomRspBO, reqBO);
        }
    }

    private void checkProSign(FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO, FscBillOrderInvoiceSignAbilityReqBO reqBO) {
        fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().forEach((acceptOrderId, fscOrderInfoBO) -> fscOrderInfoBO.getFscRelInfoBos().forEach(fscProFscRelInfoBo -> {
            if (FscConstants.FscRelType.PRO_INVOICE.equals(fscProFscRelInfoBo.getRelType()) && !FscConstants.FscRelStatus.SIGN.equals(fscProFscRelInfoBo.getRelState())) {
                throw new FscBusinessException("191019", "\u4e0a\u6e38\u7ed3\u7b97\u5355\u53d1\u7968\u672a\u7b7e\u6536\uff0c\u4e0b\u6e38\u4e0d\u5141\u8bb8\u7b7e\u6536");
            }
        }));
    }
}

