/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.convert.Convert;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillOrderSplitComputeAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSplitComputeAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSplitComputeAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderSplitComputeBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSplitComputeBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSplitComputeBusiRspBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.FscOrderSplitUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderSplitComputeAbilityService"})
public class FscBillOrderSplitComputeAbilityServiceImpl
implements FscBillOrderSplitComputeAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderSplitComputeAbilityServiceImpl.class);
    @Autowired
    private FscBillOrderSplitComputeBusiService fscBillOrderSplitComputeBusiService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscOrderSplitUtil fscOrderSplitUtil;
    @Value(value="#{'${create.fsc.order.split.default.param:supId,invoiceTittleStr,value3,value6}'.split(',')}")
    private List<String> defaultSplitParams;
    @Value(value="#{'${create.fsc.order.split.agr.param:supId,invoiceTittleStr,value3,value6,expand5}'.split(',')}")
    private List<String> agrSplitParams;
    @Value(value="#{'${create.fsc.order.split.notAgr.param:supId}'.split(',')}")
    private List<String> notAgrSplitParams;
    @Value(value="#{'${create.fsc.order.split.ecom.param:supId,invoiceTittleStr,value3,value6}'.split(',')}")
    private List<String> ecomSplitParams;
    @Value(value="${create.fsc.order.split.enable:true}")
    private Boolean splitEnable;
    private static final Integer GROUPWAY_ORDER = 2;

    @PostMapping(value={"getSplitCompute"})
    public FscBillOrderSplitComputeAbilityRspBO getSplitCompute(@RequestBody FscBillOrderSplitComputeAbilityReqBO reqBO) {
        this.verification(reqBO);
        List<List<RelOrderBO>> splitRelOrderList = this.baseSplit(reqBO);
        ArrayList<SplitOrderBO> rows = new ArrayList<SplitOrderBO>();
        for (List<RelOrderBO> relOrderBOS : splitRelOrderList) {
            FscBillOrderSplitComputeBusiReqBO busiReqBO = new FscBillOrderSplitComputeBusiReqBO();
            busiReqBO.setMaxCharge(reqBO.getMaxCharge());
            busiReqBO.setMaxOrderCount(reqBO.getMaxOrderCount());
            busiReqBO.setRuleType(reqBO.getRuleType());
            busiReqBO.setRelOrderList(relOrderBOS);
            FscBillOrderSplitComputeBusiRspBO busiRspBO = this.fscBillOrderSplitComputeBusiService.getSplitCompute(busiReqBO);
            if (!"0000".equals(busiRspBO.getRespCode())) {
                throw new FscBusinessException("191020", busiRspBO.getRespDesc());
            }
            rows.addAll(busiRspBO.getRows());
        }
        FscBillOrderSplitComputeAbilityRspBO rspBO = new FscBillOrderSplitComputeAbilityRspBO();
        rows.forEach(e -> e.setSerialNumber(Long.valueOf(Sequence.getInstance().nextId())));
        rspBO.setRows(rows);
        return rspBO;
    }

    private List<List<RelOrderBO>> baseSplit(FscBillOrderSplitComputeAbilityReqBO reqBO) {
        List splitRelOrderList = !GROUPWAY_ORDER.equals(reqBO.getRuleType()) ? ("2".equals(Convert.toStr((Object)reqBO.getOrderSource())) ? this.fscOrderSplitUtil.splitListByFields(reqBO.getRelOrderList(), this.ecomSplitParams, this.splitEnable.booleanValue()) : ("3".equals(Convert.toStr((Object)reqBO.getOrderSource())) ? this.fscOrderSplitUtil.splitListByFields(reqBO.getRelOrderList(), this.agrSplitParams, this.splitEnable.booleanValue()) : ("1".equals(Convert.toStr((Object)reqBO.getOrderSource())) ? this.fscOrderSplitUtil.splitListByFields(reqBO.getRelOrderList(), this.notAgrSplitParams, this.splitEnable.booleanValue()) : this.fscOrderSplitUtil.splitListByFields(reqBO.getRelOrderList(), this.defaultSplitParams, this.splitEnable.booleanValue())))) : Collections.singletonList(reqBO.getRelOrderList());
        return splitRelOrderList;
    }

    private void verification(FscBillOrderSplitComputeAbilityReqBO reqBO) {
        if (null == reqBO.getRuleType()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[ruleType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getMaxCharge()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[maxCharge]\u4e3a\u7a7a");
        }
        if (null == reqBO.getMaxOrderCount()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[maxOrderCount]\u4e3a\u7a7a");
        }
        if (null == reqBO.getRelOrderList() || reqBO.getRelOrderList().size() == 0) {
            throw new FscBusinessException("191000", "\u5165\u53c2[relOrderList]\u4e3a\u7a7a");
        }
    }

    private void paramCheck(BigDecimal maxCharge, Integer maxOrderCount) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("order_split_conditon");
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191020", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        if (!StringUtils.isBlank((String)fscCfcUniteParamQryListDetailExternalRspBO.getSettleMoneyMax())) {
            if (maxCharge.compareTo(new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getSettleMoneyMax())) > 0) {
                throw new FscBusinessException("191020", "\u62c6\u5206\u6700\u5927\u91d1\u989d\u9650\u5236\u4e0d\u80fd\u8d85\u8fc7[" + fscCfcUniteParamQryListDetailExternalRspBO.getSettleMoneyMax() + "]");
            }
        } else {
            throw new FscBusinessException("191020", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3[settleMoneyMax]\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (!StringUtils.isBlank((String)fscCfcUniteParamQryListDetailExternalRspBO.getOrderNumMax())) {
            if (maxOrderCount.compareTo(Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getOrderNumMax())) > 0) {
                throw new FscBusinessException("191020", "\u62c6\u5206\u6700\u5927\u8ba2\u5355\u6570\u4e0d\u80fd\u8d85\u8fc7[" + fscCfcUniteParamQryListDetailExternalRspBO.getOrderNumMax() + "]");
            }
        } else {
            throw new FscBusinessException("191020", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3[orderNumMax]\u8fd4\u56de\u4e3a\u7a7a");
        }
    }
}

