/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.FscBillEcomCheckAbilityService;
import com.tydic.fsc.bill.ability.api.FscOrderTotalSubmitCheckAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillEcomCheckAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscOrderTotalSubmitCheckAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscOrderTotalSubmitCheckAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.checkApplyWrap.FscUocAcceptOrderInfoBO;
import com.tydic.fsc.bill.busi.api.FscBillEcomCheckApplyBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckApplyBusiRspBO;
import com.tydic.fsc.bo.RelOrderBO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscOrderTotalSubmitCheckAbilityService"})
public class FscOrderTotalSubmitCheckAbilityServiceImpl
implements FscOrderTotalSubmitCheckAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderTotalSubmitCheckAbilityServiceImpl.class);
    @Autowired
    private FscBillEcomCheckAbilityService fscBillEcomCheckAbilityService;
    @Autowired
    private FscBillEcomCheckApplyBusiService fscBillEcomCheckApplyBusiService;

    @PostMapping(value={"dealFscOrderTotalSubmitCheck"})
    public FscOrderTotalSubmitCheckAbilityRspBO dealFscOrderTotalSubmitCheck(@RequestBody FscOrderTotalSubmitCheckAbilityReqBO reqBO) {
        this.dealCheck(reqBO);
        FscOrderTotalSubmitCheckAbilityRspBO rspBO = new FscOrderTotalSubmitCheckAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealCheck(FscOrderTotalSubmitCheckAbilityReqBO reqBO) {
        List rows = reqBO.getRows();
        Map<String, List<FscUocAcceptOrderInfoBO>> supIdSelfMap = rows.stream().collect(Collectors.groupingBy(FscUocAcceptOrderInfoBO::getSupplierId));
        for (Map.Entry<String, List<FscUocAcceptOrderInfoBO>> entry : supIdSelfMap.entrySet()) {
            FscBillEcomCheckApplyBusiReqBO applyBusiReqBO = new FscBillEcomCheckApplyBusiReqBO();
            applyBusiReqBO.setOperSn(reqBO.getOperSn());
            applyBusiReqBO.setSupplierId(Convert.toLong((Object)entry.getKey()));
            List<FscUocAcceptOrderInfoBO> fscUocAcceptOrderInfoBOS = entry.getValue();
            List<RelOrderBO> relOrderBOList = fscUocAcceptOrderInfoBOS.stream().map(order -> {
                RelOrderBO relOrderBO = new RelOrderBO();
                relOrderBO.setAcceptOrderId(order.getAcceptOrderId());
                relOrderBO.setMyAmount(order.getInspTotalPurchaseFee());
                relOrderBO.setOrderId(order.getSaleOrderId());
                relOrderBO.setOtherNo(order.getSaleOrderNoExt());
                relOrderBO.setSaleAmount(order.getInspTotalSalefee());
                return relOrderBO;
            }).collect(Collectors.toList());
            applyBusiReqBO.setRelOrderList(relOrderBOList);
            log.info("\u7ed3\u7b97\u5355\u5168\u91cf\u63d0\u4ea4\u5bf9\u8d26\u7533\u8bf7\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)((Object)applyBusiReqBO)));
            FscBillEcomCheckApplyBusiRspBO applyBusiRspBO = this.fscBillEcomCheckApplyBusiService.dealEcomCheckApply(applyBusiReqBO);
            if (!"0000".equals(applyBusiRspBO.getRespCode())) {
                log.error("\u7ed3\u7b97\u5355\u5168\u91cf\u63d0\u4ea4\u5bf9\u8d26\u7533\u8bf7\u51fa\u9519\uff1a{}", (Object)JSON.toJSONString((Object)((Object)applyBusiRspBO)));
                continue;
            }
            if (CollectionUtils.isEmpty(applyBusiRspBO.getSendMqOrderIds())) continue;
            FscBillEcomCheckAbilityReqBO checkAbilityReqBO = new FscBillEcomCheckAbilityReqBO();
            checkAbilityReqBO.setRelOrderList(relOrderBOList);
            log.info("\u7ed3\u7b97\u5355\u5168\u91cf\u63d0\u4ea4\u5bf9\u8d26\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)checkAbilityReqBO));
            FscBillEcomCheckAbilityRspBO checkAbilityRspBO = this.fscBillEcomCheckAbilityService.dealEcomCheck(checkAbilityReqBO);
            if ("0000".equals(checkAbilityRspBO.getRespCode())) continue;
            log.error("\u7ed3\u7b97\u5355\u5168\u91cf\u63d0\u4ea4\u5bf9\u8d26\u7533\u8bf7\u51fa\u9519\uff1a{}", (Object)JSON.toJSONString((Object)checkAbilityRspBO));
        }
    }
}

