/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.commodity.base.constant.PesappCommonConstant;
import com.tydic.fsc.bill.atom.api.FscFileUploadOSSByUrlAtomService;
import com.tydic.fsc.bill.atom.bo.FscFileUploadOSSByUrlAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscFileUploadOSSByUrlAtomRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscFileUploadOSSByUrlAtomServiceImpl
implements FscFileUploadOSSByUrlAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscFileUploadOSSByUrlAtomServiceImpl.class);
    private static final String PATH = "dyc-common/";
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    private final String downloadFile = "/downloadFile/";

    @Override
    public FscFileUploadOSSByUrlAtomRspBO uploadFileByBrl(FscFileUploadOSSByUrlAtomReqBO reqBO) {
        FscFileUploadOSSByUrlAtomRspBO rspBO = new FscFileUploadOSSByUrlAtomRspBO();
        try {
            File fileByUrl = this.getPDFFileByUrl(reqBO.getOldUrl());
            String fileName = fileByUrl.getName();
            FileInputStream fileInputStream = new FileInputStream(fileByUrl);
            String fileDir = UUID.randomUUID().toString().replaceAll("-", "");
            String path = this.fileClient.uploadFileByInputStream(PATH + fileDir, fileName, (InputStream)fileInputStream);
            String fileUrl = null;
            String innerFileUrl = null;
            if (PesappCommonConstant.FileService.FILE_TYPE_OSS.equals(this.fileType)) {
                innerFileUrl = this.accessUrl + path;
                fileUrl = this.ossFileUrl + path;
            } else if (PesappCommonConstant.FileService.FILE_TYPE_FASTDFS.equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            rspBO.setFileUrl(fileUrl);
            rspBO.setInnerFileUrl(innerFileUrl);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new FscBusinessException("198888", "\u4e0a\u4f20\u6587\u4ef6\u670d\u52a1\u5668\u5f02\u5e38");
        }
        return rspBO;
    }

    private File getPDFFileByUrl(String fileUrl) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        FilterOutputStream stream = null;
        InputStream inputStream = null;
        File file = null;
        try {
            log.info("\u8bf7\u6c42\u8bfb {}", (Object)fileUrl);
            String requestUri = null;
            requestUri = fileUrl.contains("/downloadFile/") ? fileUrl.substring(fileUrl.indexOf("/downloadFile/") + "/downloadFile/".length()) : fileUrl;
            String s = URLDecoder.decode(requestUri, "utf-8");
            log.info("\u66ff\u6362\u540e\u7684\u8def\u5f84 {} ", (Object)s);
            inputStream = this.fileClient.downLoadToInputStream(s);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            file = File.createTempFile("file", ".pdf");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            stream = new BufferedOutputStream(fileOutputStream);
            stream.write(outStream.toByteArray());
        }
        catch (Exception e) {
            log.error("url\u8f6c\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
            throw new FscBusinessException("198888", "url\u8f6c\u6587\u4ef6\u5931\u8d25");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (stream != null) {
                    stream.close();
                }
                outStream.close();
            }
            catch (Exception exception) {}
        }
        return file;
    }
}

