/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscBillChangeInfoBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillChangeInfoBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillChangeInfoBusiRspBO;
import com.tydic.fsc.bo.FscOrderItemBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderSyncCheckStatusReqBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocOrderSyncCheckStatusAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultItemMapper;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCheckResultItemPO;
import com.tydic.fsc.po.FscCheckResultPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.TaxUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscBillChangeInfoBusiServiceImpl
implements FscBillChangeInfoBusiService {
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscCheckResultItemMapper fscCheckResultItemMapper;
    @Value(value="#{'${dealBillChangeInfo.changeableStatus:1004,1015}'.split(',')}")
    private List<Integer> changeableStatus;
    @Autowired
    private FscUocOrderSyncCheckStatusAbilityService fscUocOrderSyncCheckStatusAbilityService;

    @Override
    public FscBillChangeInfoBusiRspBO dealBillChangeInfo(FscBillChangeInfoBusiReqBO reqBO) {
        FscBillChangeInfoBusiRspBO rspBO = new FscBillChangeInfoBusiRspBO();
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setAcceptOrderId(reqBO.getAcceptOrderId());
        List fscOrderItemPOs = this.fscOrderItemMapper.getListFscOrder(fscOrderItemPO);
        if (CollectionUtils.isNotEmpty((Collection)fscOrderItemPOs)) {
            Long fscOrderId = ((FscOrderItemPO)fscOrderItemPOs.get(0)).getFscOrderId();
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(fscOrderId);
            fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
            if (null != fscOrderPO) {
                if (!this.changeableStatus.contains(fscOrderPO.getOrderState())) {
                    throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u7ed3\u7b97\u72b6\u6001\u5df2\u4e0d\u53ef\u53d1\u8d77\u5f02\u5e38\u53d8\u66f4");
                }
                rspBO.setFscOrderId(fscOrderPO.getFscOrderId());
                this.updateFscOrderItem(fscOrderPO, reqBO, fscOrderItemPOs);
                this.updateFscOrderAmt(fscOrderPO, reqBO, fscOrderItemPOs);
                this.updateFscOrderCheckResult(reqBO);
            }
        }
        return rspBO;
    }

    private void updateFscOrderCheckResult(FscBillChangeInfoBusiReqBO reqBO) {
        FscCheckResultPO fscCheckResultPO = new FscCheckResultPO();
        fscCheckResultPO.setAcceptOrderId(reqBO.getAcceptOrderId());
        fscCheckResultPO = this.fscCheckResultMapper.getModelBy(fscCheckResultPO);
        if (null != fscCheckResultPO) {
            fscCheckResultPO.setAmount(reqBO.getSaleAmount());
            fscCheckResultPO.setSaleAmount(reqBO.getSaleAmount());
            fscCheckResultPO.setStatus(fscCheckResultPO.getOtherAmount().compareTo(fscCheckResultPO.getSaleAmount()) == 0 ? FscConstants.BillCheck.EQUALS : FscConstants.BillCheck.NOT_EQUALS);
            this.fscCheckResultMapper.updateById(fscCheckResultPO);
            for (FscOrderItemBO fscOrderItemBO : reqBO.getFscOrderItemBOList()) {
                FscCheckResultItemPO where = new FscCheckResultItemPO();
                where.setAcceptOrderItemId(fscOrderItemBO.getOrderItemId());
                where.setAcceptOrderId(reqBO.getAcceptOrderId());
                FscCheckResultItemPO set = new FscCheckResultItemPO();
                set.setAmount(fscOrderItemBO.getAmt());
                set.setPrice(fscOrderItemBO.getPrice());
                set.setNum(fscOrderItemBO.getNum());
                this.fscCheckResultItemMapper.updateBy(set, where);
            }
            FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO = new FscUocOrderSyncCheckStatusReqBO();
            uocOrderSyncCheckStatusReqBO.setInspectionVoucherId(reqBO.getAcceptOrderId());
            uocOrderSyncCheckStatusReqBO.setOrderId(reqBO.getOrderId());
            uocOrderSyncCheckStatusReqBO.setCheckState(fscCheckResultPO.getStatus());
            this.fscUocOrderSyncCheckStatusAbilityService.dealSyncCheckStatus(uocOrderSyncCheckStatusReqBO);
        }
    }

    private void updateFscOrderItem(FscOrderPO fscOrderPO, FscBillChangeInfoBusiReqBO reqBO, List<FscOrderItemPO> fscOrderItemPOs) {
        Map orderItemMap = fscOrderItemPOs.stream().collect(Collectors.toMap(FscOrderItemPO::getOrderItemId, Function.identity()));
        for (FscOrderItemBO fscOrderItemBO : reqBO.getFscOrderItemBOList()) {
            FscOrderItemPO where = new FscOrderItemPO();
            where.setFscOrderId(fscOrderPO.getFscOrderId());
            where.setAcceptOrderId(reqBO.getAcceptOrderId());
            where.setOrderItemId(fscOrderItemBO.getOrderItemId());
            FscOrderItemPO set = new FscOrderItemPO();
            set.setAmt(fscOrderItemBO.getAmt());
            set.setPrice(fscOrderItemBO.getPrice());
            set.setNum(fscOrderItemBO.getNum());
            set.setTaxRate(fscOrderItemBO.getTaxRate() == null ? ((FscOrderItemPO)orderItemMap.get(fscOrderItemBO.getOrderItemId())).getTaxRate() : fscOrderItemBO.getTaxRate());
            set.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getAmt(), (BigDecimal)set.getTaxRate()));
            set.setUntaxAmt(set.getAmt().subtract(set.getTaxAmt()));
            this.fscOrderItemMapper.updateBy(set, where);
        }
    }

    private void updateFscOrderAmt(FscOrderPO fscOrderPO, FscBillChangeInfoBusiReqBO reqBO, List<FscOrderItemPO> oldFscOrderItemPOs) {
        BigDecimal oldInspSaleTotal = oldFscOrderItemPOs.stream().map(FscOrderItemPO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        FscOrderPO where = new FscOrderPO();
        where.setFscOrderId(fscOrderPO.getFscOrderId());
        FscOrderPO set = new FscOrderPO();
        set.setTotalCharge(fscOrderPO.getTotalCharge().subtract(oldInspSaleTotal).add(reqBO.getSaleAmount()));
        this.fscOrderMapper.updateBy(set, where);
    }

    private void updateOrderItem(FscBillChangeInfoBusiReqBO reqBO) {
        List<FscOrderItemBO> fscOrderItemBOList = reqBO.getFscOrderItemBOList();
        fscOrderItemBOList.forEach(e -> {
            FscOrderItemPO set = new FscOrderItemPO();
            set.setAmt(e.getAmt());
            set.setUntaxAmt(e.getUntaxAmt());
            set.setNum(e.getNum());
            FscOrderItemPO where = new FscOrderItemPO();
            where.setAcceptOrderId(reqBO.getAcceptOrderId());
            where.setOrderItemId(e.getOrderItemId());
            this.fscOrderItemMapper.updateBy(set, where);
        });
    }
}

