/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscBillSupCheckConfirmBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillSupCheckConfirmBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillSupCheckConfirmBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCheckResultPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillSupCheckConfirmBusiServiceImpl
implements FscBillSupCheckConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSupCheckConfirmBusiServiceImpl.class);
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    public static final String BUSI_NAME = "\u5bf9\u8d26\u5f85\u786e\u8ba4";
    public static final String BUSI_CODE = "1015";

    @Override
    public FscBillSupCheckConfirmBusiRspBO dealSupCheckConfirm(FscBillSupCheckConfirmBusiReqBO reqBO) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (!FscBillStatus.RECONCILIATION_TO_BE_CONFIRMED.getCode().equals(fscOrder.getOrderState()) && !FscBillStatus.REJECT.getCode().equals(fscOrder.getOrderState())) {
            throw new FscBusinessException("193012", fscOrder.getOrderNo() + " \u72b6\u6001\u4e0d\u4e3a\u5bf9\u8d26\u5f85\u786e\u8ba4");
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderId(reqBO.getOrderId());
        List orderRelationPos = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        if (CollectionUtils.isEmpty((Collection)orderRelationPos)) {
            throw new FscBusinessException("193012", fscOrderRelationPo.getOrderId() + ":\u672a\u67e5\u8be2\u5230\u5bf9\u8d26\u6570\u636e");
        }
        List<Long> accepteOrderIdList = orderRelationPos.stream().map(FscOrderRelationPO::getAcceptOrderId).collect(Collectors.toList());
        List fscCheckResultPos = this.fscCheckResultMapper.selectByAcceptOrderIds(accepteOrderIdList);
        if (CollectionUtils.isEmpty((Collection)fscCheckResultPos)) {
            throw new FscBusinessException("193012", "\u672a\u67e5\u8be2\u5230\u5bf9\u8d26\u7ed3\u679c\u6570\u636e, \u8bf7\u786e\u8ba4\u4f9b\u5e94\u5546\u662f\u5426\u5df2\u5bfc\u5165");
        }
        if (FscConstants.ReconciliationCheckFlag.CONFIRM.equals(reqBO.getResult())) {
            boolean allMatch = fscCheckResultPos.stream().allMatch(fscCheckResultPo -> FscConstants.BillCheck.EQUALS.equals(fscCheckResultPo.getStatus()) || FscConstants.BillCheck.CONFIRMED.equals(fscCheckResultPo.getStatus()));
            if (!allMatch) {
                throw new FscBusinessException("193012", "\u7ed3\u7b97\u5355[" + reqBO.getOrderId() + "]\u5bf9\u8d26\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u5bf9\u8d26");
            }
            List acceptOrderIds = fscCheckResultPos.stream().map(FscCheckResultPO::getAcceptOrderId).collect(Collectors.toList());
            int updated = this.fscCheckResultMapper.updateStatusByAcceptOrderIds(acceptOrderIds, FscConstants.BillCheck.CONFIRMED);
            if (updated < 1) {
                throw new FscBusinessException("193012", "\u66f4\u65b0\u6570\u636e\u5e93\u9519\u8bef");
            }
        }
        this.flowAtom(reqBO);
        FscBillSupCheckConfirmBusiRspBO busiRspBO = new FscBillSupCheckConfirmBusiRspBO();
        busiRspBO.setFscOrderPO(fscOrder);
        busiRspBO.setAccepteOrderIdList(accepteOrderIdList);
        return busiRspBO;
    }

    private void flowAtom(FscBillSupCheckConfirmBusiReqBO reqBO) {
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(reqBO.getOrderId());
        flowAtomReqBO.setCurStatus(FscBillStatus.RECONCILIATION_TO_BE_CONFIRMED.getCode());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setBusiCode(BUSI_CODE);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        if (FscConstants.ReconciliationCheckFlag.RE_CHECK.equals(reqBO.getResult())) {
            paramMap.put("redoFlag", FscConstants.BillOrderRedoFlag.RE_DO);
        } else {
            paramMap.put("redoFlag", FscConstants.BillOrderRedoFlag.CONFIRM);
        }
        flowAtomReqBO.setParamMap(paramMap);
        flowAtomReqBO.setUserId(reqBO.getUserId());
        flowAtomReqBO.setUserName(reqBO.getUserName());
        FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
        if (!"0000".equals(flowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193012", flowAtomRspBO.getRespDesc());
        }
    }
}

