/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.util.StringUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.bill.busi.api.FscBillSupplierCheckBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillSupplierCheckBusiOrderItemBO;
import com.tydic.fsc.bill.busi.bo.FscBillSupplierCheckBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillSupplierCheckBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscOrderItemBO;
import com.tydic.fsc.bo.RelOrderItemBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderFailLogUpdateAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderFailLogUpdateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderFailLogUpdateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderSyncCheckStatusReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderSyncCheckStatusRspBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocOrderSyncCheckStatusAbilityService;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultItemMapper;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.dao.FscOrderExtFieldMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCheckResultItemPO;
import com.tydic.fsc.po.FscCheckResultPO;
import com.tydic.fsc.po.FscOrderExtFieldPo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscBillSupplierCheckBusiServiceImpl
implements FscBillSupplierCheckBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSupplierCheckBusiServiceImpl.class);
    @Autowired
    private FscOrderExtFieldMapper fscOrderExtFieldMapper;
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscCheckResultItemMapper fscCheckResultItemMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscUocOrderSyncCheckStatusAbilityService fscUocOrderSyncCheckStatusAbilityService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscOrderFailLogUpdateAtomService fscOrderFailLogUpdateAtomService;
    public static final String BUSI_NAME = "\u4e3b\u5355\u53d1\u7968\u5bf9\u8d26";
    public static final String BUSI_CODE = "1004";
    @Value(value="${supplierCheck.expandEnable:true}")
    private Boolean expandEnable;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FscBillSupplierCheckBusiRspBO dealSupplierCheck(FscBillSupplierCheckBusiReqBO reqBO, String type) {
        List acceptOrderIds;
        List fscCheckResultPos;
        Map<String, List<FscOrderItemBO>> fscOrderItemListMap;
        Map<String, List<RelOrderItemBO>> relOrderItemListMap;
        List fscOrderItemBOS;
        FscOrderInfoBO fscOrderInfoBO;
        Map<Object, FscOrderInfoBO> fscOrderInfoMap;
        Map fscOrderInfoBoMap;
        FscAcceptOrderListQueryAtomRspBO atomRspBO;
        List<FscBillSupplierCheckBusiOrderItemBO> relOrderList = reqBO.getRelOrderList();
        FscAcceptOrderListQueryAtomReqBO queryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
        if ("1".equals(type)) {
            List acceptCodeList = relOrderList.stream().map(FscBillSupplierCheckBusiOrderItemBO::getAcceptOrderCode).collect(Collectors.toList());
            queryAtomReqBO.setInspOrderNoList(acceptCodeList);
            atomRspBO = this.fscAcceptOrderListQueryAtomService.query(queryAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193013", atomRspBO.getRespDesc());
            }
            fscOrderInfoBoMap = atomRspBO.getFscOrderInfoBoMap();
            if (CollectionUtils.isEmpty((Map)fscOrderInfoBoMap) || fscOrderInfoBoMap.size() != acceptCodeList.size()) throw new FscBusinessException("193013", "\u8bf7\u52ff\u4fee\u6539\u9a8c\u6536\u5355\u53f7");
            fscOrderInfoMap = fscOrderInfoBoMap.values().stream().collect(Collectors.toMap(FscOrderInfoBO::getAcceptOrderNo, fscOrderInfo -> fscOrderInfo));
            for (FscBillSupplierCheckBusiOrderItemBO orderItemBO : relOrderList) {
                fscOrderInfoBO = fscOrderInfoMap.get(orderItemBO.getAcceptOrderCode());
                orderItemBO.setSaleAmount(fscOrderInfoBO.getInspTotalSaleMoney());
                orderItemBO.setOrderId(fscOrderInfoBO.getOrderId());
                orderItemBO.setAcceptOrderId(fscOrderInfoBO.getAcceptOrderId());
                orderItemBO.setTradeMode(fscOrderInfoBO.getTradeMode());
                fscOrderItemBOS = fscOrderInfoBO.getFscOrderItemBOS();
                relOrderItemListMap = orderItemBO.getRelOrderitemList().stream().collect(Collectors.groupingBy(e -> Convert.toStr((Object)e.getSkuId()) + Convert.toStr((Object)e.getNum().setScale(5, RoundingMode.HALF_UP))));
                if (CollectionUtils.isEmpty((Collection)fscOrderItemBOS)) continue;
                fscOrderItemListMap = fscOrderItemBOS.stream().collect(Collectors.groupingBy(e -> Convert.toStr((Object)e.getSkuId()) + Convert.toStr((Object)e.getNum().setScale(5, RoundingMode.HALF_UP))));
                relOrderItemListMap.forEach((key, fscOrderItemBOList) -> {
                    List fscOrderItemBOS1 = (List)fscOrderItemListMap.get(key);
                    if (!CollectionUtils.isEmpty((Collection)fscOrderItemBOS1)) {
                        IntStream.range(0, fscOrderItemBOList.size()).forEach(i -> ((RelOrderItemBO)fscOrderItemBOList.get(i)).setOrderItemId(((FscOrderItemBO)fscOrderItemBOS1.get(i)).getOrderItemId()));
                    }
                });
            }
        } else {
            List acceptIdList = relOrderList.stream().map(FscBillSupplierCheckBusiOrderItemBO::getAcceptOrderId).collect(Collectors.toList());
            queryAtomReqBO.setInspOrderIdList(acceptIdList);
            atomRspBO = this.fscAcceptOrderListQueryAtomService.query(queryAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193013", atomRspBO.getRespDesc());
            }
            fscOrderInfoBoMap = atomRspBO.getFscOrderInfoBoMap();
            if (!CollectionUtils.isEmpty((Map)fscOrderInfoBoMap) && fscOrderInfoBoMap.size() == acceptIdList.size()) {
                fscOrderInfoMap = fscOrderInfoBoMap.values().stream().collect(Collectors.toMap(FscOrderInfoBO::getAcceptOrderId, fscOrderInfo -> fscOrderInfo));
                for (FscBillSupplierCheckBusiOrderItemBO orderItemBO : relOrderList) {
                    fscOrderInfoBO = fscOrderInfoMap.get(orderItemBO.getAcceptOrderId());
                    orderItemBO.setSaleAmount(fscOrderInfoBO.getInspTotalSaleMoney());
                    orderItemBO.setTradeMode(fscOrderInfoBO.getTradeMode());
                    fscOrderItemBOS = fscOrderInfoBO.getFscOrderItemBOS();
                    relOrderItemListMap = orderItemBO.getRelOrderitemList().stream().collect(Collectors.groupingBy(e -> Convert.toStr((Object)e.getSkuId()) + Convert.toStr((Object)e.getNum().setScale(5, RoundingMode.HALF_UP))));
                    if (CollectionUtils.isEmpty((Collection)fscOrderItemBOS)) continue;
                    fscOrderItemListMap = fscOrderItemBOS.stream().collect(Collectors.groupingBy(e -> Convert.toStr((Object)e.getSkuId()) + Convert.toStr((Object)e.getNum().setScale(5, RoundingMode.HALF_UP))));
                    relOrderItemListMap.forEach((key, fscOrderItemBOList) -> {
                        List fscOrderItemBOS1 = (List)fscOrderItemListMap.get(key);
                        if (!CollectionUtils.isEmpty((Collection)fscOrderItemBOS1)) {
                            IntStream.range(0, fscOrderItemBOList.size()).forEach(i -> ((RelOrderItemBO)fscOrderItemBOList.get(i)).setOrderItemId(((FscOrderItemBO)fscOrderItemBOS1.get(i)).getOrderItemId()));
                        }
                    });
                }
            }
        }
        if ((fscCheckResultPos = this.fscCheckResultMapper.selectByAcceptOrderIds(acceptOrderIds = relOrderList.stream().map(FscBillSupplierCheckBusiOrderItemBO::getAcceptOrderId).collect(Collectors.toList()))).size() != 0) {
            List acceptOrderIdList = fscCheckResultPos.stream().map(FscCheckResultPO::getAcceptOrderId).collect(Collectors.toList());
            List deleteList = relOrderList.stream().filter(fscBillSupplierCheckBO -> acceptOrderIdList.contains(fscBillSupplierCheckBO.getAcceptOrderId())).collect(Collectors.toList());
            List deleteAcceptOrderIdList = deleteList.stream().map(FscBillSupplierCheckBusiOrderItemBO::getAcceptOrderId).collect(Collectors.toList());
            this.fscCheckResultMapper.deleteByAcceptIdList(deleteAcceptOrderIdList);
            this.fscCheckResultItemMapper.deleteByAcceptOrderId(deleteAcceptOrderIdList);
        }
        this.insert(relOrderList, reqBO);
        FscBillSupplierCheckBusiRspBO rspBO = new FscBillSupplierCheckBusiRspBO();
        if (!"2".equals(type)) return rspBO;
        if (this.expandEnable.booleanValue()) {
            this.updateFscExpand(reqBO);
        }
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(reqBO.getOrderId());
        flowAtomReqBO.setCurStatus(FscBillStatus.TO_BE_RECONCILED.getCode());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setBusiCode(BUSI_CODE);
        flowAtomReqBO.setUserId(reqBO.getUserId());
        flowAtomReqBO.setUserName(reqBO.getUserName());
        FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
        if (!"0000".equals(flowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193013", flowAtomRspBO.getRespDesc());
        }
        for (FscBillSupplierCheckBusiOrderItemBO fscBillSupplierCheckBusiOrderItemBO : relOrderList) {
            FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO = new FscUocOrderSyncCheckStatusReqBO();
            uocOrderSyncCheckStatusReqBO.setInspectionVoucherId(fscBillSupplierCheckBusiOrderItemBO.getAcceptOrderId());
            uocOrderSyncCheckStatusReqBO.setOrderId(fscBillSupplierCheckBusiOrderItemBO.getOrderId());
            BigDecimal amount = fscBillSupplierCheckBusiOrderItemBO.getAmount();
            BigDecimal relAmount = fscBillSupplierCheckBusiOrderItemBO.getRelAmount();
            uocOrderSyncCheckStatusReqBO.setCheckState(amount.compareTo(relAmount) == 0 ? FscConstants.BillCheck.EQUALS : FscConstants.BillCheck.NOT_EQUALS);
            FscUocOrderSyncCheckStatusRspBO uocOrderSyncCheckStatusRspBO = this.fscUocOrderSyncCheckStatusAbilityService.dealSyncCheckStatus(uocOrderSyncCheckStatusReqBO);
            if ("0000".equals(uocOrderSyncCheckStatusRspBO.getRespCode())) continue;
            this.writeFailLog(uocOrderSyncCheckStatusRspBO, uocOrderSyncCheckStatusReqBO, reqBO);
        }
        return rspBO;
    }

    private void updateFscExpand(FscBillSupplierCheckBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getValue5())) {
            throw new FscBusinessException("191000", "\u6536\u6b3e\u94f6\u884c\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getValue6())) {
            throw new FscBusinessException("191000", "\u6536\u6b3e\u94f6\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != reqBO.getOrderId()) {
            FscOrderExtFieldPo fscOrderExtFieldPo = (FscOrderExtFieldPo)JUtil.js((Object)((Object)reqBO), FscOrderExtFieldPo.class);
            fscOrderExtFieldPo.setFscOrderId(reqBO.getOrderId());
            this.fscOrderExtFieldMapper.updateById(fscOrderExtFieldPo);
        }
    }

    private void insert(List<FscBillSupplierCheckBusiOrderItemBO> relOrderList, FscBillSupplierCheckBusiReqBO reqBO) {
        Date checkTime = new Date();
        for (FscBillSupplierCheckBusiOrderItemBO fscBillSupplierCheckBusiOrderItemBO : relOrderList) {
            FscCheckResultPO fscCheckResultPo = new FscCheckResultPO();
            fscCheckResultPo.setAcceptOrderId(fscBillSupplierCheckBusiOrderItemBO.getAcceptOrderId());
            fscCheckResultPo.setOrderId(fscBillSupplierCheckBusiOrderItemBO.getOrderId());
            fscCheckResultPo.setOtherNo(String.valueOf(reqBO.getOrgId()));
            BigDecimal amount = fscBillSupplierCheckBusiOrderItemBO.getAmount();
            BigDecimal relAmount = fscBillSupplierCheckBusiOrderItemBO.getRelAmount();
            fscCheckResultPo.setAmount(amount);
            fscCheckResultPo.setOtherAmount(relAmount);
            if (FscConstants.FscBusiModel.MATCHING.equals(fscBillSupplierCheckBusiOrderItemBO.getTradeMode())) {
                fscCheckResultPo.setSaleAmount(relAmount);
            } else {
                fscCheckResultPo.setSaleAmount(fscBillSupplierCheckBusiOrderItemBO.getSaleAmount());
            }
            fscCheckResultPo.setSupplierId(reqBO.getSupplierId());
            fscCheckResultPo.setStatus(amount.compareTo(relAmount) == 0 ? FscConstants.BillCheck.EQUALS : FscConstants.BillCheck.NOT_EQUALS);
            fscCheckResultPo.setCheckTime(checkTime);
            fscCheckResultPo.setOperId(reqBO.getUserId());
            fscCheckResultPo.setOperName(reqBO.getName());
            int insert = this.fscCheckResultMapper.insert(fscCheckResultPo);
            if (1 != insert) {
                throw new FscBusinessException("193013", "\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
            }
            List<RelOrderItemBO> relOrderitemList = fscBillSupplierCheckBusiOrderItemBO.getRelOrderitemList();
            for (RelOrderItemBO relOrderItemBO : relOrderitemList) {
                FscCheckResultItemPO fscCheckResultItemPo = new FscCheckResultItemPO();
                long id = Sequence.getInstance().nextId();
                fscCheckResultItemPo.setId(Long.valueOf(id));
                fscCheckResultItemPo.setAcceptOrderId(fscBillSupplierCheckBusiOrderItemBO.getAcceptOrderId());
                fscCheckResultItemPo.setAcceptOrderItemId(relOrderItemBO.getOrderItemId());
                fscCheckResultItemPo.setOrderId(fscBillSupplierCheckBusiOrderItemBO.getOrderId());
                fscCheckResultItemPo.setFscOrderId(reqBO.getOrderId());
                fscCheckResultItemPo.setSkuId(relOrderItemBO.getSkuId());
                fscCheckResultItemPo.setPrice(relOrderItemBO.getPrice());
                fscCheckResultItemPo.setNum(relOrderItemBO.getNum());
                fscCheckResultItemPo.setAmount(relOrderItemBO.getNum().multiply(relOrderItemBO.getPrice()));
                fscCheckResultItemPo.setOtherNum(relOrderItemBO.getOtherNum());
                fscCheckResultItemPo.setRemark(relOrderItemBO.getRemark());
                int insert1 = this.fscCheckResultItemMapper.insert(fscCheckResultItemPo);
                if (1 == insert1) continue;
                throw new FscBusinessException("193013", "\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
            }
        }
    }

    private void writeFailLog(FscUocOrderSyncCheckStatusRspBO uocOrderSyncCheckStatusRspBO, FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO, FscBillSupplierCheckBusiReqBO reqBO) {
        Map<Long, FscBillSupplierCheckBusiOrderItemBO> orderItemBoMap = reqBO.getRelOrderList().stream().collect(Collectors.toMap(FscBillSupplierCheckBusiOrderItemBO::getOrderId, o -> o));
        FscOrderFailLogUpdateAtomReqBO fscOrderFailLogUpdateAtomReqBO = new FscOrderFailLogUpdateAtomReqBO();
        long id = Sequence.getInstance().nextId();
        fscOrderFailLogUpdateAtomReqBO.setId(Long.valueOf(id));
        fscOrderFailLogUpdateAtomReqBO.setObjId(uocOrderSyncCheckStatusReqBO.getOrderId());
        fscOrderFailLogUpdateAtomReqBO.setObjNo(orderItemBoMap.get(uocOrderSyncCheckStatusReqBO.getOrderId()).getOrderCode());
        fscOrderFailLogUpdateAtomReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.ORDER_CHECK_STATUS_SYNC);
        fscOrderFailLogUpdateAtomReqBO.setBusiFailDesc(uocOrderSyncCheckStatusRspBO.getRespDesc());
        FscOrderFailLogUpdateAtomRspBO fscOrderFailLogUpdateAtomRspBO = this.fscOrderFailLogUpdateAtomService.dealInsert(fscOrderFailLogUpdateAtomReqBO);
        if (!"0000".equals(fscOrderFailLogUpdateAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193013", fscOrderFailLogUpdateAtomRspBO.getRespDesc());
        }
    }
}

