/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscReBillBusiService;
import com.tydic.fsc.bill.busi.bo.FscReBillBusiServiceReqBo;
import com.tydic.fsc.bill.busi.bo.FscReBillBusiServiceRspBo;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import java.util.HashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscReBillBusiServiceImpl
implements FscReBillBusiService {
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;

    @Override
    public FscReBillBusiServiceRspBo reBill(FscReBillBusiServiceReqBo reqBo) {
        this.delInvoice(reqBo);
        this.delInvoiceItem(reqBo);
        this.flowOrder(reqBo);
        return new FscReBillBusiServiceRspBo();
    }

    private void flowOrder(FscReBillBusiServiceReqBo reqBo) {
        for (Long fscOrderId : reqBo.getFscOrderIds()) {
            FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            flowAtomReqBO.setOrderId(fscOrderId);
            flowAtomReqBO.setUserId(reqBo.getUserId());
            flowAtomReqBO.setUserName(reqBo.getUserName());
            flowAtomReqBO.setCurStatus(FscBillStatus.INVOICED.getCode());
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
            paramMap.put("redoFlag", FscConstants.BillOrderRedoFlag.RE_DO);
            flowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
            if ("0000".equals(flowAtomRspBO.getRespCode())) continue;
            throw new FscBusinessException("193010", flowAtomRspBO.getRespDesc());
        }
    }

    private void delInvoiceItem(FscReBillBusiServiceReqBo reqBo) {
        if (CollectionUtils.isNotEmpty(reqBo.getFscOrderIds())) {
            FscInvoiceItemPO set = new FscInvoiceItemPO();
            set.setDelFlag(FscConstants.DELETE_TAG.DELETED);
            FscInvoiceItemPO where = new FscInvoiceItemPO();
            where.setFscOrderIds(reqBo.getFscOrderIds());
            this.fscInvoiceItemMapper.updateBy(set, where);
        }
    }

    private void delInvoice(FscReBillBusiServiceReqBo reqBo) {
        if (CollectionUtils.isNotEmpty(reqBo.getFscOrderIds())) {
            FscInvoicePO set = new FscInvoicePO();
            set.setDelFlag(FscConstants.DELETE_TAG.DELETED);
            FscInvoicePO where = new FscInvoicePO();
            where.setFscOrderIds(reqBo.getFscOrderIds());
            this.fscInvoiceMapper.updateBy(set, where);
        }
    }
}

