/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceSignBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignBusiRspBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscStockOperAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscStockOperAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscStockOperAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceCheckResultMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceCheckResultPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderInvoiceSignBusiServiceImpl
implements FscBillOrderInvoiceSignBusiService {
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscInvoiceCheckResultMapper fscInvoiceCheckResultMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;
    private static final String BUSI_NAME = "\u53d1\u7968\u7b7e\u6536";
    @Autowired
    private FscStockOperAtomService fscStockOperAtomService;

    @Override
    public FscBillOrderInvoiceSignBusiRspBO dealOrderInvoiceSign(FscBillOrderInvoiceSignBusiReqBO reqBO) {
        FscOrderInvoicePO fscOrderInvoicePoSet = new FscOrderInvoicePO();
        if (null != reqBO.getUserId()) {
            fscOrderInvoicePoSet.setSignOperId(reqBO.getUserId().toString());
        }
        fscOrderInvoicePoSet.setSignOperName(reqBO.getName());
        fscOrderInvoicePoSet.setSignTime(new Date());
        fscOrderInvoicePoSet.setSignTimeStart(new Date());
        FscOrderInvoicePO fscOrderInvoicePowhere = new FscOrderInvoicePO();
        fscOrderInvoicePowhere.setFscOrderId(reqBO.getOrderId());
        this.fscOrderInvoiceMapper.updateBy(fscOrderInvoicePoSet, fscOrderInvoicePowhere);
        if (null != reqBO.getInvoiceCmpResult()) {
            FscInvoiceCheckResultPO fscInvoiceCheckResultPO = new FscInvoiceCheckResultPO();
            fscInvoiceCheckResultPO.setAmountMargin(reqBO.getInvoiceCmpResult().getAmountMargin());
            fscInvoiceCheckResultPO.setCmpResult(reqBO.getInvoiceCmpResult().getCmpResultStr());
            fscInvoiceCheckResultPO.setIteNumMargin(reqBO.getInvoiceCmpResult().getItemNumMargin());
            fscInvoiceCheckResultPO.setUntaxAmtMargin(reqBO.getInvoiceCmpResult().getUntaxAmtMargin());
            fscInvoiceCheckResultPO.setTaxMargin(reqBO.getInvoiceCmpResult().getTaxMargin());
            fscInvoiceCheckResultPO.setCreateOperId(reqBO.getUserId());
            fscInvoiceCheckResultPO.setCreateOperName(reqBO.getName());
            fscInvoiceCheckResultPO.setCreateTime(new Date());
            fscInvoiceCheckResultPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscInvoiceCheckResultPO.setFscOrderId(reqBO.getOrderId());
            this.fscInvoiceCheckResultMapper.insert(fscInvoiceCheckResultPO);
        }
        if (reqBO.getCreateShouldPayFlag().booleanValue()) {
            this.createShouldPay(reqBO.getFscShouldPayBOS(), reqBO);
        }
        if (reqBO.getNeedOperStockEnable().booleanValue()) {
            this.inStock(reqBO.getOrderId(), reqBO.getStockFlag());
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(reqBO.getOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(reqBO.getCurStatus());
        fscOrderStatusFlowAtomReqBO.setUserId(reqBO.getUserId());
        fscOrderStatusFlowAtomReqBO.setUserName(reqBO.getUserName());
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
        this.syncOrderStatus(reqBO.getOrderId());
        return new FscBillOrderInvoiceSignBusiRspBO();
    }

    private void syncOrderStatus(Long fscOrderId) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.SIGN);
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
    }

    private void createShouldPay(List<FscShouldPayBO> fscShouldPayBOS, FscBillOrderInvoiceSignBusiReqBO reqBO) {
        if (!CollectionUtils.isEmpty(fscShouldPayBOS)) {
            FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
            fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            fscPayShouldPayCreateAtomReqBO.setUserId(reqBO.getUserId());
            fscPayShouldPayCreateAtomReqBO.setName(reqBO.getName());
            fscPayShouldPayCreateAtomReqBO.setUserName(reqBO.getUserName());
            fscPayShouldPayCreateAtomReqBO.setCompanyId(reqBO.getCompanyId());
            fscPayShouldPayCreateAtomReqBO.setCompanyName(reqBO.getCompanyName());
            fscPayShouldPayCreateAtomReqBO.setOrgId(reqBO.getOrgId());
            fscPayShouldPayCreateAtomReqBO.setOrgName(reqBO.getOrgName());
            FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
            if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193011", fscPayShouldPayCreateAtomRspBO.getRespDesc());
            }
        }
    }

    private void inStock(Long fscOrderId, Integer stockFlag) {
        FscStockOperAtomReqBO fscStockOperAtomReqBO = new FscStockOperAtomReqBO();
        fscStockOperAtomReqBO.setOperType(stockFlag);
        fscStockOperAtomReqBO.setFscOrderId(fscOrderId);
        FscStockOperAtomRspBO fscStockOperAtomRspBO = this.fscStockOperAtomService.dealStockOper(fscStockOperAtomReqBO);
        if (!"0000".equals(fscStockOperAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", fscStockOperAtomRspBO.getRespDesc());
        }
    }
}

