/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bill.ability.api.FscBillOrderAutoCreateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscAccountInvoiceReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderAutoCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderAutoCreateAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreateAbilityReqBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.bo.SplitOrderBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.busibase.external.api.umc.FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityService;
import com.tydic.fsc.busibase.external.api.uoc.FscUocInspectionDetailsListPageQueryService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderAutoCreateAbilityService"})
public class FscBillOrderAutoCreateAbilityServiceImpl
implements FscBillOrderAutoCreateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderAutoCreateAbilityServiceImpl.class);
    @Autowired
    private FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityService fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityService;
    @Autowired
    private FscUocInspectionDetailsListPageQueryService fscUocInspectionDetailsListPageQueryService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Resource(name="fscAutoCreateBillProvider")
    private ProxyMessageProducer fscAutoCreateBillProvider;
    private static final Integer GROUPWAY_NOSPLIT = 0;
    @Value(value="${FSC_AUTO_CREATE_BILL_TOPIC:FSC_AUTO_CREATE_BILL_TOPIC}")
    private String FSC_AUTO_CREATE_BILL_TOPIC;
    @Value(value="${FSC_AUTO_CREATE_BILL_TAG:*}")
    private String FSC_AUTO_CREATE_BILL_TAG;

    @PostMapping(value={"dealAutoCreate"})
    public FscBillOrderAutoCreateAbilityRspBO dealAutoCreate(@RequestBody FscBillOrderAutoCreateAbilityReqBO reqBO) {
        this.val(reqBO);
        List fscOrderInfoBOs = reqBO.getFscOrderInfoBos();
        FscAccountInvoiceReqBO accountInvoiceBO = reqBO.getAccountInvoiceBO();
        Map<Long, FscOrderInfoBO> fscOrderInfoBoMap = fscOrderInfoBOs.stream().collect(Collectors.toMap(FscOrderInfoBO::getAcceptOrderId, o -> o));
        FscBillOrderCreateAbilityReqBO fscBillOrderCreateAbilityReqBO = this.calAutoBillParam(reqBO, fscOrderInfoBoMap, accountInvoiceBO);
        fscBillOrderCreateAbilityReqBO.setFscOrderInfoBoMap(fscOrderInfoBoMap);
        fscBillOrderCreateAbilityReqBO.setIsAutoCreateOrder(Boolean.valueOf(true));
        this.fscAutoCreateBillProvider.send(new ProxyMessage(this.FSC_AUTO_CREATE_BILL_TOPIC, this.FSC_AUTO_CREATE_BILL_TAG, JSON.toJSONString((Object)fscBillOrderCreateAbilityReqBO)));
        return new FscBillOrderAutoCreateAbilityRspBO();
    }

    private void val(FscBillOrderAutoCreateAbilityReqBO reqBO) {
        if (null == reqBO.getFscOrderInfoBos()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fscOrderInfoBO]\u4e3a\u7a7a");
        }
        if (null == reqBO.getAccountInvoiceBO()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[accountInvoiceBO]\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAccountInvoiceBO().getInvoiceTitle())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d1\u7968\u4fe1\u606f[invoiceTitle]\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAccountInvoiceBO().getInvoiceType())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d1\u7968\u4fe1\u606f[invoiceType]\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getAccountInvoiceBO().getInvoiceClass())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u53d1\u7968\u4fe1\u606f[invoiceClass]\u4e3a\u7a7a");
        }
    }

    private FscBillOrderCreateAbilityReqBO calAutoBillParam(FscBillOrderAutoCreateAbilityReqBO reqBO, Map<Long, FscOrderInfoBO> fscOrderInfoBoMap, FscAccountInvoiceReqBO accountInvoiceBO) {
        ArrayList<FscOrderInfoBO> fscOrderInfoBOS = new ArrayList<FscOrderInfoBO>(fscOrderInfoBoMap.values());
        FscOrderInfoBO fscOrderInfoBO = (FscOrderInfoBO)fscOrderInfoBOS.get(0);
        FscBillOrderCreateAbilityReqBO fscBillOrderCreateAbilityReqBO = new FscBillOrderCreateAbilityReqBO();
        FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO = this.checkInvoiceParam(fscOrderInfoBO.getPurchaserId());
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.queryConfig("order_split_conditon", null);
        fscBillOrderCreateAbilityReqBO.setUserId(reqBO.getUserId());
        fscBillOrderCreateAbilityReqBO.setName(reqBO.getName());
        fscBillOrderCreateAbilityReqBO.setOrgId(reqBO.getOrgId());
        fscBillOrderCreateAbilityReqBO.setOrgName(reqBO.getOrgName());
        fscBillOrderCreateAbilityReqBO.setCompanyId(reqBO.getCompanyId());
        fscBillOrderCreateAbilityReqBO.setCompanyName(reqBO.getCompanyName());
        fscBillOrderCreateAbilityReqBO.setRuleType(GROUPWAY_NOSPLIT);
        fscBillOrderCreateAbilityReqBO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
        if (!FscConstants.FscBusiModel.TRADE.equals(fscOrderInfoBO.getBusiMode())) {
            throw new FscBusinessException("191013", "\u5916\u90e8\u4e2a\u4eba\u7528\u6237\u4e0d\u652f\u6301\u64ae\u5408\u6a21\u5f0f\u8ba2\u5355\u5f00\u7968\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u7ed3\u7b97\u6a21\u5f0f\uff01");
        }
        fscBillOrderCreateAbilityReqBO.setMakeType(FscConstants.FscOrderMakeType.OPERTION);
        fscBillOrderCreateAbilityReqBO.setReceiveType(FscConstants.FscOrderReceiveType.PURCHASE);
        fscBillOrderCreateAbilityReqBO.setOrderSource(fscOrderInfoBO.getOrderSource());
        fscBillOrderCreateAbilityReqBO.setSupplierName(fscOrderInfoBO.getSupplierName());
        fscBillOrderCreateAbilityReqBO.setSupplierId(this.str2Long(fscOrderInfoBO.getSupplierId()));
        fscBillOrderCreateAbilityReqBO.setPurchaserId(this.str2Long(fscOrderInfoBO.getPurchaserId()));
        fscBillOrderCreateAbilityReqBO.setMaxCharge(new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getSettleMoneyMax()));
        fscBillOrderCreateAbilityReqBO.setMaxOrderCount(Integer.valueOf(fscCfcUniteParamQryListDetailExternalRspBO.getOrderNumMax()));
        fscBillOrderCreateAbilityReqBO.setBuyName(accountInvoiceBO.getInvoiceTitle());
        fscBillOrderCreateAbilityReqBO.setInvoiceType(accountInvoiceBO.getInvoiceType());
        fscBillOrderCreateAbilityReqBO.setInvoiceCategory(Integer.valueOf(accountInvoiceBO.getInvoiceClass()));
        fscBillOrderCreateAbilityReqBO.setTaxNo(accountInvoiceBO.getTaxpayerId());
        fscBillOrderCreateAbilityReqBO.setBank(accountInvoiceBO.getBank());
        fscBillOrderCreateAbilityReqBO.setAccount(accountInvoiceBO.getAccount());
        fscBillOrderCreateAbilityReqBO.setAddress(accountInvoiceBO.getAddress());
        fscBillOrderCreateAbilityReqBO.setPhone(accountInvoiceBO.getPhone());
        fscBillOrderCreateAbilityReqBO.setReceiveName(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getContactNameWeb());
        fscBillOrderCreateAbilityReqBO.setReceiveAddr(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getAddrDesc());
        fscBillOrderCreateAbilityReqBO.setReceivePhone(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getTel());
        fscBillOrderCreateAbilityReqBO.setReceiveEmail(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getElcInvoiceEmail());
        fscBillOrderCreateAbilityReqBO.setTownCode(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getTownId());
        fscBillOrderCreateAbilityReqBO.setTown(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getTownName());
        fscBillOrderCreateAbilityReqBO.setAreaCode(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getCountyId());
        fscBillOrderCreateAbilityReqBO.setArea(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getCountyName());
        fscBillOrderCreateAbilityReqBO.setCityCode(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getCityId());
        fscBillOrderCreateAbilityReqBO.setCity(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getCityName());
        fscBillOrderCreateAbilityReqBO.setProvinceCode(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getProvinceId());
        fscBillOrderCreateAbilityReqBO.setProvince(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getProvinceName());
        ArrayList<SplitOrderBO> splitOrderList = new ArrayList<SplitOrderBO>();
        BigDecimal totalPurAmt = fscOrderInfoBoMap.values().stream().map(FscOrderInfoBO::getInspTotalMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        SplitOrderBO splitOrderBO = new SplitOrderBO();
        splitOrderBO.setAmount(totalPurAmt);
        splitOrderBO.setOrderNum(Integer.valueOf(fscOrderInfoBoMap.size()));
        ArrayList<RelOrderBO> relOrderList = new ArrayList<RelOrderBO>();
        for (FscOrderInfoBO fscOrderInfo : fscOrderInfoBoMap.values()) {
            RelOrderBO relOrderBO = new RelOrderBO();
            relOrderBO.setOrderId(fscOrderInfo.getOrderId());
            relOrderBO.setAcceptOrderId(fscOrderInfo.getAcceptOrderId());
            relOrderList.add(relOrderBO);
        }
        splitOrderBO.setRelOrderList(relOrderList);
        splitOrderList.add(splitOrderBO);
        fscBillOrderCreateAbilityReqBO.setSplitOrderList(splitOrderList);
        if (log.isDebugEnabled()) {
            log.debug("\u81ea\u52a8\u5f00\u7968\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscBillOrderCreateAbilityReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        return fscBillOrderCreateAbilityReqBO;
    }

    private FscCfcUniteParamQryListDetailExternalRspBO queryConfig(String cfcParam, String relId) {
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO;
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode(cfcParam);
        if (null != relId) {
            fscCfcUniteParamQryListDetailExternalReqBO.setRelId(relId);
        }
        if (!"0000".equals((fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO)).getRespCode())) {
            throw new FscBusinessException("191013", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        return fscCfcUniteParamQryListDetailExternalRspBO;
    }

    private FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO checkInvoiceParam(String orgId) {
        FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO = new FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO();
        fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO.setOrgId(Long.valueOf(orgId));
        FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO = this.fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityService.qryMain(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO);
        if (!"0000".equals(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getRespCode())) {
            throw new FscBusinessException("191013", fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getRespDesc());
        }
        if (null == fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO()) {
            throw new FscBusinessException("191013", "\u9ed8\u8ba4\u6536\u7968\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO;
    }

    private Long str2Long(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            throw new FscBusinessException("191013", "\u6570\u636e\u8f6c\u6362\u9519\u8bef");
        }
    }
}

