/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.busi.api.FscBillEcomCheckApplyBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckApplyBusiRspBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCheckResultPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillEcomCheckApplyBusiServiceImpl
implements FscBillEcomCheckApplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillEcomCheckApplyBusiServiceImpl.class);
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;

    @Override
    public FscBillEcomCheckApplyBusiRspBO dealEcomCheckApply(FscBillEcomCheckApplyBusiReqBO reqBO) {
        List<RelOrderBO> relOrderList = reqBO.getRelOrderList();
        List acceptIdList = relOrderList.stream().map(RelOrderBO::getAcceptOrderId).collect(Collectors.toList());
        FscCheckResultPO fscCheckResultPo = new FscCheckResultPO();
        fscCheckResultPo.setAcceptOrderIds(acceptIdList);
        List fscCheckResultPos = this.fscCheckResultMapper.getList(fscCheckResultPo);
        FscBillEcomCheckApplyBusiRspBO rspBO = new FscBillEcomCheckApplyBusiRspBO();
        ArrayList<Long> sendMqOrderIdList = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)fscCheckResultPos)) {
            this.insert(relOrderList, reqBO);
            sendMqOrderIdList.addAll(relOrderList.stream().map(RelOrderBO::getAcceptOrderId).collect(Collectors.toList()));
        } else {
            List<FscCheckResultPO> notEqualsList;
            List<FscCheckResultPO> equalsList;
            List notCheckList;
            List insertedAcceptIds = fscCheckResultPos.stream().map(FscCheckResultPO::getAcceptOrderId).collect(Collectors.toList());
            List<RelOrderBO> insertRelOrders = relOrderList.stream().filter(relOrder -> !insertedAcceptIds.contains(relOrder.getAcceptOrderId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(insertRelOrders)) {
                this.insert(insertRelOrders, reqBO);
                sendMqOrderIdList.addAll(insertRelOrders.stream().map(RelOrderBO::getAcceptOrderId).collect(Collectors.toList()));
            }
            if (!CollectionUtils.isEmpty(notCheckList = fscCheckResultPos.stream().filter(fscCheck -> FscConstants.BillCheck.NOT_CHECK.equals(fscCheck.getStatus())).collect(Collectors.toList()))) {
                sendMqOrderIdList.addAll(notCheckList.stream().map(FscCheckResultPO::getAcceptOrderId).collect(Collectors.toList()));
            }
            if (!CollectionUtils.isEmpty(equalsList = fscCheckResultPos.stream().filter(fscCheck -> FscConstants.BillCheck.EQUALS.equals(fscCheck.getStatus())).collect(Collectors.toList()))) {
                this.equalsUpdate(equalsList, reqBO);
            }
            if (!CollectionUtils.isEmpty(notEqualsList = fscCheckResultPos.stream().filter(fscCheck -> FscConstants.BillCheck.NOT_EQUALS.equals(fscCheck.getStatus())).collect(Collectors.toList()))) {
                this.notEqualsUpdate(relOrderList, notEqualsList, reqBO);
                sendMqOrderIdList.addAll(notEqualsList.stream().map(FscCheckResultPO::getAcceptOrderId).collect(Collectors.toList()));
            }
            if (Boolean.TRUE.equals(reqBO.getCheckEqualsFlag()) && CollectionUtil.isNotEmpty(equalsList)) {
                sendMqOrderIdList.addAll(equalsList.stream().map(FscCheckResultPO::getAcceptOrderId).collect(Collectors.toList()));
            }
        }
        sendMqOrderIdList = sendMqOrderIdList.stream().filter(Objects::nonNull).collect(Collectors.toList());
        rspBO.setSendMqOrderIds(sendMqOrderIdList);
        return rspBO;
    }

    private void notEqualsUpdate(List<RelOrderBO> relOrderList, List<FscCheckResultPO> notEqualsList, FscBillEcomCheckApplyBusiReqBO reqBO) {
        Map<Long, RelOrderBO> relOrderBoMap = relOrderList.stream().collect(Collectors.toMap(RelOrderBO::getAcceptOrderId, relOrderBO -> relOrderBO));
        notEqualsList.forEach(checkResult -> {
            int i;
            FscCheckResultPO fscCheckResult = new FscCheckResultPO();
            fscCheckResult.setAcceptOrderId(checkResult.getAcceptOrderId());
            fscCheckResult.setAmount(((RelOrderBO)relOrderBoMap.get(checkResult.getAcceptOrderId())).getMyAmount());
            fscCheckResult.setSaleAmount(((RelOrderBO)relOrderBoMap.get(checkResult.getAcceptOrderId())).getSaleAmount());
            fscCheckResult.setOtherNo(((RelOrderBO)relOrderBoMap.get(checkResult.getAcceptOrderId())).getOtherNo());
            fscCheckResult.setOperSn(ObjectUtil.isEmpty((Object)reqBO.getOperSn()) ? checkResult.getOperSn() : reqBO.getOperSn());
            fscCheckResult.setOperId(reqBO.getUserId());
            fscCheckResult.setOperName(reqBO.getName());
            fscCheckResult.setStatus(FscConstants.BillCheck.NOT_CHECK);
            if (log.isDebugEnabled()) {
                log.debug("\u4fee\u6539\u5bf9\u8d26\u4e0d\u4e00\u81f4\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)fscCheckResult));
            }
            if ((i = this.fscCheckResultMapper.updateById(fscCheckResult)) != 1) {
                throw new FscBusinessException("193001", "\u66f4\u65b0\u6570\u636e\u5e93\u51fa\u9519");
            }
        });
    }

    private void equalsUpdate(List<FscCheckResultPO> fscCheckResultPoList, FscBillEcomCheckApplyBusiReqBO reqBO) {
        fscCheckResultPoList.forEach(checkResult -> {
            int i;
            FscCheckResultPO fscCheckResult = new FscCheckResultPO();
            fscCheckResult.setAcceptOrderId(checkResult.getAcceptOrderId());
            fscCheckResult.setOperSn(ObjectUtil.isEmpty((Object)reqBO.getOperSn()) ? checkResult.getOperSn() : reqBO.getOperSn());
            fscCheckResult.setOperId(reqBO.getUserId());
            fscCheckResult.setOperName(reqBO.getName());
            if (log.isDebugEnabled()) {
                log.debug("\u4fee\u6539\u5bf9\u8d26\u4e00\u81f4\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)fscCheckResult));
            }
            if ((i = this.fscCheckResultMapper.updateById(fscCheckResult)) != 1) {
                throw new FscBusinessException("193001", "\u66f4\u65b0\u6570\u636e\u5e93\u51fa\u9519");
            }
        });
    }

    private void insert(List<RelOrderBO> relOrderList, FscBillEcomCheckApplyBusiReqBO reqBO) {
        relOrderList.forEach(relOrderBO -> {
            int insert;
            FscCheckResultPO fscCheckResult = new FscCheckResultPO();
            if (relOrderBO.getSupId() != null) {
                fscCheckResult.setSupplierId(relOrderBO.getSupId());
            } else {
                fscCheckResult.setSupplierId(reqBO.getSupplierId());
            }
            fscCheckResult.setAcceptOrderId(relOrderBO.getAcceptOrderId());
            fscCheckResult.setOrderId(relOrderBO.getOrderId());
            fscCheckResult.setOperId(reqBO.getUserId());
            fscCheckResult.setOperName(reqBO.getName());
            fscCheckResult.setOtherNo(relOrderBO.getOtherNo());
            fscCheckResult.setAmount(relOrderBO.getMyAmount());
            fscCheckResult.setSaleAmount(relOrderBO.getSaleAmount());
            fscCheckResult.setStatus(FscConstants.BillCheck.NOT_CHECK);
            fscCheckResult.setOperSn(reqBO.getOperSn());
            if (log.isDebugEnabled()) {
                log.debug("\u65b0\u589e\u5bf9\u8d26\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)fscCheckResult));
            }
            if ((insert = this.fscCheckResultMapper.insert(fscCheckResult)) != 1) {
                throw new FscBusinessException("193001", "\u66f4\u65b0\u6570\u636e\u5e93\u51fa\u9519");
            }
        });
    }
}

