/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.venus.extension.Extension;
import com.tydic.ext.fsc.api.FscOrderInfoPushServiceExtPt;
import com.tydic.ext.fsc.bo.FscOrderInfoPushReqBO;
import com.tydic.ext.fsc.bo.FscOrderInfoPushRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderInfoPushAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderInfoPushAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderInfoPushAtomRspBO;
import com.tydic.fsc.busibase.busi.api.FscSystemBusiLogBusiService;
import com.tydic.fsc.busibase.busi.bo.FscSystemBusiLogBusiServiceReqBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscOrderInfoPushAtomServiceImpl
implements FscOrderInfoPushAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderInfoPushAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscSystemBusiLogBusiService fscSystemBusiLogBusiService;
    @Extension
    @Autowired
    private FscOrderInfoPushServiceExtPt fscOrderInfoPushServiceExtPt;

    @Override
    public FscOrderInfoPushAtomRspBO dealPushFscOrderInfo(FscOrderInfoPushAtomReqBO reqBO) {
        FscOrderInfoPushAtomRspBO rspBO = new FscOrderInfoPushAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Long fscOrderId = reqBO.getFscOrderId();
        FscOrderInfoPushReqBO fscOrderInfoPushReqBO = (FscOrderInfoPushReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscOrderInfoPushReqBO.class);
        int failureCount = ObjectUtil.isEmpty((Object)reqBO.getFailureCount()) ? reqBO.getFailureCount() : 0;
        try {
            log.info("\u63a8\u9001NC\u7ed3\u7b97\u5355\u4fe1\u606f\u5165\u53c2\u4e3a: {}", (Object)JSON.toJSONString((Object)fscOrderInfoPushReqBO));
            FscOrderInfoPushRspBO pushRspBO = this.fscOrderInfoPushServiceExtPt.pushFscOrder(fscOrderInfoPushReqBO);
            log.info("\u63a8\u9001NC\u7ed3\u7b97\u5355\u4fe1\u606f\u8fd4\u53c2\u4e3a: {}", (Object)JSON.toJSONString((Object)pushRspBO));
            if (!"0000".equals(pushRspBO.getRespCode())) {
                this.systemBusiLog(reqBO.getLogId(), fscOrderId, FscConstants.SystemLogFlag.FAIL, JSON.toJSONString((Object)pushRspBO), JSON.toJSONString((Object)pushRspBO), new Date(), reqBO.getSendService(), this.getClass().getName(), failureCount + 1, pushRspBO.getRespDesc());
                rspBO.setRespCode("190000");
                rspBO.setRespDesc("\u5931\u8d25");
                return rspBO;
            }
            this.systemBusiLog(reqBO.getLogId(), fscOrderId, FscConstants.SystemLogFlag.SUCCESS, JSON.toJSONString((Object)pushRspBO), JSON.toJSONString((Object)pushRspBO), new Date(), reqBO.getSendService(), this.getClass().getName(), failureCount, pushRspBO.getRespDesc());
        }
        catch (Exception e) {
            this.systemBusiLog(reqBO.getLogId(), fscOrderId, FscConstants.SystemLogFlag.FAIL, JSON.toJSONString((Object)fscOrderInfoPushReqBO), JSON.toJSONString((Object)e.getMessage()), new Date(), reqBO.getSendService(), this.getClass().getName(), failureCount + 1, JSON.toJSONString((Object)e.getMessage()));
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u5931\u8d25");
        }
        return rspBO;
    }

    private void systemBusiLog(Long logId, Long busiObjId, Integer logFlag, String reqStr, String rspStr, Date createTime, String callService, String sendService, Integer failureCount, String failureReason) {
        if (ObjectUtil.isNotEmpty((Object)logId)) {
            FscSystemBusiLogBusiServiceReqBo update = new FscSystemBusiLogBusiServiceReqBo();
            update.setLogId(logId);
            update.setLogFlag(logFlag);
            update.setDelFlag(FscConstants.SystemLogFlag.SUCCESS.equals(logFlag) ? FscConstants.DELETE_TAG.DELETED : FscConstants.DELETE_TAG.NO_DEL);
            update.setFailureCount(failureCount);
            update.setReqParam(reqStr);
            update.setRspParam(rspStr);
            this.fscSystemBusiLogBusiService.updateSystemBusiLog(update);
        } else {
            FscSystemBusiLogBusiServiceReqBo logBusiServiceReqBo = new FscSystemBusiLogBusiServiceReqBo();
            logBusiServiceReqBo.setBusiObjId(busiObjId);
            logBusiServiceReqBo.setSystemType(FscConstants.SystemType.EXT);
            logBusiServiceReqBo.setLogType(FscConstants.SystemLogType.FORWARD);
            logBusiServiceReqBo.setLogFlag(logFlag);
            logBusiServiceReqBo.setBusiType(FscConstants.SystemLogBusiType.PUSH_FSC_ORDER_INFO);
            logBusiServiceReqBo.setBusiObjType(FscConstants.SystemLogBusiObjType.PUSH_FSC_ORDER_INFO);
            logBusiServiceReqBo.setCallService(callService);
            logBusiServiceReqBo.setSendService(sendService);
            logBusiServiceReqBo.setReqParam(reqStr);
            logBusiServiceReqBo.setRspParam(rspStr);
            logBusiServiceReqBo.setCreateTime(createTime);
            logBusiServiceReqBo.setFailureCount(failureCount);
            logBusiServiceReqBo.setFailureReason(failureReason);
            this.fscSystemBusiLogBusiService.systemBusiLog(logBusiServiceReqBo);
        }
    }
}

