/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.atom.api.FscTodoSendAtomService;
import com.tydic.fsc.busibase.atom.bo.FscTodoSendAtomServiceReqBo;
import com.tydic.fsc.busibase.atom.bo.FscTodoSendAtomServiceRspBo;
import com.tydic.fsc.busibase.external.api.auth.FscAuthGetUserByRoleAndOrgExtService;
import com.tydic.fsc.busibase.external.api.bo.FscAuthGetUserByRoleAndOrgReqBo;
import com.tydic.fsc.busibase.external.api.bo.FscAuthGetUserByRoleAndOrgRspBo;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeReceiverBO;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeSendExtReqBo;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeSendExtRspBo;
import com.tydic.fsc.busibase.external.api.bo.FscUmcSendTodoReqBo;
import com.tydic.fsc.busibase.external.api.bo.FscUmcSendTodoRspBo;
import com.tydic.fsc.busibase.external.api.bo.FscUmcTodoBo;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.busibase.external.api.notice.FscNoticeSendExtService;
import com.tydic.fsc.busibase.external.api.umc.FscUmcSendTodoAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscTodoConfigMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscTodoConfigPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscTodoSendAtomServiceImpl
implements FscTodoSendAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscTodoSendAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscTodoConfigMapper fscTodoConfigMapper;
    @Autowired
    private FscAuthGetUserByRoleAndOrgExtService fscAuthGetUserByRoleAndOrgExtService;
    @Autowired
    private FscUmcSendTodoAtomService fscUmcSendTodoAtomService;
    @Autowired
    private FscNoticeSendExtService fscNoticeSendExtService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    public static final Integer HAVE_NOTICE = 1;
    @Value(value="#{'${send.notice.time.limit.code:1015,1017}'.split(',')}")
    public List<String> TIME_LIMIT_CODE;

    @Override
    public FscTodoSendAtomServiceRspBo sendTodo(FscTodoSendAtomServiceReqBo reqBo) {
        FscTodoConfigPO todoConfigPO;
        this.val(reqBo);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBo.getFscOrderId());
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrder) {
            return new FscTodoSendAtomServiceRspBo();
        }
        FscTodoConfigPO fscTodoConfigPO = new FscTodoConfigPO();
        fscTodoConfigPO.setOrderFlow(fscOrder.getOrderFlow());
        fscTodoConfigPO.setOrderState(reqBo.getNewStatus());
        fscTodoConfigPO.setIsApproval(0);
        if (!FscConstants.OrderFlow.PAY.equals(fscOrder.getOrderFlow())) {
            fscTodoConfigPO.setMakeType(fscOrder.getMakeType());
            fscTodoConfigPO.setReceiveType(fscOrder.getReceiveType());
            if (FscConstants.OrderFlow.INVOICE.equals(fscOrder.getOrderFlow())) {
                fscTodoConfigPO.setOrderSource(Convert.toInt((Object)fscOrder.getOrderSource()));
            }
        }
        if (null == (todoConfigPO = this.fscTodoConfigMapper.getModelBy(fscTodoConfigPO))) {
            return new FscTodoSendAtomServiceRspBo();
        }
        FscAuthGetUserByRoleAndOrgReqBo fscAuthGetUserByRoleAndOrgReqBo = new FscAuthGetUserByRoleAndOrgReqBo();
        fscAuthGetUserByRoleAndOrgReqBo.setRoleCodes(Arrays.asList(todoConfigPO.getRole().split(";")));
        if (FscConstants.OrderFlow.PAY.equals(fscOrder.getOrderFlow())) {
            fscAuthGetUserByRoleAndOrgReqBo.setLvOrgId(fscOrder.getPayerId());
        } else if (FscConstants.FscOrderReceiveType.OPERATION.equals(todoConfigPO.getReceiverOrg())) {
            fscAuthGetUserByRoleAndOrgReqBo.setLvOrgId(fscOrder.getProOrgId());
        } else if (FscConstants.FscOrderReceiveType.SUPPLIER.equals(todoConfigPO.getReceiverOrg())) {
            fscAuthGetUserByRoleAndOrgReqBo.setLvOrgId(fscOrder.getSupplierId());
        } else if (FscConstants.FscOrderReceiveType.PURCHASE.equals(todoConfigPO.getReceiverOrg())) {
            fscAuthGetUserByRoleAndOrgReqBo.setLvOrgId(fscOrder.getPurchaserId());
        }
        fscAuthGetUserByRoleAndOrgReqBo.setPageNo(1);
        fscAuthGetUserByRoleAndOrgReqBo.setPageSize(1000);
        fscAuthGetUserByRoleAndOrgReqBo.setLevelFlag(1);
        FscAuthGetUserByRoleAndOrgRspBo userByRoleAndOrg = this.fscAuthGetUserByRoleAndOrgExtService.getUserByRoleAndOrg(fscAuthGetUserByRoleAndOrgReqBo);
        if ("0000".equals(userByRoleAndOrg.getRespCode())) {
            ArrayList<FscNoticeReceiverBO> receiverBOS = new ArrayList<FscNoticeReceiverBO>();
            List<FscUmcTodoBo> sendTodoList = this.dealSendToto(todoConfigPO, userByRoleAndOrg, fscOrder, receiverBOS);
            if (userByRoleAndOrg.getTotal() > 1) {
                for (int i = 0; i < userByRoleAndOrg.getTotal(); ++i) {
                    fscAuthGetUserByRoleAndOrgReqBo.setPageNo(i + 2);
                    FscAuthGetUserByRoleAndOrgRspBo userByRoleAndOrgRspBo = this.fscAuthGetUserByRoleAndOrgExtService.getUserByRoleAndOrg(fscAuthGetUserByRoleAndOrgReqBo);
                    sendTodoList.addAll(this.dealSendToto(todoConfigPO, userByRoleAndOrgRspBo, fscOrder, receiverBOS));
                }
            }
            if (CollectionUtils.isNotEmpty(sendTodoList)) {
                FscUmcSendTodoReqBo fscUmcSendTodoReqBo = new FscUmcSendTodoReqBo();
                fscUmcSendTodoReqBo.setTodoList(sendTodoList);
                FscUmcSendTodoRspBo fscUmcSendTodoRspBo = this.fscUmcSendTodoAtomService.sendTodo(fscUmcSendTodoReqBo);
                if (!"0000".equals(fscUmcSendTodoRspBo.getRespCode())) {
                    throw new FscBusinessException(fscUmcSendTodoRspBo.getRespCode(), fscUmcSendTodoRspBo.getRespDesc());
                }
                log.info("\u901a\u77e5\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(receiverBOS));
                if (HAVE_NOTICE.equals(todoConfigPO.getHaveNotice()) && CollectionUtils.isNotEmpty(receiverBOS)) {
                    this.sendNotice(fscOrder, todoConfigPO, receiverBOS);
                }
            }
        }
        return new FscTodoSendAtomServiceRspBo();
    }

    private void sendNotice(FscOrderPO fscOrderPO, FscTodoConfigPO fscTodoConfigPO, List<FscNoticeReceiverBO> receiverBOS) {
        FscNoticeSendExtReqBo fscNoticeSendExtReqBo = new FscNoticeSendExtReqBo();
        fscNoticeSendExtReqBo.setTaskCode(fscTodoConfigPO.getNoticeCode());
        fscNoticeSendExtReqBo.setSendId("1");
        fscNoticeSendExtReqBo.setSendName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        fscNoticeSendExtReqBo.setReceivers(receiverBOS);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("fscOrderId", (Object)fscOrderPO.getFscOrderId());
        jsonObject.put("fscOrderNo", (Object)fscOrderPO.getOrderNo());
        if (this.TIME_LIMIT_CODE.contains(fscTodoConfigPO.getTodoCode())) {
            FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.getConfig(fscOrderPO, fscTodoConfigPO);
            if (FscConstants.MemWaitDoneType.PENDING_TRANSACTION_SERVICE_FEE_SETTLEMENT_STATEMENT.getCode().equals(fscTodoConfigPO.getTodoCode())) {
                jsonObject.put("timeLimit", (Object)fscCfcUniteParamQryListDetailExternalRspBO.getMaxDealTime());
            } else {
                jsonObject.put("timeLimit", (Object)fscCfcUniteParamQryListDetailExternalRspBO.getReduceMaxProcTime());
            }
        }
        fscNoticeSendExtReqBo.setData(jsonObject.toJSONString());
        FscNoticeSendExtRspBo fscNoticeSendExtRspBo = this.fscNoticeSendExtService.sendNotice(fscNoticeSendExtReqBo);
        if (!"0000".equals(fscNoticeSendExtRspBo.getRespCode())) {
            throw new FscBusinessException(fscNoticeSendExtRspBo.getRespCode(), fscNoticeSendExtRspBo.getRespDesc());
        }
    }

    private FscCfcUniteParamQryListDetailExternalRspBO getConfig(FscOrderPO fscOrderPO, FscTodoConfigPO fscTodoConfigPO) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        if (FscConstants.MemWaitDoneType.PENDING_TRANSACTION_SERVICE_FEE_SETTLEMENT_STATEMENT.getCode().equals(fscTodoConfigPO.getTodoCode())) {
            fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("transaction_service_fee_rules");
        } else {
            fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("platform_usage");
        }
        fscCfcUniteParamQryListDetailExternalReqBO.setRelId(Convert.toStr((Object)fscOrderPO.getSupplierId()));
        return this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
    }

    private List<FscUmcTodoBo> dealSendToto(FscTodoConfigPO fscTodoConfigPO, FscAuthGetUserByRoleAndOrgRspBo userByRoleAndOrg, FscOrderPO fscOrder, List<FscNoticeReceiverBO> receiverBOS) {
        if (CollectionUtils.isNotEmpty((Collection)userByRoleAndOrg.getRows())) {
            return userByRoleAndOrg.getRows().stream().map(fscAuthByRoleAndOrgQryUserInfoBo -> {
                FscUmcTodoBo fscUmcTodoBo = new FscUmcTodoBo();
                fscUmcTodoBo.setBusiId(fscOrder.getOrderNo());
                fscUmcTodoBo.setTodoName(fscTodoConfigPO.getTodoName() + "-" + fscOrder.getOrderNo());
                fscUmcTodoBo.setTodoItemCode(fscTodoConfigPO.getTodoCode());
                if (fscTodoConfigPO.getItemUrl().contains("?")) {
                    fscUmcTodoBo.setUrlSuffix(StrUtil.format((CharSequence)"&fscOrderId={}", (Object[])new Object[]{fscOrder.getFscOrderId()}));
                } else {
                    fscUmcTodoBo.setUrlSuffix(StrUtil.format((CharSequence)"?fscOrderId={}", (Object[])new Object[]{fscOrder.getFscOrderId()}));
                }
                fscUmcTodoBo.setCreateOperId("1");
                fscUmcTodoBo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                fscUmcTodoBo.setCandidateOperId(Convert.toStr((Object)fscAuthByRoleAndOrgQryUserInfoBo.getUserId()));
                fscUmcTodoBo.setCandidateOperName(fscAuthByRoleAndOrgQryUserInfoBo.getCustName());
                FscNoticeReceiverBO fscNoticeReceiverBO = new FscNoticeReceiverBO();
                fscNoticeReceiverBO.setReceiverId(Convert.toStr((Object)fscAuthByRoleAndOrgQryUserInfoBo.getUserId()));
                fscNoticeReceiverBO.setReceiverName(fscAuthByRoleAndOrgQryUserInfoBo.getCustName());
                receiverBOS.add(fscNoticeReceiverBO);
                return fscUmcTodoBo;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void val(FscTodoSendAtomServiceReqBo reqBo) {
        if (null == reqBo.getNewStatus()) {
            throw new FscBusinessException("191000", "\u5165\u53c2newStatus\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2fscOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

