/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.consumer;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.busibase.atom.api.FscUpdateSaleOrderPayStateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscUpdateSaleOrderPayStateAtomReqBo;
import com.tydic.fsc.busibase.atom.bo.FscUpdateSaleOrderPayStateAtomRspBo;
import com.tydic.fsc.busibase.busi.api.FscSystemBusiLogBusiService;
import com.tydic.fsc.busibase.busi.bo.FscSystemBusiLogBusiServiceReqBo;
import com.tydic.fsc.constants.FscConstants;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FscOrderPayStatusSyncServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscOrderPayStatusSyncServiceConsumer.class);
    @Autowired
    private FscUpdateSaleOrderPayStateAtomService fscUpdateSaleOrderPayStateAtomService;
    @Autowired
    private FscSystemBusiLogBusiService fscSystemBusiLogBusiService;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        JSONObject jsonObject = JSON.parseObject((String)proxyMessage.getContent());
        Date createTime = jsonObject.getDate("createTime");
        String sendService = jsonObject.getString("sendService");
        try {
            if (log.isDebugEnabled()) {
                log.debug("---------------\u540c\u6b65\u8ba2\u5355\u4ed8\u6b3e\u72b6\u6001\u6d88\u8d39\u8005---------------");
            }
            List fscOrderIds = JSON.parseArray((String)JSON.toJSONString((Object)jsonObject.getJSONArray("busiParam")), Long.class);
            if (log.isDebugEnabled()) {
                log.debug("\u540c\u6b65\u8ba2\u5355\u4ed8\u6b3e\u72b6\u6001\u6d88\u8d39\u8005\u5165\u53c2\u53c2\u6570\u4e3a{}", (Object)proxyMessage.getContent());
            }
            if (CollectionUtils.isNotEmpty((Collection)fscOrderIds)) {
                FscUpdateSaleOrderPayStateAtomReqBo fscUocOrderRelUpdateAtomReqBO = new FscUpdateSaleOrderPayStateAtomReqBo();
                fscUocOrderRelUpdateAtomReqBO.setFscOrderIds(fscOrderIds);
                FscUpdateSaleOrderPayStateAtomRspBo fscUpdateSaleOrderPayStateAtomRspBo = this.fscUpdateSaleOrderPayStateAtomService.updateOrderPayState(fscUocOrderRelUpdateAtomReqBO);
                if (!"0000".equals(fscUpdateSaleOrderPayStateAtomRspBo.getRespCode())) {
                    this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, JSON.toJSONString((Object)fscUocOrderRelUpdateAtomReqBO), JSON.toJSONString((Object)((Object)fscUpdateSaleOrderPayStateAtomRspBo)), createTime, fscUpdateSaleOrderPayStateAtomRspBo.getRespDesc(), sendService);
                    log.error("\u540c\u6b65\u8ba2\u5355\u4ed8\u6b3e\u72b6\u6001\u6d88\u8d39\u8005\u540c\u6b65\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)fscUpdateSaleOrderPayStateAtomRspBo.getRespDesc());
                    return ProxyConsumerStatus.CONSUME_SUCCESS;
                }
                this.systemBusiLog(FscConstants.SystemLogFlag.SUCCESS, JSON.toJSONString((Object)fscUocOrderRelUpdateAtomReqBO), JSON.toJSONString((Object)((Object)fscUpdateSaleOrderPayStateAtomRspBo)), createTime, null, sendService);
            }
        }
        catch (Exception e) {
            this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, proxyMessage.getContent(), null, createTime, ExceptionUtil.stacktraceToString((Throwable)e), sendService);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void systemBusiLog(Integer logFlag, String reqStr, String rspStr, Date createTime, String failureReason, String callService) {
        FscSystemBusiLogBusiServiceReqBo logBusiServiceReqBo = new FscSystemBusiLogBusiServiceReqBo();
        logBusiServiceReqBo.setSystemType(FscConstants.SystemType.EXT);
        logBusiServiceReqBo.setLogType(FscConstants.SystemLogType.FORWARD);
        logBusiServiceReqBo.setLogFlag(logFlag);
        logBusiServiceReqBo.setBusiType(FscConstants.SystemLogBusiType.SYNC_ORDER_PAY_STATE);
        logBusiServiceReqBo.setCallService(callService);
        logBusiServiceReqBo.setSendService("FscUpdateSaleOrderPayStateAtomService");
        logBusiServiceReqBo.setReqParam(reqStr);
        logBusiServiceReqBo.setRspParam(rspStr);
        if (null == createTime) {
            logBusiServiceReqBo.setCreateTime(new Date());
        } else {
            logBusiServiceReqBo.setCreateTime(createTime);
        }
        logBusiServiceReqBo.setFailureReason(failureReason);
        this.fscSystemBusiLogBusiService.systemBusiLog(logBusiServiceReqBo);
    }
}

