/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.busibase.atom.api.FscPayRecordTodoDealAtomService;
import com.tydic.fsc.busibase.atom.bo.FscPayRecordInfoBO;
import com.tydic.fsc.busibase.atom.bo.FscPayRecordTodoDealAtomReqBo;
import com.tydic.fsc.busibase.atom.bo.FscPayRecordTodoDealAtomRspBo;
import com.tydic.fsc.busibase.external.api.auth.FscAuthGetUserByRoleAndOrgExtService;
import com.tydic.fsc.busibase.external.api.bo.FscAuthGetUserByRoleAndOrgReqBo;
import com.tydic.fsc.busibase.external.api.bo.FscAuthGetUserByRoleAndOrgRspBo;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeReceiverBO;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeSendExtReqBo;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeSendExtRspBo;
import com.tydic.fsc.busibase.external.api.bo.FscUmcSendHaveDoneReqBo;
import com.tydic.fsc.busibase.external.api.bo.FscUmcSendHaveDoneRspBo;
import com.tydic.fsc.busibase.external.api.bo.FscUmcSendTodoReqBo;
import com.tydic.fsc.busibase.external.api.bo.FscUmcSendTodoRspBo;
import com.tydic.fsc.busibase.external.api.bo.FscUmcTodoBo;
import com.tydic.fsc.busibase.external.api.notice.FscNoticeSendExtService;
import com.tydic.fsc.busibase.external.api.umc.DycUmcSendHaveDoneAtomService;
import com.tydic.fsc.busibase.external.api.umc.FscUmcSendTodoAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscTodoConfigMapper;
import com.tydic.fsc.po.FscTodoConfigPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscPayRecordTodoDealAtomServiceImpl
implements FscPayRecordTodoDealAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscPayRecordTodoDealAtomServiceImpl.class);
    @Autowired
    private FscTodoConfigMapper fscTodoConfigMapper;
    @Autowired
    private FscUmcSendTodoAtomService fscUmcSendTodoAtomService;
    @Autowired
    private DycUmcSendHaveDoneAtomService dycUmcSendHaveDoneAtomService;
    @Autowired
    private FscAuthGetUserByRoleAndOrgExtService fscAuthGetUserByRoleAndOrgExtService;
    @Autowired
    private FscNoticeSendExtService fscNoticeSendExtService;
    public static final Integer HAVE_NOTICE = 1;
    @Value(value="#{'${send.notice.time.limit.code:1015,1017}'.split(',')}")
    public List<String> TIME_LIMIT_CODE;

    @Override
    public FscPayRecordTodoDealAtomRspBo sendPayRecordTodo(FscPayRecordTodoDealAtomReqBo reqBo) {
        FscTodoConfigPO payTodoConfig = this.getTodoConfig();
        List<FscPayRecordInfoBO> fscShouldPayInfo = reqBo.getFscShouldPayInfo();
        ArrayList<FscUmcTodoBo> todoList = new ArrayList<FscUmcTodoBo>();
        for (FscPayRecordInfoBO fscPayRecordInfoBO : fscShouldPayInfo) {
            FscAuthGetUserByRoleAndOrgReqBo fscAuthGetUserByRoleAndOrgReqBo = new FscAuthGetUserByRoleAndOrgReqBo();
            fscAuthGetUserByRoleAndOrgReqBo.setLvOrgId(fscPayRecordInfoBO.getPayerId());
            fscAuthGetUserByRoleAndOrgReqBo.setRoleCodes(Arrays.asList(payTodoConfig.getRole().split(";")));
            fscAuthGetUserByRoleAndOrgReqBo.setPageNo(1);
            fscAuthGetUserByRoleAndOrgReqBo.setPageSize(1000);
            fscAuthGetUserByRoleAndOrgReqBo.setLevelFlag(1);
            FscAuthGetUserByRoleAndOrgRspBo userByRoleAndOrg = this.fscAuthGetUserByRoleAndOrgExtService.getUserByRoleAndOrg(fscAuthGetUserByRoleAndOrgReqBo);
            ArrayList<FscNoticeReceiverBO> receiverBOS = new ArrayList<FscNoticeReceiverBO>();
            if ("0000".equals(userByRoleAndOrg.getRespCode())) {
                todoList.addAll(this.dealSendToto(payTodoConfig, userByRoleAndOrg, fscPayRecordInfoBO, receiverBOS));
                if (userByRoleAndOrg.getTotal() > 1) {
                    for (int i = 0; i < userByRoleAndOrg.getTotal(); ++i) {
                        fscAuthGetUserByRoleAndOrgReqBo.setPageNo(i + 2);
                        FscAuthGetUserByRoleAndOrgRspBo userByRoleAndOrgRspBo = this.fscAuthGetUserByRoleAndOrgExtService.getUserByRoleAndOrg(fscAuthGetUserByRoleAndOrgReqBo);
                        todoList.addAll(this.dealSendToto(payTodoConfig, userByRoleAndOrgRspBo, fscPayRecordInfoBO, receiverBOS));
                    }
                }
            }
            if (!HAVE_NOTICE.equals(payTodoConfig.getHaveNotice()) || !CollectionUtils.isNotEmpty(receiverBOS)) continue;
            this.sendNotice(fscPayRecordInfoBO, payTodoConfig, receiverBOS);
        }
        if (CollectionUtils.isNotEmpty(todoList)) {
            FscUmcSendTodoReqBo fscUmcSendTodoReqBo = new FscUmcSendTodoReqBo();
            fscUmcSendTodoReqBo.setTodoList(todoList);
            FscUmcSendTodoRspBo fscUmcSendTodoRspBo = this.fscUmcSendTodoAtomService.sendTodo(fscUmcSendTodoReqBo);
            if (!"0000".equals(fscUmcSendTodoRspBo.getRespCode())) {
                log.error(fscUmcSendTodoRspBo.getRespDesc());
            }
        }
        return new FscPayRecordTodoDealAtomRspBo();
    }

    @Override
    public FscPayRecordTodoDealAtomRspBo sendPayRecordTodoDone(FscPayRecordTodoDealAtomReqBo reqBo) {
        FscTodoConfigPO payTodoConfig = this.getTodoConfig();
        List<FscPayRecordInfoBO> fscShouldPayInfo = reqBo.getFscShouldPayInfo();
        if (CollectionUtils.isNotEmpty(fscShouldPayInfo)) {
            for (FscPayRecordInfoBO fscPayRecordInfoBO : fscShouldPayInfo) {
                FscUmcSendHaveDoneReqBo fscUmcSendHaveDoneReqBo = new FscUmcSendHaveDoneReqBo();
                fscUmcSendHaveDoneReqBo.setBusiId(fscPayRecordInfoBO.getFscShouldPayNo());
                fscUmcSendHaveDoneReqBo.setTodoItemCode(payTodoConfig.getTodoCode());
                fscUmcSendHaveDoneReqBo.setOperUserId(Convert.toStr((Object)reqBo.getUserId()));
                fscUmcSendHaveDoneReqBo.setOperUserName(reqBo.getUserName());
                FscUmcSendHaveDoneRspBo fscUmcSendHaveDoneRspBo = this.dycUmcSendHaveDoneAtomService.sendHaveDone(fscUmcSendHaveDoneReqBo);
                if ("0000".equals(fscUmcSendHaveDoneRspBo.getRespCode())) continue;
                log.error(fscUmcSendHaveDoneRspBo.getRespDesc());
            }
        }
        return new FscPayRecordTodoDealAtomRspBo();
    }

    private void sendNotice(FscPayRecordInfoBO fscPayRecordInfoBO, FscTodoConfigPO fscTodoConfigPO, List<FscNoticeReceiverBO> receiverBOS) {
        FscNoticeSendExtReqBo fscNoticeSendExtReqBo = new FscNoticeSendExtReqBo();
        fscNoticeSendExtReqBo.setTaskCode(fscTodoConfigPO.getNoticeCode());
        fscNoticeSendExtReqBo.setSendId("1");
        fscNoticeSendExtReqBo.setSendName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        fscNoticeSendExtReqBo.setReceivers(receiverBOS);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("shouldPayId", (Object)fscPayRecordInfoBO.getFscShouldPayId());
        jsonObject.put("shouldPayNo", (Object)fscPayRecordInfoBO.getFscShouldPayNo());
        fscNoticeSendExtReqBo.setData(jsonObject.toJSONString());
        FscNoticeSendExtRspBo fscNoticeSendExtRspBo = this.fscNoticeSendExtService.sendNotice(fscNoticeSendExtReqBo);
        if (!"0000".equals(fscNoticeSendExtRspBo.getRespCode())) {
            log.error(fscNoticeSendExtRspBo.getRespDesc());
        }
    }

    private List<FscUmcTodoBo> dealSendToto(FscTodoConfigPO fscTodoConfigPO, FscAuthGetUserByRoleAndOrgRspBo userByRoleAndOrg, FscPayRecordInfoBO fscPayRecordInfoBO, List<FscNoticeReceiverBO> receiverBOS) {
        if (CollectionUtils.isNotEmpty((Collection)userByRoleAndOrg.getRows())) {
            return userByRoleAndOrg.getRows().stream().map(fscAuthByRoleAndOrgQryUserInfoBo -> {
                FscUmcTodoBo fscUmcTodoBo = new FscUmcTodoBo();
                fscUmcTodoBo.setBusiId(fscPayRecordInfoBO.getFscShouldPayNo());
                fscUmcTodoBo.setTodoName(fscTodoConfigPO.getTodoName() + "-" + fscPayRecordInfoBO.getFscShouldPayNo());
                fscUmcTodoBo.setTodoItemCode(fscTodoConfigPO.getTodoCode());
                if (fscTodoConfigPO.getItemUrl().contains("?")) {
                    fscUmcTodoBo.setUrlSuffix(StrUtil.format((CharSequence)"&shouldPayId={}", (Object[])new Object[]{fscPayRecordInfoBO.getFscShouldPayId()}));
                } else {
                    fscUmcTodoBo.setUrlSuffix(StrUtil.format((CharSequence)"?shouldPayId={}", (Object[])new Object[]{fscPayRecordInfoBO.getFscShouldPayId()}));
                }
                fscUmcTodoBo.setCreateOperId("1");
                fscUmcTodoBo.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
                fscUmcTodoBo.setCandidateOperId(Convert.toStr((Object)fscAuthByRoleAndOrgQryUserInfoBo.getUserId()));
                fscUmcTodoBo.setCandidateOperName(fscAuthByRoleAndOrgQryUserInfoBo.getCustName());
                FscNoticeReceiverBO fscNoticeReceiverBO = new FscNoticeReceiverBO();
                fscNoticeReceiverBO.setReceiverId(Convert.toStr((Object)fscAuthByRoleAndOrgQryUserInfoBo.getUserId()));
                fscNoticeReceiverBO.setReceiverName(fscAuthByRoleAndOrgQryUserInfoBo.getCustName());
                receiverBOS.add(fscNoticeReceiverBO);
                return fscUmcTodoBo;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private FscTodoConfigPO getTodoConfig() {
        FscTodoConfigPO fscTodoConfigPO = new FscTodoConfigPO();
        fscTodoConfigPO.setTodoCode(FscConstants.MemWaitDoneType.PENDING_PAYMENT_RECORD.getCode());
        return this.fscTodoConfigMapper.getModelBy(fscTodoConfigPO);
    }
}

