/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscOrderItemBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocAcceptOrderCommodityInfoExtBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListPageQueryReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListPageQueryRspBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocInspectionDetailsListPageQueryService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.TaxUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscAcceptOrderListQueryAtomServiceImpl
implements FscAcceptOrderListQueryAtomService {
    @Autowired
    private FscUocInspectionDetailsListPageQueryService fscUocInspectionDetailsListPageQueryService;
    @Value(value="${acceptOrderTabId:80013}")
    private Integer TAB_ID;

    @Override
    public FscAcceptOrderListQueryAtomRspBO query(FscAcceptOrderListQueryAtomReqBO reqBO) {
        FscAcceptOrderListQueryAtomRspBO rspBO = new FscAcceptOrderListQueryAtomRspBO();
        rspBO.setFscOrderInfoBoMap(this.packOrderInfo(reqBO));
        return rspBO;
    }

    private Map<Long, FscOrderInfoBO> packOrderInfo(FscAcceptOrderListQueryAtomReqBO reqBO) {
        FscUocInspectionDetailsListPageQueryReqBO fscUocInspectionDetailsListPageQueryReqBO = (FscUocInspectionDetailsListPageQueryReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscUocInspectionDetailsListPageQueryReqBO.class));
        fscUocInspectionDetailsListPageQueryReqBO.setPageSize(10000);
        FscUocInspectionDetailsListPageQueryRspBO fscUocInspectionDetailsListPageQueryRspBO = this.fscUocInspectionDetailsListPageQueryService.getInspectionDetailsList(fscUocInspectionDetailsListPageQueryReqBO);
        if (!"0000".equals(fscUocInspectionDetailsListPageQueryRspBO.getRespCode())) {
            throw new FscBusinessException("194301", fscUocInspectionDetailsListPageQueryRspBO.getRespDesc());
        }
        HashMap<Long, FscOrderInfoBO> fscOrderInfoBoMap = new HashMap<Long, FscOrderInfoBO>();
        for (FscUocInspectionDetailsListBO row : fscUocInspectionDetailsListPageQueryRspBO.getRows()) {
            FscOrderInfoBO fscOrderInfoBO = (FscOrderInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)row), FscOrderInfoBO.class);
            ArrayList<FscOrderItemBO> fscOrderItemBOS = new ArrayList<FscOrderItemBO>();
            for (FscUocAcceptOrderCommodityInfoExtBO fscUocInspectionItemListBO : row.getAcceptOrderCommodityInfo()) {
                FscOrderItemBO fscOrderItemBO = (FscOrderItemBO)JSONObject.parseObject((String)JSON.toJSONString((Object)fscUocInspectionItemListBO), FscOrderItemBO.class);
                fscOrderItemBO.setAcceptOrderId(row.getAcceptOrderId());
                fscOrderItemBO.setNum(fscUocInspectionItemListBO.getAcceptCount());
                fscOrderItemBO.setSkuIdExt(fscUocInspectionItemListBO.getSkuExtSkuId());
                fscOrderItemBO.setTaxRate(new BigDecimal(fscUocInspectionItemListBO.getTax()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                fscOrderItemBO.setUnit(fscUocInspectionItemListBO.getSettleUnit());
                if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                    fscOrderItemBO.setAmt(fscUocInspectionItemListBO.getInspSaleMoney());
                    fscOrderItemBO.setPrice(fscUocInspectionItemListBO.getSalePrice());
                }
                if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                    fscOrderItemBO.setAmt(fscUocInspectionItemListBO.getInspPurchaseMoney());
                    fscOrderItemBO.setPrice(fscUocInspectionItemListBO.getPurchasePrice());
                }
                if (null != fscOrderItemBO.getAmt()) {
                    fscOrderItemBO.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                    fscOrderItemBO.setUntaxAmt(fscOrderItemBO.getAmt().subtract(fscOrderItemBO.getTaxAmt()));
                }
                fscOrderItemBO.setSaleAmt(fscUocInspectionItemListBO.getInspSaleMoney());
                fscOrderItemBO.setSalePrice(fscUocInspectionItemListBO.getSalePrice());
                fscOrderItemBO.setSaleTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getSaleAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                fscOrderItemBO.setSaleUntaxAmt(fscOrderItemBO.getSaleAmt().subtract(fscOrderItemBO.getSaleTaxAmt()));
                fscOrderItemBO.setPurchaseAmt(fscUocInspectionItemListBO.getInspPurchaseMoney());
                fscOrderItemBO.setPurchasePrice(fscUocInspectionItemListBO.getPurchasePrice());
                fscOrderItemBO.setPurchaseTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getPurchaseAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                fscOrderItemBO.setPurchaseUntaxAmt(fscOrderItemBO.getPurchaseAmt().subtract(fscOrderItemBO.getPurchaseTaxAmt()));
                fscOrderItemBO.setOrderItemId(fscUocInspectionItemListBO.getInspOrderItemId());
                fscOrderItemBO.setOrderId(row.getSaleOrderId());
                fscOrderItemBOS.add(fscOrderItemBO);
            }
            fscOrderInfoBO.setAcceptOrderId(row.getAcceptOrderId());
            fscOrderInfoBO.setOrderId(row.getSaleOrderId());
            fscOrderInfoBO.setAcceptOrderNo(row.getAcceptOrderNo());
            fscOrderInfoBO.setExtOrderNo(row.getSaleOrderNoExt());
            fscOrderInfoBO.setSupplierName(row.getSupplierName());
            fscOrderInfoBO.setSupplierId(row.getSupplierId());
            fscOrderInfoBO.setProOrgName(row.getProName());
            fscOrderInfoBO.setProOrgId(Convert.toStr((Object)row.getProId()));
            fscOrderInfoBO.setPurchaserName(row.getPurOrgName());
            fscOrderInfoBO.setPurchaserId(Convert.toStr((Object)row.getPurOrgId()));
            fscOrderInfoBO.setPayNodeAccountDays(row.getPaymentDays());
            fscOrderInfoBO.setOrderNo(row.getSaleOrderNo());
            fscOrderInfoBO.setBusiMode(row.getTradeMode());
            fscOrderInfoBO.setSaleOrderNo(row.getSaleOrderNo());
            fscOrderInfoBO.setInspTotalPurchaseMoney(row.getInspTotalPurchaseFee());
            fscOrderInfoBO.setInspTotalSaleMoney(row.getInspTotalSalefee());
            fscOrderInfoBO.setInspectionOper(row.getInspOper());
            fscOrderInfoBO.setBusiMode(row.getTradeMode());
            fscOrderInfoBO.setCompanyId(row.getPurCompanyId());
            fscOrderInfoBO.setCompanyName(row.getPurCompanyName());
            if (!StringUtils.isBlank((CharSequence)row.getPurAccount())) {
                fscOrderInfoBO.setAccountSetId(Long.valueOf(row.getPurAccount()));
            }
            fscOrderInfoBO.setAccountSetName(row.getPurAccountName());
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                fscOrderInfoBO.setOrderNo(row.getSaleOrderNo());
                fscOrderInfoBO.setInspTotalMoney(row.getInspTotalSalefee());
                fscOrderInfoBO.setPayAccountDayRule(row.getPayAccountDayRule());
                fscOrderInfoBO.setPayNodeAccountDays(row.getPaymentDays());
                fscOrderInfoBO.setPayAccountDay(row.getPayAccountDay());
                fscOrderInfoBO.setPayBreakScale(row.getPayBreakScale());
                fscOrderInfoBO.setPayNodeRule(row.getPayNodeRule());
                fscOrderInfoBO.setPayType(row.getPayType());
                fscOrderInfoBO.setPayRule(row.getPayRule());
            }
            if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                fscOrderInfoBO.setOrderNo(row.getSaleOrderNo());
                fscOrderInfoBO.setInspTotalMoney(row.getInspTotalPurchaseFee());
                fscOrderInfoBO.setPayAccountDayRule(row.getProPayAccountDayRule());
                fscOrderInfoBO.setPayNodeAccountDays(row.getProPaymentDays());
                fscOrderInfoBO.setPayAccountDay(row.getProPayAccountDay());
                fscOrderInfoBO.setPayBreakScale(row.getProPayBreakScale());
                fscOrderInfoBO.setPayNodeRule(row.getProPayNodeRule());
                fscOrderInfoBO.setPayType(row.getProPayType());
                fscOrderInfoBO.setPayRule(row.getProPayRule());
            }
            fscOrderInfoBO.setFscOrderItemBOS(fscOrderItemBOS);
            fscOrderInfoBO.setPurchasePath(row.getPurOrgPath());
            fscOrderInfoBO.setProPath(row.getProOrgPath());
            fscOrderInfoBO.setSupplierPath(row.getSupOrgPath());
            fscOrderInfoBoMap.put(fscOrderInfoBO.getAcceptOrderId(), fscOrderInfoBO);
        }
        return fscOrderInfoBoMap;
    }
}

