/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FscElasticsearchUtil {
    private static final Logger log = LoggerFactory.getLogger(FscElasticsearchUtil.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private RestHighLevelClient restHighLevelClient;

    public boolean deleteIndex(String index) {
        if (StringUtils.isBlank((CharSequence)index)) {
            log.info("\u5220\u9664\u7d22\u5f15\u5185\u5bb9\u4e3a\u7a7a");
            return false;
        }
        DeleteIndexRequest request = new DeleteIndexRequest(index);
        try {
            AcknowledgedResponse indexResponse = this.restHighLevelClient.indices().delete(request, RequestOptions.DEFAULT);
            if (indexResponse.isAcknowledged()) {
                log.info("\u5220\u9664\u7d22\u5f15\u6210\u529f");
            } else {
                log.info("\u5220\u9664\u7d22\u5f15\u5931\u8d25");
            }
            return indexResponse.isAcknowledged();
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            String exceptionStr = JSON.toJSONString((Object)e.getMessage());
            return exceptionStr.contains("index_not_found_exception");
        }
    }

    public boolean createIndex(String index) {
        CreateIndexRequest request = new CreateIndexRequest(index);
        try {
            CreateIndexResponse indexResponse = this.restHighLevelClient.indices().create(request, RequestOptions.DEFAULT);
            if (indexResponse.isAcknowledged()) {
                log.info("\u521b\u5efa\u7d22\u5f15\u6210\u529f");
            } else {
                log.info("\u521b\u5efa\u7d22\u5f15\u5931\u8d25");
            }
            return indexResponse.isAcknowledged();
        }
        catch (IOException e) {
            log.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public String addData(String index, String type, String id, JSONObject object) {
        IndexRequest indexRequest = new IndexRequest(index);
        indexRequest.id(id);
        try {
            indexRequest.source(mapper.writeValueAsString((Object)object), XContentType.JSON);
            IndexResponse indexResponse = this.restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
            return indexResponse.getId();
        }
        catch (Exception e) {
            log.info("\u63d2\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public String addDataList(String index, String type, Map<Long, JSONObject> map, List<Long> idList) {
        try {
            BulkRequest request = new BulkRequest();
            for (Long aLong : idList) {
                request.add(new IndexRequest(index).source(mapper.writeValueAsString((Object)map.get(aLong)), XContentType.JSON).id(String.valueOf(aLong)));
            }
            this.restHighLevelClient.bulk(request, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            log.info("\u63d2\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return "true";
    }

    public boolean checkIndexExist(String index) {
        String ok = "OK";
        boolean checkResult = false;
        try {
            Request request = new Request("HEAD", index);
            Response response = this.restHighLevelClient.getLowLevelClient().performRequest(request);
            if (ok.equals(response.getStatusLine().getReasonPhrase())) {
                checkResult = true;
            }
        }
        catch (IOException e) {
            log.error("\u68c0\u67e5\u7d22\u5f15\u5931\u8d25", (Throwable)e);
        }
        return checkResult;
    }

    public Boolean deleteDataByCondition(String endPoint, JSONObject qryJson) {
        boolean deleteResult = false;
        NStringEntity entity = new NStringEntity(qryJson.toJSONString(), ContentType.APPLICATION_JSON);
        try {
            JSONObject deleteResultJson;
            int deleteCount;
            Request request = new Request("POST", endPoint);
            request.setEntity((HttpEntity)entity);
            Response response = this.restHighLevelClient.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (StringUtils.isNotBlank((CharSequence)result) && (deleteCount = (deleteResultJson = JSONObject.parseObject((String)result)).getInteger("deleted").intValue()) > 0) {
                deleteResult = true;
            }
        }
        catch (IOException e) {
            log.error("\u6839\u636e\u6761\u4ef6\u5220\u9664ES\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return deleteResult;
    }

    public RestClient getLowLevelClient() {
        return this.restHighLevelClient.getLowLevelClient();
    }
}

