/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.fsc.ability.api.FscDictionaryAbilityService;
import com.tydic.fsc.ability.api.bo.FscDictionaryAbilityRspBO;
import com.tydic.fsc.ability.api.bo.FscQueryDictionaryAbilityReqBO;
import com.tydic.fsc.base.FscRspPageBaseBO;
import com.tydic.fsc.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busi.api.bo.FscDicDictionaryReqBO;
import com.tydic.fsc.busi.api.bo.FscDictionaryBusiReqBO;
import com.tydic.fsc.common.bo.FscDicDictionaryBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscDictionaryAbilityService.class)
public class FscDictionaryAbilityServiceImpl
implements FscDictionaryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscDictionaryAbilityServiceImpl.class);
    @Autowired
    private FscDictionaryBusiService dictionaryBusiService;
    @Autowired
    private CacheClient cacheClient;

    public FscRspPageBaseBO<FscDicDictionaryBO> queryBypCodeBackPo(FscQueryDictionaryAbilityReqBO abilityReqBO) {
        FscRspPageBaseBO result = new FscRspPageBaseBO();
        List busiList = this.dictionaryBusiService.queryBypCodeBackPo("FSC", abilityReqBO.getPcode(), abilityReqBO.getTitle());
        result.setRows(busiList);
        return result;
    }

    public FscRspPageBaseBO<FscDicDictionaryBO> queryBypCodeBackPoPage(FscQueryDictionaryAbilityReqBO abilityReqBO) {
        FscRspPageBaseBO result = new FscRspPageBaseBO();
        FscDictionaryBusiReqBO dictionaryBusiReqBO = new FscDictionaryBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)dictionaryBusiReqBO);
        FscRspPageBaseBO busiList = this.dictionaryBusiService.queryBypCodeBackPoPage(dictionaryBusiReqBO);
        BeanUtils.copyProperties((Object)busiList, (Object)result);
        return result;
    }

    public FscDictionaryAbilityRspBO updateDicDictionary(FscDicDictionaryReqBO fscDicDictionaryReqBO) {
        this.validationParamsInvoice(fscDicDictionaryReqBO);
        FscDictionaryAbilityRspBO dictionaryAbilityRspBO = new FscDictionaryAbilityRspBO();
        dictionaryAbilityRspBO.setRespCode("188888");
        dictionaryAbilityRspBO.setRespDesc("\u6210\u529f");
        int checkResult = this.dictionaryBusiService.checkDicBy(fscDicDictionaryReqBO.getCode(), fscDicDictionaryReqBO.getPCode());
        if (checkResult < 1) {
            dictionaryAbilityRspBO.setRespCode("188888");
            dictionaryAbilityRspBO.setRespDesc("\u8be5\u5b57\u5178\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return dictionaryAbilityRspBO;
        }
        fscDicDictionaryReqBO.setSysCode("FSC");
        fscDicDictionaryReqBO.setDelflag(FscConstants.DicDelFlag.YES);
        int result = this.dictionaryBusiService.updateDicDictionary(fscDicDictionaryReqBO);
        if (result < 1) {
            dictionaryAbilityRspBO.setRespCode("6033");
            dictionaryAbilityRspBO.setRespDesc("\u4fee\u6539\u5931\u8d25");
        }
        return dictionaryAbilityRspBO;
    }

    public FscDictionaryAbilityRspBO deleteDicDictionary(FscDicDictionaryReqBO fscDicDictionaryReqBO) {
        this.validationParamsInvoice(fscDicDictionaryReqBO);
        FscDictionaryAbilityRspBO dictionaryAbilityRspBO = new FscDictionaryAbilityRspBO();
        int checkResult = this.dictionaryBusiService.checkDicBy(fscDicDictionaryReqBO.getCode(), fscDicDictionaryReqBO.getPCode());
        if (checkResult < 1) {
            dictionaryAbilityRspBO.setRespCode("6033");
            dictionaryAbilityRspBO.setRespDesc("\u8be5\u5b57\u5178\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return dictionaryAbilityRspBO;
        }
        int result = this.dictionaryBusiService.deleteDicDictionary(fscDicDictionaryReqBO);
        if (result < 1) {
            dictionaryAbilityRspBO.setRespCode("6033");
            dictionaryAbilityRspBO.setRespDesc("\u5220\u9664\u5931\u8d25");
        }
        return dictionaryAbilityRspBO;
    }

    public FscDictionaryAbilityRspBO addDicDictionary(FscDicDictionaryReqBO fscDicDictionaryReqBO) {
        this.validationParamsInvoice(fscDicDictionaryReqBO);
        FscDictionaryAbilityRspBO dictionaryAbilityRspBO = new FscDictionaryAbilityRspBO();
        int checkResult = this.dictionaryBusiService.checkDicBy(fscDicDictionaryReqBO.getCode(), fscDicDictionaryReqBO.getPCode());
        if (checkResult > 0) {
            dictionaryAbilityRspBO.setRespCode("6033");
            dictionaryAbilityRspBO.setRespDesc("\u8be5\u5b57\u5178\u5df2\u5b58\u5728");
            return dictionaryAbilityRspBO;
        }
        fscDicDictionaryReqBO.setDelflag(FscConstants.DicDelFlag.YES);
        fscDicDictionaryReqBO.setSysCode("FSC");
        int result = this.dictionaryBusiService.addDicDictionary(fscDicDictionaryReqBO);
        if (result < 1) {
            dictionaryAbilityRspBO.setRespCode("6033");
            dictionaryAbilityRspBO.setRespDesc("\u65b0\u589e\u5931\u8d25");
        }
        return dictionaryAbilityRspBO;
    }

    @RequestMapping(value={"queryBypCodeBackPoByPcode"})
    public Map<String, String> queryBypCodeBackPo(String pCode) {
        return this.dictionaryBusiService.queryBypCodeBackMap("FSC", pCode);
    }

    public Map<String, String> queryBypCodeBackMap(FscQueryDictionaryAbilityReqBO reqBO) {
        return this.dictionaryBusiService.queryBypCodeBackMap("FSC", reqBO.getPcode());
    }

    public List<FscDicDictionaryBO> queryDicByCache(String pCode) {
        if (StringUtils.isBlank((CharSequence)pCode)) {
            return new ArrayList<FscDicDictionaryBO>();
        }
        Object obj = this.cacheClient.get("PES_FSC_DIC_CACHE_REDIS_" + pCode);
        List busiList = (ArrayList)obj;
        if (CollectionUtils.isEmpty((Collection)busiList)) {
            busiList = this.dictionaryBusiService.queryBypCodeBackPo("FSC", pCode, "");
            if (CollectionUtils.isEmpty((Collection)busiList)) {
                busiList = new ArrayList();
            }
            this.cacheClient.set("PES_UMC_DIC_CACHE_REDIS_" + pCode, busiList);
        }
        return busiList;
    }

    public FscDictionaryAbilityRspBO delCacheDic(FscDicDictionaryReqBO fscDicDictionaryReqBO) {
        fscDicDictionaryReqBO.getPcodeList().forEach(pcode -> this.cacheClient.delete(pcode));
        FscDictionaryAbilityRspBO dictionaryAbilityRspBO = new FscDictionaryAbilityRspBO();
        return dictionaryAbilityRspBO;
    }

    private void validationParamsInvoice(FscDicDictionaryReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getPCode())) {
            throw new FscBusinessException("184000", "\u5b57\u5178\u670d\u52a1\u5165\u53c2[pcode]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCode())) {
            throw new FscBusinessException("184000", "\u5b57\u5178\u670d\u52a1\u5165\u53c2[code]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

