/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.atom.api.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.common.bo.FscOrderInfoBO;
import com.tydic.fsc.common.bo.FscOrderItemBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.external.api.bo.FscUocInspectionDetailsListBO;
import com.tydic.fsc.external.api.bo.FscUocInspectionDetailsListPageQueryReqBO;
import com.tydic.fsc.external.api.bo.FscUocInspectionDetailsListPageQueryRspBO;
import com.tydic.fsc.external.api.bo.FscUocInspectionItemListBO;
import com.tydic.fsc.external.api.uoc.FscUocInspectionDetailsListPageQueryService;
import com.tydic.fsc.util.TaxUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscAcceptOrderListQueryAtomServiceImpl
implements FscAcceptOrderListQueryAtomService {
    @Autowired
    private FscUocInspectionDetailsListPageQueryService fscUocInspectionDetailsListPageQueryService;

    public FscAcceptOrderListQueryAtomRspBO query(FscAcceptOrderListQueryAtomReqBO reqBO) {
        FscAcceptOrderListQueryAtomRspBO rspBO = new FscAcceptOrderListQueryAtomRspBO();
        rspBO.setFscOrderInfoBoMap(this.packOrderInfo(reqBO));
        return rspBO;
    }

    private Map<Long, FscOrderInfoBO> packOrderInfo(FscAcceptOrderListQueryAtomReqBO reqBO) {
        FscUocInspectionDetailsListPageQueryReqBO fscUocInspectionDetailsListPageQueryReqBO = (FscUocInspectionDetailsListPageQueryReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscUocInspectionDetailsListPageQueryReqBO.class);
        FscUocInspectionDetailsListPageQueryRspBO fscUocInspectionDetailsListPageQueryRspBO = this.fscUocInspectionDetailsListPageQueryService.getInspectionDetailsList(fscUocInspectionDetailsListPageQueryReqBO);
        if (!"0000".equals(fscUocInspectionDetailsListPageQueryRspBO.getRespCode())) {
            throw new FscBusinessException("188888", fscUocInspectionDetailsListPageQueryRspBO.getRespDesc());
        }
        HashMap<Long, FscOrderInfoBO> fscOrderInfoBoMap = new HashMap<Long, FscOrderInfoBO>();
        for (FscUocInspectionDetailsListBO row : fscUocInspectionDetailsListPageQueryRspBO.getRows()) {
            FscOrderInfoBO fscOrderInfoBO = new FscOrderInfoBO();
            ArrayList<FscOrderItemBO> fscOrderItemBOS = new ArrayList<FscOrderItemBO>();
            for (FscUocInspectionItemListBO fscUocInspectionItemListBO : row.getInspectionItemInfo()) {
                FscOrderItemBO fscOrderItemBO = (FscOrderItemBO)JSONObject.parseObject((String)JSON.toJSONString((Object)fscUocInspectionItemListBO), FscOrderItemBO.class);
                fscOrderItemBO.setAcceptOrderId(Long.valueOf(Long.parseLong(row.getInspectionVoucherId())));
                fscOrderItemBO.setNum(new BigDecimal(fscUocInspectionItemListBO.getInspectionCount()));
                fscOrderItemBO.setSkuIdExt(fscUocInspectionItemListBO.getExtSkuId());
                fscOrderItemBO.setTaxRate(new BigDecimal(fscUocInspectionItemListBO.getTax()));
                fscOrderItemBO.setUnit(fscUocInspectionItemListBO.getUnitName());
                if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                    fscOrderItemBO.setAmt(new BigDecimal(fscUocInspectionItemListBO.getInspSaleMoney()));
                    fscOrderItemBO.setPrice(new BigDecimal(fscUocInspectionItemListBO.getSellingPrice()));
                }
                if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
                    fscOrderItemBO.setAmt(new BigDecimal(fscUocInspectionItemListBO.getInspPurchaseMoney()));
                    fscOrderItemBO.setPrice(new BigDecimal(fscUocInspectionItemListBO.getPurchasingPrice()));
                }
                if (null != fscOrderItemBO.getAmt()) {
                    fscOrderItemBO.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                    fscOrderItemBO.setUntaxAmt(fscOrderItemBO.getAmt().subtract(fscOrderItemBO.getTaxAmt()));
                }
                fscOrderItemBO.setSaleAmt(new BigDecimal(fscUocInspectionItemListBO.getInspSaleMoney()));
                fscOrderItemBO.setSalePrice(new BigDecimal(fscUocInspectionItemListBO.getSellingPrice()));
                fscOrderItemBO.setSaleTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getSaleAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                fscOrderItemBO.setSaleUntaxAmt(fscOrderItemBO.getSaleAmt().subtract(fscOrderItemBO.getSaleTaxAmt()));
                fscOrderItemBO.setPurchaseAmt(new BigDecimal(fscUocInspectionItemListBO.getInspPurchaseMoney()));
                fscOrderItemBO.setPurchasePrice(new BigDecimal(fscUocInspectionItemListBO.getPurchasingPrice()));
                fscOrderItemBO.setPurchaseTaxAmt(TaxUtils.calTaxAmt((BigDecimal)fscOrderItemBO.getPurchaseAmt(), (BigDecimal)fscOrderItemBO.getTaxRate()));
                fscOrderItemBO.setPurchaseUntaxAmt(fscOrderItemBO.getPurchaseAmt().subtract(fscOrderItemBO.getPurchaseTaxAmt()));
                fscOrderItemBO.setOrderItemId(Long.valueOf(Long.parseLong(fscUocInspectionItemListBO.getInspectionItemId())));
                fscOrderItemBOS.add(fscOrderItemBO);
            }
            fscOrderInfoBO.setAcceptOrderId(Long.valueOf(Long.parseLong(row.getInspectionVoucherId())));
            fscOrderInfoBO.setOrderId(Long.valueOf(Long.parseLong(row.getOrderId())));
            fscOrderInfoBO.setAcceptOrderNo(row.getInspectionVoucherCode());
            fscOrderInfoBO.setExtOrderNo(row.getOutOrderId());
            fscOrderInfoBO.setFscOrderItemBOS(fscOrderItemBOS);
            fscOrderInfoBoMap.put(fscOrderInfoBO.getAcceptOrderId(), fscOrderInfoBO);
        }
        return fscOrderInfoBoMap;
    }
}

