/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.atom.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.atom.api.FscMerchantPayeeChannelAtomService;
import com.tydic.fsc.atom.api.bo.FscMerchantPayeeChannelAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscMerchantPayeeChannelAtomRspBO;
import com.tydic.fsc.atom.api.bo.FscMerchantPayeeChannelDataBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscMerchantPayeeChannelMapper;
import com.tydic.fsc.dao.po.FscMerchantPO;
import com.tydic.fsc.dao.po.FscMerchantPayeeChannelPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="fscMerchantPayeeChannelAtomService")
public class FscMerchantPayeeChannelAtomServiceImpl
implements FscMerchantPayeeChannelAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantPayeeChannelAtomServiceImpl.class);
    @Autowired
    private FscMerchantPayeeChannelMapper fscMerchantPayeeChannelMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;

    public FscMerchantPayeeChannelAtomRspBO queryPayChannel(FscMerchantPayeeChannelAtomReqBO reqBo) {
        FscMerchantPayeeChannelAtomRspBO retBo = new FscMerchantPayeeChannelAtomRspBO();
        FscMerchantPayeeChannelPO queryReqPo = new FscMerchantPayeeChannelPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)queryReqPo);
        List payChannelPos = this.fscMerchantPayeeChannelMapper.getList(queryReqPo);
        if (CollectionUtils.isEmpty((Collection)payChannelPos)) {
            log.error("\u6839\u636e\u5165\u53c2\uff1a{}\uff0c\u67e5\u8be2\u652f\u4ed8\u6e20\u9053\u914d\u7f6e\u4e3a\u7a7a", (Object)JSON.toJSONString((Object)reqBo));
            retBo.setRespCode("180000");
            retBo.setRespCode("\u6839\u636e\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo) + "\uff0c\u67e5\u8be2\u652f\u4ed8\u6e20\u9053\u914d\u7f6e\u4e3a\u7a7a");
            return retBo;
        }
        ArrayList<FscMerchantPayeeChannelDataBO> payChannels = new ArrayList<FscMerchantPayeeChannelDataBO>();
        for (FscMerchantPayeeChannelPO channelPo : payChannelPos) {
            FscMerchantPayeeChannelDataBO dataBo = new FscMerchantPayeeChannelDataBO();
            BeanUtils.copyProperties((Object)channelPo, (Object)dataBo);
            payChannels.add(dataBo);
        }
        retBo.setPayChannels(payChannels);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    public FscMerchantPayeeChannelAtomRspBO addPayChannel(FscMerchantPayeeChannelAtomReqBO reqBo) {
        FscMerchantPayeeChannelAtomRspBO retBo = new FscMerchantPayeeChannelAtomRspBO();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        String validateMerchantStr = this.validateMerchant(reqBo.getMerchantId());
        if (!StringUtils.isEmpty((Object)validateMerchantStr)) {
            retBo.setRespCode("180000");
            retBo.setRespDesc(validateMerchantStr);
            return retBo;
        }
        FscMerchantPayeeChannelPO validateReqPo = new FscMerchantPayeeChannelPO();
        validateReqPo.setMerchantId(reqBo.getMerchantId());
        validateReqPo.setPayChannel(reqBo.getPayChannel());
        FscMerchantPayeeChannelPO validateRetPo = this.fscMerchantPayeeChannelMapper.getModelBy(validateReqPo);
        if (null != validateRetPo) {
            log.error("\u5546\u6237[{}]\uff0c\u5df2\u914d\u7f6e\u652f\u4ed8\u6e20\u9053[{}]\uff0c\u4e0d\u53ef\u91cd\u590d\u914d\u7f6e", (Object)reqBo.getMerchantId(), (Object)reqBo.getPayChannel());
            retBo.setRespCode("180000");
            retBo.setRespDesc("\u5546\u6237[" + reqBo.getMerchantId() + "]\uff0c\u5df2\u914d\u7f6e\u652f\u4ed8\u6e20\u9053[" + reqBo.getPayChannel() + "]\uff0c\u4e0d\u53ef\u91cd\u590d\u914d\u7f6e");
            return retBo;
        }
        Long id = Sequence.getInstance().nextId();
        FscMerchantPayeeChannelPO addPayChannelReqPo = new FscMerchantPayeeChannelPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)addPayChannelReqPo);
        addPayChannelReqPo.setId(id);
        int result = this.fscMerchantPayeeChannelMapper.insert(addPayChannelReqPo);
        if (result < 1) {
            log.error("\u652f\u4ed8\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u5165\u8868\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            retBo.setRespCode("180000");
            retBo.setRespDesc("\u652f\u4ed8\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u5165\u8868\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            return retBo;
        }
        retBo.setId(id);
        return retBo;
    }

    public FscMerchantPayeeChannelAtomRspBO updatePayChannel(FscMerchantPayeeChannelAtomReqBO reqBo) {
        FscMerchantPayeeChannelAtomRspBO retBo = new FscMerchantPayeeChannelAtomRspBO();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        String validateMerchantStr = this.validateMerchant(reqBo.getMerchantId());
        if (!StringUtils.isEmpty((Object)validateMerchantStr)) {
            retBo.setRespCode("180000");
            retBo.setRespDesc(validateMerchantStr);
            return retBo;
        }
        if (null == reqBo.getId()) {
            retBo.setRespCode("180000");
            retBo.setRespDesc("\u66f4\u65b0\u652f\u4ed8\u673a\u6784\u914d\u7f6e\uff0c\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        FscMerchantPayeeChannelPO updatePayChannelReqPo = new FscMerchantPayeeChannelPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)updatePayChannelReqPo);
        int result = this.fscMerchantPayeeChannelMapper.updateById(updatePayChannelReqPo);
        if (result < 1) {
            log.error("\u652f\u4ed8\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            retBo.setRespCode("180000");
            retBo.setRespDesc("\u652f\u4ed8\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u66f4\u65b0\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            return retBo;
        }
        retBo.setId(reqBo.getId());
        return retBo;
    }

    public FscMerchantPayeeChannelAtomRspBO deletePayChannel(FscMerchantPayeeChannelAtomReqBO reqBo) {
        FscMerchantPayeeChannelAtomRspBO retBo = new FscMerchantPayeeChannelAtomRspBO();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        String validateMerchantStr = this.validateMerchant(reqBo.getMerchantId());
        if (!StringUtils.isEmpty((Object)validateMerchantStr)) {
            retBo.setRespCode("180000");
            retBo.setRespDesc(validateMerchantStr);
            return retBo;
        }
        if (null == reqBo.getId()) {
            retBo.setRespCode("180000");
            retBo.setRespDesc("\u66f4\u65b0\u652f\u4ed8\u673a\u6784\u914d\u7f6e\uff0c\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        FscMerchantPayeeChannelPO deletePayChannelReqPo = new FscMerchantPayeeChannelPO();
        deletePayChannelReqPo.setId(reqBo.getId());
        int result = this.fscMerchantPayeeChannelMapper.deleteBy(deletePayChannelReqPo);
        if (result < 1) {
            log.error("\u5220\u9664\u652f\u4ed8\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            retBo.setRespCode("180000");
            retBo.setRespDesc("\u5220\u9664\u652f\u4ed8\u673a\u6784\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            return retBo;
        }
        retBo.setId(reqBo.getId());
        return null;
    }

    public FscMerchantPayeeChannelAtomRspBO queryPage(FscMerchantPayeeChannelAtomReqBO reqBo) {
        FscMerchantPayeeChannelAtomRspBO retBo = new FscMerchantPayeeChannelAtomRspBO();
        ArrayList<FscMerchantPayeeChannelDataBO> rows = new ArrayList<FscMerchantPayeeChannelDataBO>();
        Page<FscMerchantPayeeChannelPO> page = this.getPage(reqBo);
        FscMerchantPayeeChannelPO queryPo = new FscMerchantPayeeChannelPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)queryPo);
        List channelPos = this.fscMerchantPayeeChannelMapper.getListPage(queryPo, page);
        FscMerchantPO merchantPo = new FscMerchantPO();
        merchantPo.setMerchantId(reqBo.getMerchantId());
        merchantPo = this.fscMerchantMapper.getModelBy(merchantPo);
        if (!CollectionUtil.isEmpty((Collection)channelPos)) {
            for (FscMerchantPayeeChannelPO channelPo : channelPos) {
                FscMerchantPayeeChannelDataBO dataBo = new FscMerchantPayeeChannelDataBO();
                BeanUtils.copyProperties((Object)channelPo, (Object)dataBo);
                dataBo.setUpdateOperId(merchantPo.getUpdateOperId());
                dataBo.setUpdateOperName(merchantPo.getUpdateOperName());
                dataBo.setUpdateTime(new DateTime((Object)merchantPo.getUpdateTime()).toString("yyyy-MM-dd HH:mm:ss"));
                dataBo.setRemark(merchantPo.getRemark());
                rows.add(dataBo);
            }
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)retBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        retBo.setRows(rows);
        retBo.setTotal(Integer.valueOf(page.getTotalPages()));
        retBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        return retBo;
    }

    private Page<FscMerchantPayeeChannelPO> getPage(FscMerchantPayeeChannelAtomReqBO reqBo) {
        if (reqBo.getPageNo() > 1) {
            return new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        }
        Page page = new Page();
        BeanUtils.copyProperties((Object)reqBo, (Object)page);
        if (page.getPageNo() < 1) {
            page.setPageNo(1);
        }
        if (page.getPageSize() < 1) {
            page.setPageSize(10);
        }
        return page;
    }

    private String validateMerchant(Long merhcantId) {
        FscMerchantPO queryReqBo = new FscMerchantPO();
        queryReqBo.setMerchantId(merhcantId);
        FscMerchantPO merchantPo = this.fscMerchantMapper.getModelBy(queryReqBo);
        if (merchantPo != null && !FscConstants.MerchantStatus.DRAFT.equals(merchantPo.getStatus())) {
            log.info("\u6b64\u5546\u6237\u975e\u8349\u7a3f\u72b6\u6001\uff0c\u4e0d\u53ef\u7f16\u8f91");
            return "\u6b64\u5546\u6237\u975e\u8349\u7a3f\u72b6\u6001\uff0c\u4e0d\u53ef\u7f16\u8f91";
        }
        return null;
    }
}

