/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.base.FscRspPageBaseBO;
import com.tydic.fsc.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busi.api.bo.FscDicDictionaryReqBO;
import com.tydic.fsc.busi.api.bo.FscDictionaryBusiReqBO;
import com.tydic.fsc.common.bo.FscDicDictionaryBO;
import com.tydic.fsc.dao.FscDicDictionaryMapper;
import com.tydic.fsc.dao.po.FscDicDictionaryPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscDictionaryBusiServiceImpl
implements FscDictionaryBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscDictionaryBusiServiceImpl.class);
    private static final String SYS_CODE_DEFAULT = "*";
    private static final Integer DIC_ORDER_ID = 1;
    @Autowired
    private FscDicDictionaryMapper dicDictionaryMapper;

    public List<FscDicDictionaryBO> queryBypCodeBackPo(String pCode) {
        return this.queryBypCodeBackPo(null, pCode);
    }

    public List<FscDicDictionaryBO> queryBypCodeBackPo(String sysCode, String pCode) {
        ArrayList<FscDicDictionaryBO> dicDictionaryBOS = new ArrayList<FscDicDictionaryBO>();
        List dicDictionaryPOS = this.dicDictionaryMapper.getListByCondition(this.getDicDictionaryPO(sysCode, pCode));
        if (dicDictionaryPOS != null) {
            for (FscDicDictionaryPO dicDictionaryPO : dicDictionaryPOS) {
                FscDicDictionaryBO dicDictionaryBO = new FscDicDictionaryBO();
                BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dicDictionaryBO);
                dicDictionaryBOS.add(dicDictionaryBO);
            }
        }
        return dicDictionaryBOS;
    }

    public FscRspPageBaseBO<FscDicDictionaryBO> queryBypCodeBackPoPage(FscDictionaryBusiReqBO dictionaryBusiReqBO) {
        FscDicDictionaryPO dicDictionary = new FscDicDictionaryPO();
        ArrayList<FscDicDictionaryBO> rows = new ArrayList<FscDicDictionaryBO>();
        dicDictionary.setSysCode(dictionaryBusiReqBO.getSysCode());
        dicDictionary.setPCode(dictionaryBusiReqBO.getPcode());
        dicDictionary.setTitle(dictionaryBusiReqBO.getTitle());
        Page page = new Page(dictionaryBusiReqBO.getPageNo().intValue(), dictionaryBusiReqBO.getPageSize().intValue());
        FscRspPageBaseBO dicDictionaryBOS = new FscRspPageBaseBO();
        List dicDictionaryPOS = this.dicDictionaryMapper.getListPageByCondition(dicDictionary, page);
        if (dicDictionaryPOS != null) {
            for (FscDicDictionaryPO dicDictionaryPO : dicDictionaryPOS) {
                FscDicDictionaryBO dicDictionaryBO = new FscDicDictionaryBO();
                BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dicDictionaryBO);
                rows.add(dicDictionaryBO);
            }
        }
        dicDictionaryBOS.setRespDesc("\u67e5\u8be2\u6210\u529f");
        dicDictionaryBOS.setRows(rows);
        dicDictionaryBOS.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        dicDictionaryBOS.setTotal(Integer.valueOf(page.getTotalPages()));
        dicDictionaryBOS.setPageNo(Integer.valueOf(page.getPageNo()));
        return dicDictionaryBOS;
    }

    public List<FscDicDictionaryBO> queryBypCodeBackPo(String sysCode, String pCode, String title) {
        FscDicDictionaryPO dicDictionary = new FscDicDictionaryPO();
        dicDictionary.setSysCode(sysCode);
        dicDictionary.setPCode(pCode);
        dicDictionary.setTitle(title);
        if (StringUtils.isEmpty((Object)dicDictionary.getOrderBy())) {
            dicDictionary.setOrderBy("ORDER_ID");
        }
        ArrayList<FscDicDictionaryBO> dicDictionaryBOS = new ArrayList<FscDicDictionaryBO>();
        List dicDictionaryPOS = this.dicDictionaryMapper.getListByCondition(dicDictionary);
        if (!CollectionUtils.isEmpty((Collection)dicDictionaryPOS)) {
            for (FscDicDictionaryPO dicDictionaryPO : dicDictionaryPOS) {
                FscDicDictionaryBO dicDictionaryBO = new FscDicDictionaryBO();
                BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dicDictionaryBO);
                dicDictionaryBOS.add(dicDictionaryBO);
            }
        }
        return dicDictionaryBOS;
    }

    public Map<String, String> queryBypCodeBackMap(String pCode) {
        return this.queryBypCodeBackMap(null, pCode);
    }

    public Map<String, String> queryBypCodeBackMap(String sysCode, String pCode) {
        List listPo = this.dicDictionaryMapper.getListByCondition(this.getDicDictionaryPO(sysCode, pCode));
        if (listPo == null || listPo.size() == 0) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (FscDicDictionaryPO po : listPo) {
            map.put(po.getCode(), po.getTitle());
        }
        return map;
    }

    public FscDicDictionaryBO getDictionaryByBO(FscDicDictionaryBO dicDictionaryBO) {
        FscDicDictionaryBO dictionaryBO = new FscDicDictionaryBO();
        FscDicDictionaryPO dicDictionaryModel = new FscDicDictionaryPO();
        BeanUtils.copyProperties((Object)dicDictionaryBO, (Object)dicDictionaryModel);
        FscDicDictionaryPO dicDictionaryPO = this.dicDictionaryMapper.getModelByCondition(dicDictionaryModel);
        if (null != dicDictionaryPO) {
            BeanUtils.copyProperties((Object)dicDictionaryPO, (Object)dictionaryBO);
        }
        return dictionaryBO;
    }

    public FscDicDictionaryPO getDicDictionaryPO(String sysCode, String pCode) {
        FscDicDictionaryPO queryDictionaryPO = new FscDicDictionaryPO();
        queryDictionaryPO.setPCode(pCode);
        if (StringUtils.isEmpty((Object)sysCode)) {
            sysCode = SYS_CODE_DEFAULT;
        }
        queryDictionaryPO.setSysCode(sysCode);
        return queryDictionaryPO;
    }

    public int updateDicDictionary(FscDicDictionaryReqBO dicDictionaryBO) {
        FscDicDictionaryPO dicDictionaryModel = new FscDicDictionaryPO();
        dicDictionaryModel.setTitle(dicDictionaryBO.getTitle());
        dicDictionaryModel.setOrderId(dicDictionaryBO.getOrderId());
        dicDictionaryModel.setDescrip(dicDictionaryBO.getDescrip());
        dicDictionaryModel.setDelFlag(dicDictionaryBO.getDelflag());
        dicDictionaryModel.setSysCode(dicDictionaryBO.getSysCode());
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        return this.dicDictionaryMapper.updateByCondition(dicDictionaryModel);
    }

    public int addDicDictionary(FscDicDictionaryReqBO dicDictionaryBO) {
        FscDicDictionaryPO dicDictionaryModel = new FscDicDictionaryPO();
        dicDictionaryModel.setTitle(dicDictionaryBO.getTitle());
        dicDictionaryModel.setOrderId(DIC_ORDER_ID);
        dicDictionaryModel.setDescrip(dicDictionaryBO.getDescrip());
        dicDictionaryModel.setDelFlag(dicDictionaryBO.getDelflag());
        dicDictionaryModel.setSysCode(dicDictionaryBO.getSysCode());
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        return this.dicDictionaryMapper.insert(dicDictionaryModel);
    }

    public int deleteDicDictionary(FscDicDictionaryReqBO dicDictionaryBO) {
        FscDicDictionaryPO dicDictionaryModel = new FscDicDictionaryPO();
        dicDictionaryModel.setCode(dicDictionaryBO.getCode());
        dicDictionaryModel.setPCode(dicDictionaryBO.getPCode());
        return this.dicDictionaryMapper.deleteByCondition(dicDictionaryModel);
    }

    public int checkDicBy(String code, String pCode) {
        FscDicDictionaryPO dicDictionaryModel = new FscDicDictionaryPO();
        dicDictionaryModel.setPCode(pCode);
        dicDictionaryModel.setCode(code);
        return this.dicDictionaryMapper.getCheckBy(dicDictionaryModel);
    }
}

