/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.atom.api.FscAccountCreateAtomService;
import com.tydic.fsc.atom.api.bo.FscAccountAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscAccountAtomRspBO;
import com.tydic.fsc.busi.api.FscMerchantCreateBusiService;
import com.tydic.fsc.busi.api.bo.FscMerchantCreateBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscMerchantCreateBusiRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.po.FscMerchantPO;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="fscMerchantCreateBusiService")
public class FscMerchantCreateBusiServiceImpl
implements FscMerchantCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantCreateBusiServiceImpl.class);
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscAccountCreateAtomService fscAccountCreateAtomService;

    public FscMerchantCreateBusiRspBo dealCreate(FscMerchantCreateBusiReqBO reqBo) {
        FscMerchantCreateBusiRspBo retBo = new FscMerchantCreateBusiRspBo();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        Date nowTime = this.fscMerchantMapper.getDBDate();
        FscAccountAtomReqBO accountAtomReqBo = new FscAccountAtomReqBO();
        accountAtomReqBo.setAccountName(reqBo.getOrgName());
        accountAtomReqBo.setAccountCategory(reqBo.getMerchantCategory());
        accountAtomReqBo.setOrgId(reqBo.getOrgId());
        accountAtomReqBo.setStatus(FscConstants.AccountStatus.VALID);
        accountAtomReqBo.setCreateMethod(FscConstants.AccountOpenMethod.AUTO);
        accountAtomReqBo.setCreateTime(nowTime);
        accountAtomReqBo.setCreateOperId(reqBo.getUserId().toString());
        FscAccountAtomRspBO accountAtomRetBo = this.fscAccountCreateAtomService.createAccount(accountAtomReqBo);
        if (!"0000".equals(accountAtomRetBo.getRespCode())) {
            throw new FscBusinessException("188888", "\u521b\u5efa\u8d26\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + accountAtomRetBo.getRespDesc());
        }
        retBo.setId(accountAtomRetBo.getAccountNo());
        FscMerchantPO queryReqBo = new FscMerchantPO();
        queryReqBo.setOrgId(reqBo.getOrgId());
        FscMerchantPO merchantPo = this.fscMerchantMapper.getModelBy(queryReqBo);
        if (merchantPo != null) {
            if (!FscConstants.MerchantStatus.DRAFT.equals(merchantPo.getStatus()) && !FscConstants.MerchantDeleteFlag.YES.equals(merchantPo.getDelFlag())) {
                log.info("\u6b64\u673a\u6784[ {} ]\uff0c\u5df2\u7ecf\u521b\u5efa\u4e86\u6709\u6548\u5546\u6237", (Object)reqBo.getOrgId());
                retBo.setRespCode("180000");
                retBo.setRespDesc("\u6b64\u673a\u6784[ " + reqBo.getOrgId() + " ]\uff0c\u5df2\u7ecf\u521b\u5efa\u4e86\u6709\u6548\u5546\u6237");
                return retBo;
            }
            if (FscConstants.MerchantStatus.DRAFT.equals(merchantPo.getStatus())) {
                BeanUtils.copyProperties((Object)reqBo, (Object)merchantPo);
                merchantPo.setUpdateOperId(reqBo.getUserId().toString());
                merchantPo.setUpdateOperName(reqBo.getName());
                merchantPo.setUpdateTime(nowTime);
                int result = this.fscMerchantMapper.updateById(merchantPo);
                if (result < 1) {
                    throw new FscBusinessException("188888", "\u5546\u6237\u4fe1\u606f\u5165\u8868\u5931\u8d25");
                }
                retBo.setMerchantId(merchantPo.getMerchantId());
                return retBo;
            }
        }
        Long merchantId = Sequence.getInstance().nextId();
        String merchantIdStr = merchantId.toString();
        String merchantNo = merchantIdStr.substring(merchantIdStr.length() - 4);
        merchantPo = new FscMerchantPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)merchantPo);
        merchantPo.setMerchantId(merchantId);
        merchantPo.setMerchantNo(merchantNo);
        merchantPo.setAccountId(Long.valueOf(accountAtomRetBo.getAccountId()));
        merchantPo.setCreateOperId(reqBo.getUserId().toString());
        merchantPo.setCreateOperName(reqBo.getName());
        merchantPo.setCreateTime(nowTime);
        merchantPo.setStatus(FscConstants.MerchantStatus.DRAFT);
        int result = this.fscMerchantMapper.insert(merchantPo);
        if (result < 1) {
            throw new FscBusinessException("188888", "\u5546\u6237\u4fe1\u606f\u5165\u8868\u5931\u8d25");
        }
        retBo.setMerchantId(merchantId);
        return retBo;
    }
}

