/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.fsc.atom.api.FscMerchantPayeeChannelAtomService;
import com.tydic.fsc.atom.api.bo.FscMerchantPayeeChannelAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscMerchantPayeeChannelAtomRspBO;
import com.tydic.fsc.atom.api.bo.FscMerchantPayeeChannelDataBO;
import com.tydic.fsc.busi.api.FscMerchantSubmitBusiService;
import com.tydic.fsc.busi.api.bo.FscMerchantSubmitBusiServiceReqBO;
import com.tydic.fsc.busi.api.bo.FscMerchantSubmitBusiServiceRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.po.FscMerchantPO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.external.api.pay.FscPayCreateMerchantService;
import com.tydic.fsc.external.api.pay.bo.FscPayCreateMerchantReqBo;
import com.tydic.fsc.external.api.pay.bo.FscPayCreateMerchantRspBo;
import com.tydic.fsc.external.api.pay.bo.FscPayMerchantPayChannelDataBo;
import com.tydic.fsc.external.api.pay.bo.FscPayRelMerchantBusiSysDataBo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="fscMerchantSubmitBusiService")
public class FscMerchantSubmitBusiServiceImpl
implements FscMerchantSubmitBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantSubmitBusiServiceImpl.class);
    @Value(value="${pay.center.busi.code:D500}")
    private String payBusiCode;
    @Value(value="${pay.center.req.way:1}")
    private String reqWay;
    private Set<String> reqWaySet = new HashSet<String>();
    private static final String PAY_CENTER_MERCHANT_STATUS_VALID = "1";
    @Autowired
    private FscMerchantPayeeChannelAtomService fscMerchantPayeeChannelAtomService;
    @Autowired
    private FscPayCreateMerchantService fscPayCreateMerchantService;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;

    public FscMerchantSubmitBusiServiceRspBO submitMerchant(FscMerchantSubmitBusiServiceReqBO reqBo) {
        FscMerchantSubmitBusiServiceRspBO retBo = new FscMerchantSubmitBusiServiceRspBO();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setRespCode("180000");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        CollectionUtil.addAll(this.reqWaySet, (Object[])this.reqWay.split(","));
        FscMerchantPayeeChannelAtomReqBO channelAtomReqBo = new FscMerchantPayeeChannelAtomReqBO();
        channelAtomReqBo.setMerchantId(reqBo.getMerchantId());
        FscMerchantPayeeChannelAtomRspBO channelAtomRetBo = this.fscMerchantPayeeChannelAtomService.queryPayChannel(channelAtomReqBo);
        if (!"0000".equals(channelAtomRetBo.getRespCode())) {
            BeanUtils.copyProperties((Object)channelAtomRetBo, (Object)retBo);
            return retBo;
        }
        FscPayCreateMerchantReqBo createReqBo = new FscPayCreateMerchantReqBo();
        createReqBo.setBusiCode(this.payBusiCode);
        createReqBo.setMerchantName(reqBo.getOrgName());
        createReqBo.setContactTel(reqBo.getContactPhone());
        createReqBo.setCreateOperId(reqBo.getUserId().toString());
        createReqBo.setRemark(reqBo.getRemark());
        createReqBo.setStatus(PAY_CENTER_MERCHANT_STATUS_VALID);
        ArrayList<FscPayRelMerchantBusiSysDataBo> relBusiSysList = new ArrayList<FscPayRelMerchantBusiSysDataBo>();
        for (String string : this.reqWaySet) {
            FscPayRelMerchantBusiSysDataBo relBusiSysInfo = new FscPayRelMerchantBusiSysDataBo();
            relBusiSysInfo.setReqWay(string);
            relBusiSysInfo.setRemark(reqBo.getRemark());
            relBusiSysList.add(relBusiSysInfo);
        }
        createReqBo.setRelBusiSysList(relBusiSysList);
        ArrayList<FscPayMerchantPayChannelDataBo> relPayInsList = new ArrayList<FscPayMerchantPayChannelDataBo>();
        for (FscMerchantPayeeChannelDataBO dataBo : channelAtomRetBo.getPayChannels()) {
            FscPayMerchantPayChannelDataBo relPayInsBo = new FscPayMerchantPayChannelDataBo();
            BeanUtils.copyProperties((Object)dataBo, (Object)relPayInsBo);
            relPayInsList.add(relPayInsBo);
        }
        createReqBo.setRelPayInsList(relPayInsList);
        FscPayCreateMerchantRspBo fscPayCreateMerchantRspBo = this.fscPayCreateMerchantService.createMerchant(createReqBo);
        if (!"0000".equals(fscPayCreateMerchantRspBo.getRespCode())) {
            BeanUtils.copyProperties((Object)fscPayCreateMerchantRspBo, (Object)retBo);
            return retBo;
        }
        FscMerchantPO updateMerchantPo = new FscMerchantPO();
        updateMerchantPo.setMerchantId(reqBo.getMerchantId());
        updateMerchantPo.setPayMerchantId(fscPayCreateMerchantRspBo.getPayMerchantId());
        updateMerchantPo.setStatus(FscConstants.MerchantStatus.VALID);
        int result = this.fscMerchantMapper.updateById(updateMerchantPo);
        if (result < 1) {
            throw new FscBusinessException("188888", "\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237ID\u5199\u5165\u8d26\u6237\u4fe1\u606f\u5931\u8d25");
        }
        return retBo;
    }

    private String validateArgs(FscMerchantSubmitBusiServiceReqBO reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff1a\u5546\u6237ID[merchantId]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrgId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff1a\u673a\u6784ID[orgId]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

