/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.ability.api.bo.FscMerchantBO;
import com.tydic.fsc.atom.api.FscMerchantAtomService;
import com.tydic.fsc.atom.api.bo.FscMerchantAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscMerchantAtomRspBo;
import com.tydic.fsc.atom.api.bo.FscMerchantPageQryAtomReqBo;
import com.tydic.fsc.atom.api.bo.FscMerchantPageQryAtomRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDicDictionaryMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.po.FscDicDictionaryPO;
import com.tydic.fsc.dao.po.FscMerchantPO;
import com.tydic.fsc.util.FscRspUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="fscMerchantAtomService")
public class FscMerchantAtomServiceImpl
implements FscMerchantAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantAtomServiceImpl.class);
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscDicDictionaryMapper fscDicDictionaryMapper;

    public FscMerchantAtomRspBo isMerchantCanEdit(FscMerchantAtomReqBO reqBO) {
        FscMerchantAtomRspBo retBo = (FscMerchantAtomRspBo)FscRspUtil.getRspBo((String)"180000", (String)"\u5931\u8d25", FscMerchantAtomRspBo.class);
        FscMerchantPO reqPo = new FscMerchantPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)reqPo);
        FscMerchantPO retPo = this.fscMerchantMapper.getModelBy(reqPo);
        if (null == retPo) {
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u6237ID[" + reqBO.getMerchantId() + "]\u7684\u4fe1\u606f");
            return retBo;
        }
        if (!FscConstants.MerchantStatus.DRAFT.equals(retPo.getStatus())) {
            retBo.setRespDesc("\u5546\u6237ID[" + reqBO.getMerchantId() + "]\u975e\u8349\u7a3f\u72b6\u6001\uff0c\u4e0d\u53ef\u7f16\u8f91");
            return retBo;
        }
        if (FscConstants.MerchantDeleteFlag.YES.equals(retPo.getDelFlag())) {
            retBo.setRespDesc("\u5546\u6237ID[" + reqBO.getMerchantId() + "]\u72b6\u6001\u4e3a\u5df2\u5220\u9664\uff0c\u4e0d\u53ef\u7f16\u8f91");
            return retBo;
        }
        retBo.setRespDesc("\u6210\u529f");
        retBo.setRespCode("0000");
        return retBo;
    }

    public FscMerchantPageQryAtomRspBo queryPage(FscMerchantPageQryAtomReqBo reqBo) {
        Page page;
        FscMerchantPageQryAtomRspBo retBo = (FscMerchantPageQryAtomRspBo)FscRspUtil.getSuccessRspBo(FscMerchantPageQryAtomRspBo.class);
        if (reqBo.getPageNo() > 1) {
            page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        Map<String, Map<String, String>> dicMap = this.getDicMap();
        FscMerchantPO queryPo = new FscMerchantPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)queryPo);
        List merchants = this.fscMerchantMapper.queryPage(queryPo, page);
        if (CollectionUtils.isEmpty((Collection)merchants)) {
            log.error("\u6839\u636e\u5165\u53c2\u672a\u67e5\u8be2\u67e5\u8be2\u6570\u636e\u5217\u8868\u4e3a\u7a7a\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
            retBo.setRespCode("180000");
            retBo.setRespDesc("\u67e5\u8be2\u5230\u7684\u6570\u636e\u5217\u8868\u4e3a\u7a7a");
            return retBo;
        }
        ArrayList<FscMerchantBO> rows = new ArrayList<FscMerchantBO>();
        for (FscMerchantPO merchantPo : merchants) {
            FscMerchantBO bo = new FscMerchantBO();
            BeanUtils.copyProperties((Object)merchantPo, (Object)bo);
            bo.setStatusStr(dicMap.get("MERCHANT_STATUS").get(bo.getStatus().toString()));
            bo.setMerchantTypeStr(dicMap.get("MERCHANT_TYPE").get(bo.getMerchantType().toString()));
            bo.setMerchantCategoryStr(dicMap.get("MERCHANT_CATEGORY").get(bo.getMerchantCategory().toString()));
            bo.setPayBusiSceneRangeStr(dicMap.get("MERCHANT_BUSI_SCENE").get(bo.getPayBusiSceneRange().toString()));
            bo.setPayUserIdentityStr(dicMap.get("MERCHANT_IDENTITY").get(bo.getPayUserIdentity().toString()));
            bo.setPayAllowExceptionFlagStr(dicMap.get("MERCHANT_ALLOW_EXCEPTION").get(bo.getPayAllowExceptionFlag().toString()));
            bo.setPayTypeStr(dicMap.get("MERCHANT_PAY_TYPE").get(bo.getPayType().toString()));
            bo.setPayRuleStr(dicMap.get("MERCHANT_PAY_RULE").get(bo.getPayRule().toString()));
            bo.setPayAccountDayRuleStr(dicMap.get("MERCHANT_DAY_RULE").get(bo.getPayAccountDayRule().toString()));
            bo.setPayNodeRuleStr(dicMap.get("MERCHANT_NODE_RULE").get(bo.getPayNodeRule().toString()));
            bo.setModelSceneRangeStr(dicMap.get("MERCHANT_SCENE_RANGE").get(bo.getModelSceneRange().toString()));
            bo.setModelUserIdentityStr(dicMap.get("MERCHANT_MODEL_IDENTITY").get(bo.getModelUserIdentity().toString()));
            bo.setModelAllowExceptionFlagStr(dicMap.get("MERCHANT_MODEL_ALLOW_EXCEPTION").get(bo.getModelAllowExceptionFlag().toString()));
            bo.setModelSettleStr(dicMap.get("MERCHANT_MODEL_SETTLE").get(bo.getModelSettle().toString()));
            bo.setExceptionFlagStr(dicMap.get("MERCHANT_IS_EXCEPTION").get(bo.getExceptionFlag().toString()));
            bo.setExceptionCategoryStr(dicMap.get("MERCHANT_EXCEPTION_CATEGORY").get(bo.getExceptionCategory().toString()));
            rows.add(bo);
        }
        retBo.setPageNo(reqBo.getPageNo());
        retBo.setRows(rows);
        retBo.setTotal(Integer.valueOf(page.getTotalPages()));
        retBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        return retBo;
    }

    private Map<String, Map<String, String>> getDicMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> dicPCodes = new ArrayList<String>();
        dicPCodes.add("MERCHANT_STATUS");
        dicPCodes.add("MERCHANT_TYPE");
        dicPCodes.add("MERCHANT_CATEGORY");
        dicPCodes.add("MERCHANT_BUSI_SCENE");
        dicPCodes.add("MERCHANT_MODEL_IDENTITY");
        dicPCodes.add("MERCHANT_IDENTITY");
        dicPCodes.add("MERCHANT_ALLOW_EXCEPTION");
        dicPCodes.add("MERCHANT_PAY_TYPE");
        dicPCodes.add("MERCHANT_PAY_RULE");
        dicPCodes.add("MERCHANT_MODEL_SETTLE");
        dicPCodes.add("MERCHANT_DAY_RULE");
        dicPCodes.add("MERCHANT_NODE_RULE");
        dicPCodes.add("MERCHANT_SCENE_RANGE");
        dicPCodes.add("MERCHANT_MODEL_ALLOW_EXCEPTION");
        dicPCodes.add("MERCHANT_EXCEPTION_CATEGORY");
        dicPCodes.add("MERCHANT_IS_EXCEPTION");
        FscDicDictionaryPO queryPo = new FscDicDictionaryPO();
        queryPo.setSysCode("FSC");
        for (String pCode : dicPCodes) {
            queryPo.setPCode(pCode);
            List dicDictionaryPos = this.fscDicDictionaryMapper.getListByCondition(queryPo);
            Map<String, String> map = dicDictionaryPos.stream().collect(Collectors.toMap(FscDicDictionaryPO::getCode, fscDicDictionaryPO -> fscDicDictionaryPO.getTitle()));
            dicMap.put(pCode, map);
        }
        return dicMap;
    }
}

