/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.atom.api.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscLogOrdBusiMapper;
import com.tydic.fsc.dao.FscOrdStateChgLogMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.po.FscLogOrdBusiPO;
import com.tydic.fsc.dao.po.FscOrdStateChgLogPO;
import com.tydic.fsc.dao.po.FscOrderPO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.osworkflow.engine.runtime.StepWithOutInstance;
import com.tydic.osworkflow.engine.runtime.TaskService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscOrderStatusFlowAtomServiceImpl
implements FscOrderStatusFlowAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderStatusFlowAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscLogOrdBusiMapper fscLogOrdBusiMapper;
    @Autowired
    private FscOrdStateChgLogMapper fscOrdStateChgLogMapper;
    @Autowired
    private TaskService taskService;

    public FscOrderStatusFlowAtomRspBO dealStatusFlow(FscOrderStatusFlowAtomReqBO reqBO) {
        this.val(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        List fscOrderPOS = this.fscOrderMapper.getList(fscOrderPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderPOS)) {
            throw new FscBusinessException("188888", "\u7ed3\u7b97\u72b6\u6001\u673a\u6ca1\u6709\u67e5\u8be2\u5230\u6d41\u7a0b\u5931\u8d25");
        }
        fscOrderPO = (FscOrderPO)fscOrderPOS.get(0);
        if (StringUtils.isBlank((CharSequence)fscOrderPO.getOrderFlowKey())) {
            throw new FscBusinessException("188888", "\u7ed3\u7b97\u72b6\u6001\u673a\u6ca1\u6709\u67e5\u8be2\u5230\u6d41\u7a0bKEY");
        }
        if (null == fscOrderPO) {
            throw new FscBusinessException("188888", "\u7ed3\u7b97\u72b6\u6001\u673a\u6ca1\u6709\u67e5\u8be2\u5230\u6d41\u7a0b");
        }
        String stepId = reqBO.getCurStatus().toString();
        if (log.isDebugEnabled()) {
            log.debug("\u72b6\u6001\u673a\u72b6\u6001\u5165\u53c2:{} id:{}", (Object)JSON.toJSONString((Object)reqBO), (Object)stepId);
        }
        StepWithOutInstance stepInstance = this.taskService.newTaskCompleteBuilder().procDefId(null).procDefKey(fscOrderPO.getOrderFlowKey()).sysCode("FSC").stepId(stepId).variables(reqBO.getParamMap()).completeWithOutInstance();
        if (log.isDebugEnabled()) {
            log.debug("\u72b6\u6001\u673a\u56de\u53c2:{} \u5165\u53c2:{} id:{}", new Object[]{JSON.toJSONString((Object)stepInstance), JSON.toJSONString((Object)reqBO), stepId});
        }
        Integer newStatus = this.string2Integer(stepInstance.getStepId());
        if (!stepInstance.getIsFinish().booleanValue()) {
            this.updateStatus(reqBO, newStatus);
        }
        this.writeLog(reqBO, fscOrderPO, newStatus);
        FscOrderStatusFlowAtomRspBO rspBO = new FscOrderStatusFlowAtomRspBO();
        rspBO.setIsAuto("AUTO".equals(stepInstance.getStepType()) ? FscConstants.IsAutoFLow.YES : FscConstants.IsAutoFLow.NO);
        rspBO.setNewStatus(newStatus);
        return rspBO;
    }

    private void val(FscOrderStatusFlowAtomReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("184000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u6d41\u8f6c\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getCurStatus()) {
            throw new FscBusinessException("184000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u6d41\u8f6c\u539f\u5b50\u670d\u52a1\u5931\u8d25,[curStatus]\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("184000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u6d41\u8f6c\u539f\u5b50\u670d\u52a1\u5931\u8d25,[OrderId]\u5165\u53c2\u4e3a\u7a7a");
        }
    }

    private Integer string2Integer(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new FscBusinessException("188888", "\u72b6\u6001\u673a\u539f\u5b50\u670d\u52a1\u7ed3\u7b97\u4e3b\u5355\u72b6\u6001\u8f6c\u6362\u5f02\u5e38");
        }
    }

    private void updateStatus(FscOrderStatusFlowAtomReqBO reqBO, Integer newStatus) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo.setOrderState(newStatus);
        this.fscOrderMapper.updateById(fscOrderPo);
    }

    private void writeLog(FscOrderStatusFlowAtomReqBO reqBO, FscOrderPO fscOrderPO, Integer newStatus) {
        FscLogOrdBusiPO fscLogOrdBusiPo = new FscLogOrdBusiPO();
        fscLogOrdBusiPo.setBusiName(reqBO.getBusiName());
        fscLogOrdBusiPo.setBusiType(fscOrderPO.getOrderFlow());
        fscLogOrdBusiPo.setCreateCompanyId(reqBO.getCompanyId());
        fscLogOrdBusiPo.setCreateCompanyName(reqBO.getCompanyName());
        fscLogOrdBusiPo.setCreateOperId(reqBO.getUserId());
        fscLogOrdBusiPo.setCreateOperName(reqBO.getName());
        fscLogOrdBusiPo.setCreateOrgId(reqBO.getOrgId());
        fscLogOrdBusiPo.setCreateOrgName(reqBO.getOrgName());
        fscLogOrdBusiPo.setCreateTime(new Date());
        fscLogOrdBusiPo.setFscOrderId(reqBO.getOrderId());
        this.fscLogOrdBusiMapper.insert(fscLogOrdBusiPo);
        FscOrdStateChgLogPO fscOrdStateChgLogPo = new FscOrdStateChgLogPO();
        fscOrdStateChgLogPo.setFscOrderId(fscOrderPO.getFscOrderId());
        fscOrdStateChgLogPo.setOldState(fscOrderPO.getOrderState());
        fscOrdStateChgLogPo.setNewState(newStatus);
        fscOrdStateChgLogPo.setChgTime(new Date());
        fscOrdStateChgLogPo.setOperId(reqBO.getUserId().toString());
        fscOrdStateChgLogPo.setChgDesc(reqBO.getBusiName());
        this.fscOrdStateChgLogMapper.insert(fscOrdStateChgLogPo);
    }
}

