/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.atom.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.atom.api.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscLogOrdBusiMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.po.FscLogOrdBusiPO;
import com.tydic.fsc.dao.po.FscOrderPO;
import com.tydic.fsc.enums.FscOrderFlowEnum;
import com.tydic.fsc.enums.FscOrderFlowProcKeyEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.osworkflow.engine.runtime.ProcessService;
import com.tydic.osworkflow.engine.runtime.StepWithOutInstance;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscOrderStatusStartAtomServiceImpl
implements FscOrderStatusStartAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderStatusStartAtomServiceImpl.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscLogOrdBusiMapper fscLogOrdBusiMapper;

    public FscOrderStatusStartAtomRspBO dealStatusStart(FscOrderStatusStartAtomReqBO reqBO) {
        this.val(reqBO);
        if (null == FscOrderFlowProcKeyEnum.getInstance((String)reqBO.getOrderFlow().toString())) {
            throw new FscBusinessException("188888", "\u8bf7\u914d\u7f6e\u679a\u4e3e");
        }
        String procKey = FscOrderFlowProcKeyEnum.getInstance((String)reqBO.getOrderFlow().toString()).getDescr();
        if (log.isDebugEnabled()) {
            log.debug("\u72b6\u6001\u673a\u542f\u52a8\u5165\u53c2:{} id:{}", (Object)JSON.toJSONString((Object)reqBO), (Object)procKey);
        }
        StepWithOutInstance stepInstance = this.processService.newProcessStartBuilder().procDefId(null).procDefKey(procKey).sysCode("FSC").startWithOutInstance();
        if (log.isDebugEnabled()) {
            log.debug("\u72b6\u6001\u673a\u542f\u52a8\u56de\u53c2:{} \u5165\u53c2:{} id:{}", new Object[]{JSON.toJSONString((Object)stepInstance), JSON.toJSONString((Object)reqBO), procKey});
        }
        Integer newStatus = this.string2Integer(stepInstance.getStepId());
        this.updateStatus(reqBO, newStatus, procKey);
        this.writeLog(reqBO, stepInstance);
        FscOrderStatusStartAtomRspBO rspBO = new FscOrderStatusStartAtomRspBO();
        rspBO.setIsAuto("AUTO".equals(stepInstance.getStepType()) ? FscConstants.IsAutoFLow.YES : FscConstants.IsAutoFLow.NO);
        rspBO.setNewStatus(newStatus);
        return rspBO;
    }

    private void val(FscOrderStatusStartAtomReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("184000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderFlow()) {
            throw new FscBusinessException("184000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,[OrderFlow]\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("184000", "\u7ed3\u7b97\u4e2d\u5fc3\u6838\u5fc3\u7ed3\u7b97\u72b6\u6001\u673a\u542f\u52a8\u539f\u5b50\u670d\u52a1\u5931\u8d25,[OrderId]\u5165\u53c2\u4e3a\u7a7a");
        }
    }

    private Integer string2Integer(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new FscBusinessException("188888", "\u72b6\u6001\u673a\u539f\u5b50\u670d\u52a1\u7ed3\u7b97\u4e3b\u5355\u72b6\u6001\u8f6c\u6362\u5f02\u5e38");
        }
    }

    private void updateStatus(FscOrderStatusStartAtomReqBO reqBO, Integer newStatus, String procKey) {
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo.setOrderFlowKey(procKey);
        fscOrderPo.setOrderState(newStatus);
        fscOrderPo.setCreateTimeStart(new Date());
        this.fscOrderMapper.updateById(fscOrderPo);
    }

    private void writeLog(FscOrderStatusStartAtomReqBO reqBO, StepWithOutInstance stepInstance) {
        FscLogOrdBusiPO fscLogOrdBusiPo = new FscLogOrdBusiPO();
        fscLogOrdBusiPo.setBusiName(FscOrderFlowEnum.getInstance((Integer)reqBO.getOrderFlow()).getDescr());
        fscLogOrdBusiPo.setBusiType(reqBO.getOrderFlow());
        fscLogOrdBusiPo.setCreateCompanyId(reqBO.getCompanyId());
        fscLogOrdBusiPo.setCreateCompanyName(reqBO.getCompanyName());
        fscLogOrdBusiPo.setCreateOperId(reqBO.getUserId());
        fscLogOrdBusiPo.setCreateOperName(reqBO.getName());
        fscLogOrdBusiPo.setCreateOrgId(reqBO.getOrgId());
        fscLogOrdBusiPo.setCreateOrgName(reqBO.getOrgName());
        fscLogOrdBusiPo.setCreateTime(new Date());
        fscLogOrdBusiPo.setFscOrderId(reqBO.getOrderId());
        this.fscLogOrdBusiMapper.insert(fscLogOrdBusiPo);
    }
}

