/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.common.ability.api.FscCashierBaseInfoEditAbilityService;
import com.tydic.fsc.common.ability.bo.FscCashierBaseInfoEditAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscCashierBaseInfoEditAbilityRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.FscRspUtil;
import com.tydic.payment.pay.atom.CashierTemplateAtomService;
import com.tydic.payment.pay.dao.CashierTemplateMapper;
import com.tydic.payment.pay.dao.PayMethodMapper;
import com.tydic.payment.pay.dao.po.CashierTemplatePo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscCashierBaseInfoEditAbilityService.class)
public class FscCashierBaseInfoEditAbilityServiceImpl
implements FscCashierBaseInfoEditAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscCashierBaseInfoEditAbilityServiceImpl.class);
    private static final int OPERATE_TYPE_ADD = 1;
    private static final int OPERATE_TYPE_UPDATE = 2;
    private static final int OPERATE_TYPE_DELETE = 3;
    @Autowired
    private CashierTemplateMapper cashierTemplateMapper;
    @Autowired
    private CashierTemplateAtomService cashierTemplateAtomService;
    @Autowired
    private PayMethodMapper payMethodMapper;

    public FscCashierBaseInfoEditAbilityRspBO editCashierBaseInfo(FscCashierBaseInfoEditAbilityReqBO reqBO) {
        Long cashierTemplate;
        if (log.isDebugEnabled()) {
            log.debug("=========\u6536\u94f6\u53f0\u57fa\u672c\u4fe1\u606f\u7f16\u8f91\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        FscCashierBaseInfoEditAbilityRspBO retBO = (FscCashierBaseInfoEditAbilityRspBO)FscRspUtil.getSuccessRspBo(FscCashierBaseInfoEditAbilityRspBO.class);
        this.validateArgs(reqBO);
        switch (reqBO.getOperateType()) {
            case 1: {
                cashierTemplate = this.createCashier(reqBO);
                break;
            }
            case 2: {
                cashierTemplate = this.updateCashier(reqBO);
                break;
            }
            case 3: {
                cashierTemplate = this.deleteCashier(reqBO);
                break;
            }
            default: {
                throw new FscBusinessException("191111", "\u64cd\u4f5c\u7c7b\u578b\u975e\u6cd5");
            }
        }
        retBO.setCashierTemplate(cashierTemplate);
        if (log.isDebugEnabled()) {
            log.debug("=========\u6536\u94f6\u53f0\u57fa\u672c\u4fe1\u606f\u7f16\u8f91\u7ed3\u675f\uff1a{}", (Object)JSON.toJSONString((Object)retBO));
        }
        return retBO;
    }

    private Long deleteCashier(FscCashierBaseInfoEditAbilityReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("=========\u672c\u6b21\u6267\u884c\u7684\u64cd\u4f5c\u4e3a\uff1a\u5220\u9664\u6536\u94f6\u53f0");
        }
        CashierTemplatePo cashierPo = new CashierTemplatePo();
        cashierPo.setCashierTemplate(reqBO.getCashierTemplate());
        int result = this.cashierTemplateAtomService.deleteCashierTemplate(cashierPo);
        if (result < 1) {
            throw new FscBusinessException("191111", "\u5220\u9664\u6536\u94f6\u53f0\u5931\u8d25\uff1b\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        return reqBO.getCashierTemplate();
    }

    private Long createCashier(FscCashierBaseInfoEditAbilityReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("=========\u672c\u6b21\u6267\u884c\u7684\u64cd\u4f5c\u4e3a\uff1a\u65b0\u589e\u6536\u94f6\u53f0");
        }
        CashierTemplatePo createPo = new CashierTemplatePo();
        BeanUtils.copyProperties((Object)reqBO, (Object)createPo);
        Date nowTime = this.payMethodMapper.getDBDate().getDate();
        CashierTemplatePo validateCodePo = new CashierTemplatePo();
        validateCodePo.setCashierCode(reqBO.getCashierCode());
        List validateCodeList = this.cashierTemplateMapper.queryCashierTemplateByCondition(validateCodePo);
        if (!CollectionUtils.isEmpty((Collection)validateCodeList)) {
            validateCodePo = (CashierTemplatePo)validateCodeList.get(0);
            if (!"2".equals(validateCodePo.getFlag())) {
                throw new FscBusinessException("191111", "\u6536\u94f6\u53f0\u6a21\u677f\u7f16\u7801\u5df2\u5b58\u5728");
            }
            createPo.setUpdateOperId(reqBO.getName());
            createPo.setUpdateTime(nowTime);
            createPo.setCashierTemplate(validateCodePo.getCashierTemplate());
        }
        CashierTemplatePo validateNamePo = new CashierTemplatePo();
        validateNamePo.setCashierTemplateName(reqBO.getCashierTemplateName());
        List validateNameList = this.cashierTemplateMapper.queryCashierTemplateByCondition(validateNamePo);
        if (!CollectionUtils.isEmpty((Collection)validateNameList)) {
            validateNamePo = (CashierTemplatePo)validateNameList.get(0);
            if (!"2".equals(validateNamePo.getFlag())) {
                throw new FscBusinessException("191111", "\u6536\u94f6\u53f0\u540d\u79f0\u5df2\u5b58\u5728");
            }
            createPo.setUpdateOperId(reqBO.getName());
            createPo.setUpdateTime(nowTime);
            createPo.setCashierTemplate(validateCodePo.getCashierTemplate());
        }
        if (!(CollectionUtils.isEmpty((Collection)validateCodeList) || CollectionUtils.isEmpty((Collection)validateNameList) || validateCodePo.getCashierTemplate().equals(validateNamePo.getCashierTemplate()))) {
            throw new FscBusinessException("191111", "\u6536\u94f6\u53f0\u6a21\u677f\u7f16\u7801\u548c\u540d\u79f0\u4e0d\u5339\u914d");
        }
        if (!CollectionUtils.isEmpty((Collection)validateCodeList) || !CollectionUtils.isEmpty((Collection)validateNameList)) {
            int result = this.cashierTemplateAtomService.updateCashierTemplate(createPo);
            if (result < 1) {
                throw new FscBusinessException("191111", "\u66f4\u65b0\u6a21\u677f\u4fe1\u606f\u5931\u8d25");
            }
            return createPo.getCashierTemplate();
        }
        createPo.setCreateOperId(reqBO.getName());
        createPo.setCreateTime(nowTime);
        return this.cashierTemplateAtomService.createCashierTemplate(createPo);
    }

    private Long updateCashier(FscCashierBaseInfoEditAbilityReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("=========\u672c\u6b21\u6267\u884c\u7684\u64cd\u4f5c\u4e3a\uff1a\u4fee\u6539\u6536\u94f6\u53f0");
        }
        CashierTemplatePo validateCodePo = new CashierTemplatePo();
        validateCodePo.setCashierCode(reqBO.getCashierCode());
        List validateCodeList = this.cashierTemplateMapper.queryCashierTemplateByCondition(validateCodePo);
        if (!CollectionUtils.isEmpty((Collection)validateCodeList)) {
            validateCodePo = (CashierTemplatePo)validateCodeList.get(0);
            if (!reqBO.getCashierTemplate().equals(validateCodePo.getCashierTemplate())) {
                throw new FscBusinessException("191111", "\u6536\u94f6\u53f0\u7f16\u7801\u5df2\u5b58\u5728");
            }
        }
        CashierTemplatePo validateNamePo = new CashierTemplatePo();
        validateNamePo.setCashierTemplateName(reqBO.getCashierTemplateName());
        List validateNameList = this.cashierTemplateMapper.queryCashierTemplateByCondition(validateNamePo);
        if (!CollectionUtils.isEmpty((Collection)validateNameList)) {
            validateNamePo = (CashierTemplatePo)validateNameList.get(0);
            if (!reqBO.getCashierTemplate().equals(validateNamePo.getCashierTemplate())) {
                throw new FscBusinessException("191111", "\u6536\u94f6\u53f0\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
        Date nowTime = this.payMethodMapper.getDBDate().getDate();
        CashierTemplatePo updatePo = new CashierTemplatePo();
        BeanUtils.copyProperties((Object)reqBO, (Object)updatePo);
        updatePo.setUpdateOperId(reqBO.getName());
        updatePo.setUpdateTime(nowTime);
        int result = this.cashierTemplateAtomService.updateCashierTemplate(updatePo);
        if (result < 1) {
            log.error("\u66f4\u65b0\u6536\u94f6\u53f0\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            throw new FscBusinessException("191111", "\u66f4\u65b0\u6536\u94f6\u53f0\u5931\u8d25");
        }
        return reqBO.getCashierTemplate();
    }

    private void validateArgs(FscCashierBaseInfoEditAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperateType()) {
            throw new FscBusinessException("191000", "\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (3 == reqBO.getOperateType()) {
            if (null == reqBO.getCashierTemplate()) {
                throw new FscBusinessException("191000", "\u5220\u9664\u65f6\uff0c\u6536\u94f6\u53f0ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return;
        }
        if (2 == reqBO.getOperateType() && reqBO.getCashierTemplate() == null) {
            throw new FscBusinessException("191000", "\u4fee\u6539\u65f6\uff0c\u6536\u94f6\u53f0ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getCashierCode())) {
            throw new FscBusinessException("191000", "\u6536\u94f6\u53f0\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getCashierTemplateName())) {
            throw new FscBusinessException("191000", "\u6536\u94f6\u53f0\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getReqWay())) {
            throw new FscBusinessException("191000", "\u9002\u7528\u573a\u666f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getCashierTemplateUrl())) {
            throw new FscBusinessException("191000", "\u6536\u94f6\u53f0\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getFlag())) {
            throw new FscBusinessException("191000", "\u6536\u94f6\u53f0\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

