/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.InvoicePostBO;
import com.tydic.fsc.bo.OrderInvoiceBO;
import com.tydic.fsc.bo.OrderPayBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.pay.FscPayTransPayInsService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsReqBo;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsRspBo;
import com.tydic.fsc.common.ability.api.FscComOrderDetailQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoicePostMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscCheckResultPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscComOrderDetailQueryAbilityService.class)
public class FscComOrderDetailQueryAbilityServiceImpl
implements FscComOrderDetailQueryAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoicePostMapper fscInvoicePostMapper;
    @Autowired
    private FscPayTransPayInsService fscPayTransPayInsService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @BigDecimalConvert(value=2)
    public FscComOrderDetailQueryAbilityRspBO qryOrderDetail(FscComOrderDetailQueryAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2OrderId\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (null == fscOrderPo) {
            return new FscComOrderDetailQueryAbilityRspBO();
        }
        FscComOrderDetailQueryAbilityRspBO rspBO = (FscComOrderDetailQueryAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderPo), FscComOrderDetailQueryAbilityRspBO.class);
        rspBO.setOrderFlowStr(Objects.requireNonNull(FscOrderFlowEnum.getInstance((Integer)rspBO.getOrderFlow())).getDescr());
        if (!StringUtils.isEmpty((Object)rspBO.getPayChannel())) {
            FscPayTransPayInsReqBo fscPayTransPayInsReqBo = new FscPayTransPayInsReqBo();
            fscPayTransPayInsReqBo.setPaymentInsId(Collections.singletonList(Long.parseLong(rspBO.getPayChannel())));
            FscPayTransPayInsRspBo fscPayTransPayInsRspBo = this.fscPayTransPayInsService.tranPayIns(fscPayTransPayInsReqBo);
            if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo)) {
                if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo.getPayInsMap())) {
                    rspBO.setPayChannelStr((String)fscPayTransPayInsRspBo.getPayInsMap().get(rspBO.getPayChannel()));
                }
                if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo.getPayMethodMap())) {
                    rspBO.setPayMethodStr((String)fscPayTransPayInsRspBo.getPayMethodMap().get(rspBO.getPayMethod()));
                }
            }
        }
        Map orderStateMap = 0 == fscOrderPo.getOrderFlow() ? this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_LIST_STATE") : this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SERVICE_LIST_STATE");
        rspBO.setOrderStateStr((String)orderStateMap.get(rspBO.getOrderState() + ""));
        Map payTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_CFC_PAY_TYPE_ALLOW");
        rspBO.setPayTypeStr((String)payTypeMap.get(rspBO.getPayType() + ""));
        FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
        fscOrderInvoicePo.setFscOrderId(reqBO.getOrderId());
        fscOrderInvoicePo = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePo);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(reqBO.getOrderId());
        List fscInvoicePOS = this.fscInvoiceMapper.getList(fscInvoicePO);
        OrderInvoiceBO orderInvoiceBO = new OrderInvoiceBO();
        if (!StringUtils.isEmpty((Object)fscOrderInvoicePo)) {
            rspBO.setSignOperName(fscOrderInvoicePo.getSignOperName());
            rspBO.setSignTime(fscOrderInvoicePo.getSignTime());
            orderInvoiceBO = (OrderInvoiceBO)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderInvoicePo), OrderInvoiceBO.class);
            Map InvoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY");
            Map invoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_TYPE");
            if (!StringUtils.isEmpty((Object)fscOrderInvoicePo.getInvoiceCategory())) {
                orderInvoiceBO.setInvoiceCategoryStr((String)InvoiceCategoryMap.get(String.valueOf(fscOrderInvoicePo.getInvoiceCategory())));
            }
            if (!StringUtils.isEmpty((Object)fscOrderInvoicePo.getInvoiceType())) {
                orderInvoiceBO.setInvoiceTypeStr((String)invoiceTypeMap.get(fscOrderInvoicePo.getInvoiceType()));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)fscInvoicePOS)) {
            ArrayList<OrderInvoiceBO> orderInvoiceBOS = new ArrayList<OrderInvoiceBO>(fscInvoicePOS.size());
            for (FscInvoicePO invoicePO : fscInvoicePOS) {
                OrderInvoiceBO orderInvoiceBO1 = new OrderInvoiceBO();
                BeanUtils.copyProperties((Object)orderInvoiceBO, (Object)orderInvoiceBO1);
                orderInvoiceBO1.setInvoiceCode(invoicePO.getInvoiceCode());
                orderInvoiceBO1.setInvoiceNo(invoicePO.getInvoiceNo());
                orderInvoiceBO1.setBillDate(invoicePO.getBillDate());
                orderInvoiceBO1.setProvince(fscOrderInvoicePo.getProvince());
                orderInvoiceBO1.setCity(fscOrderInvoicePo.getCity());
                orderInvoiceBO1.setArea(fscOrderInvoicePo.getArea());
                orderInvoiceBO1.setTown(fscOrderInvoicePo.getTown());
                orderInvoiceBOS.add(orderInvoiceBO1);
            }
            rspBO.setOrderInvoiceInfo(orderInvoiceBOS);
            List mailIds = fscInvoicePOS.stream().map(FscInvoicePO::getMailId).collect(Collectors.toList());
            List fscInvoicePostList = this.fscInvoicePostMapper.getListByIds(mailIds);
            if (!CollectionUtils.isEmpty((Collection)fscInvoicePostList)) {
                List invoicePostList = JSON.parseArray((String)JSON.toJSONString((Object)fscInvoicePostList), InvoicePostBO.class);
                rspBO.setInvoicePostList(invoicePostList);
            }
            rspBO.setBillDate(((FscInvoicePO)fscInvoicePOS.get(0)).getBillDate());
        } else if (!StringUtils.isEmpty((Object)fscOrderInvoicePo)) {
            rspBO.setOrderInvoiceInfo(Collections.singletonList(orderInvoiceBO));
        }
        FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
        fscAttachmentPo.setFscOrderId(reqBO.getOrderId());
        List fscAttachmentPOS = this.fscAttachmentMapper.getList(fscAttachmentPo);
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS)) {
            ArrayList<String> attUrls = new ArrayList<String>(fscAttachmentPOS.size());
            for (FscAttachmentPO fscAttachmentPO : fscAttachmentPOS) {
                attUrls.add(fscAttachmentPO.getAttachmentUrl());
            }
            List attachmentBOS = JSON.parseArray((String)JSON.toJSONString((Object)fscAttachmentPOS), AttachmentBO.class);
            rspBO.setAttachmentList(attachmentBOS);
            rspBO.setPayEvidenceUrls(attUrls);
        }
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setFscOrderId(reqBO.getOrderId());
        List fscShouldPayPOS = null;
        List fscOrderPayItemMapperList = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
        Map<Long, BigDecimal> fscOrderPayItemPOMap = null;
        if (!CollectionUtils.isEmpty((Collection)fscOrderPayItemMapperList)) {
            fscOrderPayItemPOMap = fscOrderPayItemMapperList.stream().collect(Collectors.toMap(FscOrderPayItemPO::getShouldPayId, FscOrderPayItemPO::getPayAmount));
            List shouldPayIds = fscOrderPayItemMapperList.stream().map(FscOrderPayItemPO::getShouldPayId).collect(Collectors.toList());
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setShouldPayIds(shouldPayIds);
            fscShouldPayPOS = this.fscShouldPayMapper.getList(fscShouldPayPO);
        }
        if (!CollectionUtils.isEmpty(fscShouldPayPOS)) {
            List orderPayBOS = JSON.parseArray((String)JSON.toJSONString(fscShouldPayPOS), OrderPayBO.class);
            if (!CollectionUtils.isEmpty(fscOrderPayItemPOMap)) {
                for (OrderPayBO orderPayBO : orderPayBOS) {
                    orderPayBO.setPayAmount(fscOrderPayItemPOMap.get(orderPayBO.getShouldPayId()));
                }
            }
            rspBO.setOrderPayList(orderPayBOS);
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderId(reqBO.getOrderId());
        if (FscConstants.OrderFlow.PAY.equals(rspBO.getOrderFlow())) {
            FscOrderPayItemPO fscOrderPayItem = new FscOrderPayItemPO();
            fscOrderPayItem.setFscOrderId(reqBO.getOrderId());
            List fscOrderPayItemList = this.fscOrderPayItemMapper.getList(fscOrderPayItem);
            if (!CollectionUtils.isEmpty((Collection)fscOrderPayItemList)) {
                rspBO.setOrderNum(Integer.valueOf(fscOrderPayItemList.size()));
            }
        } else {
            Integer orderNum = this.fscOrderRelationMapper.getCheckBy(fscOrderRelationPo);
            rspBO.setOrderNum(orderNum);
        }
        fscOrderRelationPo = this.fscOrderRelationMapper.getModelByLimit(fscOrderRelationPo);
        if (null != fscOrderRelationPo && null != fscOrderRelationPo.getAcceptOrderId()) {
            FscCheckResultPO fscCheckResultPO = new FscCheckResultPO();
            fscCheckResultPO.setAcceptOrderId(fscOrderRelationPo.getAcceptOrderId());
            List fscCheckResultPOS = this.fscCheckResultMapper.getList(fscCheckResultPO);
            if (!CollectionUtils.isEmpty((Collection)fscCheckResultPOS)) {
                rspBO.setCheckOperName(((FscCheckResultPO)fscCheckResultPOS.get(0)).getOperName());
            }
        }
        return rspBO;
    }
}

