/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.fsc.bo.FscPayChannelDataBO;
import com.tydic.fsc.bo.FscPayMethodDataBO;
import com.tydic.fsc.busibase.external.api.pay.FscPayTransPayInsService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsReqBo;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsRspBo;
import com.tydic.fsc.common.ability.api.FscMerchantRelChannelQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscMerchantRelChannelQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscMerchantRelChannelQueryAbilityRspBO;
import com.tydic.fsc.dao.FscMerchantPayeeChannelMapper;
import com.tydic.fsc.po.FscMerchantPayeeChannelPO;
import com.tydic.fsc.util.FscRspUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscMerchantRelChannelQueryAbilityService.class)
public class FscMerchantRelChannelQueryAbilityServiceImpl
implements FscMerchantRelChannelQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantRelChannelQueryAbilityServiceImpl.class);
    private static final String PAY_METHOD_STATUS_USED = "1";
    @Autowired
    private FscMerchantPayeeChannelMapper fscMerchantPayeeChannelMapper;
    @Autowired
    private FscPayTransPayInsService fscPayTransPayInsService;

    public FscMerchantRelChannelQueryAbilityRspBO queryRelChannel(FscMerchantRelChannelQueryAbilityReqBO reqBO) {
        FscMerchantRelChannelQueryAbilityRspBO retBo = (FscMerchantRelChannelQueryAbilityRspBO)FscRspUtil.getSuccessRspBo(FscMerchantRelChannelQueryAbilityRspBO.class);
        if (null == reqBO.getMerchantId()) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u5546\u6237ID[merchantId]\u4e0d\u80fd\u4e3a\u7a7a");
            retBo.setRespCode("191000");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u5546\u6237ID[merchantId]\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        FscMerchantPayeeChannelPO queryReqPo = new FscMerchantPayeeChannelPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryReqPo);
        List channelPos = this.fscMerchantPayeeChannelMapper.getList(queryReqPo);
        if (CollectionUtils.isEmpty((Collection)channelPos)) {
            log.info("\u672a\u67e5\u8be2\u5230\u5546\u6237[{}]\u914d\u7f6e\u7684\u652f\u4ed8\u6e20\u9053\u4fe1\u606f", (Object)reqBO.getMerchantId());
            retBo.setRespCode("191129");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u6237[" + reqBO.getMerchantId() + "]\u914d\u7f6e\u7684\u652f\u4ed8\u6e20\u9053\u4fe1\u606f");
            return retBo;
        }
        List paymentInsId = channelPos.stream().map(item -> Long.valueOf(item.getPayChannel())).collect(Collectors.toList());
        FscPayTransPayInsReqBo transReqBo = new FscPayTransPayInsReqBo();
        transReqBo.setPaymentInsId(paymentInsId);
        FscPayTransPayInsRspBo transRetBo = this.fscPayTransPayInsService.tranPayIns(transReqBo);
        if (!"0000".equals(transRetBo.getRespCode())) {
            BeanUtils.copyProperties((Object)transRetBo, (Object)retBo);
            return retBo;
        }
        Map payInsMap = transRetBo.getPayInsMap();
        Map payMethodMap = transRetBo.getPayMethodMap();
        ArrayList<FscPayChannelDataBO> channelList = new ArrayList<FscPayChannelDataBO>();
        for (FscMerchantPayeeChannelPO channelPo : channelPos) {
            FscPayChannelDataBO channelDataBo = new FscPayChannelDataBO();
            channelDataBo.setPaymentInsId(Long.valueOf(channelPo.getPayChannel()));
            channelDataBo.setPaymentInsName((String)payInsMap.get(channelPo.getPayChannel()));
            ArrayList<FscPayMethodDataBO> payMethodList = new ArrayList<FscPayMethodDataBO>();
            channelDataBo.setPayMethodList(payMethodList);
            List<String> payMethods = Arrays.asList(channelPo.getPayMethod().split(","));
            for (String payMethod : payMethods) {
                FscPayMethodDataBO payMethodDataBo = new FscPayMethodDataBO();
                payMethodDataBo.setPayMethod(Long.valueOf(payMethod));
                payMethodDataBo.setPayMethodName((String)payMethodMap.get(payMethod));
                payMethodDataBo.setPayMethodStatus(PAY_METHOD_STATUS_USED);
                payMethodList.add(payMethodDataBo);
            }
            channelList.add(channelDataBo);
        }
        retBo.setChannels(channelList);
        return retBo;
    }
}

